import{u as fi,r as Vn,c as Je,a as F,t as Ci,b as Yn,d as Pt,e as xe,w as yi,v as Ti,f as Ai,F as Ii,g as Ei,A as $n,h as vi,C as Si,S as wi,o as Xe,i as Qn}from"./index-DmuMlZ3m.js";import{e as _i}from"./errorMsg-Cox1D_U3.js";const ki="data:image/png;base64,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";/*! @azure/msal-common v14.16.0 2024-11-05 */const u={LIBRARY_NAME:"MSAL.JS",SKU:"msal.js.common",CACHE_PREFIX:"msal",DEFAULT_AUTHORITY:"https://login.microsoftonline.com/common/",DEFAULT_AUTHORITY_HOST:"login.microsoftonline.com",DEFAULT_COMMON_TENANT:"common",ADFS:"adfs",DSTS:"dstsv2",AAD_INSTANCE_DISCOVERY_ENDPT:"https://login.microsoftonline.com/common/discovery/instance?api-version=1.1&authorization_endpoint=",CIAM_AUTH_URL:".ciamlogin.com",AAD_TENANT_DOMAIN_SUFFIX:".onmicrosoft.com",RESOURCE_DELIM:"|",NO_ACCOUNT:"NO_ACCOUNT",CLAIMS:"claims",CONSUMER_UTID:"9188040d-6c67-4c5b-b112-36a304b66dad",OPENID_SCOPE:"openid",PROFILE_SCOPE:"profile",OFFLINE_ACCESS_SCOPE:"offline_access",EMAIL_SCOPE:"email",CODE_RESPONSE_TYPE:"code",CODE_GRANT_TYPE:"authorization_code",RT_GRANT_TYPE:"refresh_token",FRAGMENT_RESPONSE_MODE:"fragment",S256_CODE_CHALLENGE_METHOD:"S256",URL_FORM_CONTENT_TYPE:"application/x-www-form-urlencoded;charset=utf-8",AUTHORIZATION_PENDING:"authorization_pending",NOT_DEFINED:"not_defined",EMPTY_STRING:"",NOT_APPLICABLE:"N/A",NOT_AVAILABLE:"Not Available",FORWARD_SLASH:"/",IMDS_ENDPOINT:"http://169.254.169.254/metadata/instance/compute/location",IMDS_VERSION:"2020-06-01",IMDS_TIMEOUT:2e3,AZURE_REGION_AUTO_DISCOVER_FLAG:"TryAutoDetect",REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX:"login.microsoft.com",KNOWN_PUBLIC_CLOUDS:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"],TOKEN_RESPONSE_TYPE:"token",ID_TOKEN_RESPONSE_TYPE:"id_token",SHR_NONCE_VALIDITY:240,INVALID_INSTANCE:"invalid_instance"},Ze={SUCCESS:200,SUCCESS_RANGE_START:200,SUCCESS_RANGE_END:299,REDIRECT:302,CLIENT_ERROR:400,CLIENT_ERROR_RANGE_START:400,BAD_REQUEST:400,UNAUTHORIZED:401,NOT_FOUND:404,REQUEST_TIMEOUT:408,TOO_MANY_REQUESTS:429,CLIENT_ERROR_RANGE_END:499,SERVER_ERROR:500,SERVER_ERROR_RANGE_START:500,SERVICE_UNAVAILABLE:503,GATEWAY_TIMEOUT:504,SERVER_ERROR_RANGE_END:599,MULTI_SIDED_ERROR:600},De=[u.OPENID_SCOPE,u.PROFILE_SCOPE,u.OFFLINE_ACCESS_SCOPE],Wn=[...De,u.EMAIL_SCOPE],G={CONTENT_TYPE:"Content-Type",CONTENT_LENGTH:"Content-Length",RETRY_AFTER:"Retry-After",CCS_HEADER:"X-AnchorMailbox",WWWAuthenticate:"WWW-Authenticate",AuthenticationInfo:"Authentication-Info",X_MS_REQUEST_ID:"x-ms-request-id",X_MS_HTTP_VERSION:"x-ms-httpver"},H={ID_TOKEN:"idtoken",CLIENT_INFO:"client.info",ADAL_ID_TOKEN:"adal.idtoken",ERROR:"error",ERROR_DESC:"error.description",ACTIVE_ACCOUNT:"active-account",ACTIVE_ACCOUNT_FILTERS:"active-account-filters"},me={COMMON:"common",ORGANIZATIONS:"organizations",CONSUMERS:"consumers"},et={ACCESS_TOKEN:"access_token",XMS_CC:"xms_cc"},D={LOGIN:"login",SELECT_ACCOUNT:"select_account",CONSENT:"consent",NONE:"none",CREATE:"create",NO_SESSION:"no_session"},jn={PLAIN:"plain",S256:"S256"},Ye={QUERY:"query",FRAGMENT:"fragment"},Ri={...Ye,FORM_POST:"form_post"},Ro={IMPLICIT_GRANT:"implicit",AUTHORIZATION_CODE_GRANT:"authorization_code",CLIENT_CREDENTIALS_GRANT:"client_credentials",RESOURCE_OWNER_PASSWORD_GRANT:"password",REFRESH_TOKEN_GRANT:"refresh_token",DEVICE_CODE_GRANT:"device_code",JWT_BEARER:"urn:ietf:params:oauth:grant-type:jwt-bearer"},tt={MSSTS_ACCOUNT_TYPE:"MSSTS",ADFS_ACCOUNT_TYPE:"ADFS",MSAV1_ACCOUNT_TYPE:"MSA",GENERIC_ACCOUNT_TYPE:"Generic"},B={CACHE_KEY_SEPARATOR:"-",CLIENT_INFO_SEPARATOR:"."},E={ID_TOKEN:"IdToken",ACCESS_TOKEN:"AccessToken",ACCESS_TOKEN_WITH_AUTH_SCHEME:"AccessToken_With_AuthScheme",REFRESH_TOKEN:"RefreshToken"},tn="appmetadata",bi="client_info",Fe="1",ct={CACHE_KEY:"authority-metadata",REFRESH_TIME_SECONDS:3600*24},V={CONFIG:"config",CACHE:"cache",NETWORK:"network",HARDCODED_VALUES:"hardcoded_values"},K={SCHEMA_VERSION:5,MAX_CUR_HEADER_BYTES:80,MAX_LAST_HEADER_BYTES:330,MAX_CACHED_ERRORS:50,CACHE_KEY:"server-telemetry",CATEGORY_SEPARATOR:"|",VALUE_SEPARATOR:",",OVERFLOW_TRUE:"1",OVERFLOW_FALSE:"0",UNKNOWN_ERROR:"unknown_error"},R={BEARER:"Bearer",POP:"pop",SSH:"ssh-cert"},Ge={DEFAULT_THROTTLE_TIME_SECONDS:60,DEFAULT_MAX_THROTTLE_TIME_SECONDS:3600,THROTTLING_PREFIX:"throttling",X_MS_LIB_CAPABILITY_VALUE:"retry-after, h429"},Jn={INVALID_GRANT_ERROR:"invalid_grant",CLIENT_MISMATCH_ERROR:"client_mismatch"},Xn={username:"username",password:"password"},nt={httpSuccess:200,httpBadRequest:400},Se={FAILED_AUTO_DETECTION:"1",INTERNAL_CACHE:"2",ENVIRONMENT_VARIABLE:"3",IMDS:"4"},Mt={CONFIGURED_MATCHES_DETECTED:"1",CONFIGURED_NO_AUTO_DETECTION:"2",CONFIGURED_NOT_DETECTED:"3",AUTO_DETECTION_REQUESTED_SUCCESSFUL:"4",AUTO_DETECTION_REQUESTED_FAILED:"5"},ge={NOT_APPLICABLE:"0",FORCE_REFRESH_OR_CLAIMS:"1",NO_CACHED_ACCESS_TOKEN:"2",CACHED_ACCESS_TOKEN_EXPIRED:"3",PROACTIVELY_REFRESHED:"4"},Oi={Jwt:"JWT",Jwk:"JWK",Pop:"pop"},Ni=300;/*! @azure/msal-common v14.16.0 2024-11-05 */const nn="unexpected_error",Pi="post_request_failed";/*! @azure/msal-common v14.16.0 2024-11-05 */const Zn={[nn]:"Unexpected error in authentication.",[Pi]:"Post request failed from the network, could be a 4xx/5xx or a network unavailability. Please check the exact error code for details."};class P extends Error{constructor(e,t,n){const o=t?`${e}: ${t}`:e;super(o),Object.setPrototypeOf(this,P.prototype),this.errorCode=e||u.EMPTY_STRING,this.errorMessage=t||u.EMPTY_STRING,this.subError=n||u.EMPTY_STRING,this.name="AuthError"}setCorrelationId(e){this.correlationId=e}}function bo(a,e){return new P(a,e?`${Zn[a]} ${e}`:Zn[a])}/*! @azure/msal-common v14.16.0 2024-11-05 */const on="client_info_decoding_error",Oo="client_info_empty_error",rn="token_parsing_error",No="null_or_empty_token",ae="endpoints_resolution_error",Po="network_error",Mo="openid_config_error",Uo="hash_not_deserialized",Me="invalid_state",Lo="state_mismatch",lt="state_not_found",Ho="nonce_mismatch",an="auth_time_not_found",Do="max_age_transpired",Mi="multiple_matching_tokens",Ui="multiple_matching_accounts",Ko="multiple_matching_appMetadata",xo="request_cannot_be_made",Bo="cannot_remove_empty_scope",Fo="cannot_append_scopeset",Kt="empty_input_scopeset",Li="device_code_polling_cancelled",Hi="device_code_expired",Di="device_code_unknown_error",sn="no_account_in_silent_request",Go="invalid_cache_record",cn="invalid_cache_environment",xt="no_account_found",Bt="no_crypto_object",Ft="unexpected_credential_type",Ki="invalid_assertion",xi="invalid_client_credential",se="token_refresh_required",Bi="user_timeout_reached",zo="token_claims_cnf_required_for_signedjwt",qo="authorization_code_missing_from_server_response",Vo="binding_key_not_removed",Yo="end_session_endpoint_not_supported",ln="key_id_missing",Fi="no_network_connectivity",Gi="user_canceled",zi="missing_tenant_id_error",S="method_not_implemented",qi="nested_app_auth_bridge_disabled";/*! @azure/msal-common v14.16.0 2024-11-05 */const eo={[on]:"The client info could not be parsed/decoded correctly",[Oo]:"The client info was empty",[rn]:"Token cannot be parsed",[No]:"The token is null or empty",[ae]:"Endpoints cannot be resolved",[Po]:"Network request failed",[Mo]:"Could not retrieve endpoints. Check your authority and verify the .well-known/openid-configuration endpoint returns the required endpoints.",[Uo]:"The hash parameters could not be deserialized",[Me]:"State was not the expected format",[Lo]:"State mismatch error",[lt]:"State not found",[Ho]:"Nonce mismatch error",[an]:"Max Age was requested and the ID token is missing the auth_time variable. auth_time is an optional claim and is not enabled by default - it must be enabled. See https://aka.ms/msaljs/optional-claims for more information.",[Do]:"Max Age is set to 0, or too much time has elapsed since the last end-user authentication.",[Mi]:"The cache contains multiple tokens satisfying the requirements. Call AcquireToken again providing more requirements such as authority or account.",[Ui]:"The cache contains multiple accounts satisfying the given parameters. Please pass more info to obtain the correct account",[Ko]:"The cache contains multiple appMetadata satisfying the given parameters. Please pass more info to obtain the correct appMetadata",[xo]:"Token request cannot be made without authorization code or refresh token.",[Bo]:"Cannot remove null or empty scope from ScopeSet",[Fo]:"Cannot append ScopeSet",[Kt]:"Empty input ScopeSet cannot be processed",[Li]:"Caller has cancelled token endpoint polling during device code flow by setting DeviceCodeRequest.cancel = true.",[Hi]:"Device code is expired.",[Di]:"Device code stopped polling for unknown reasons.",[sn]:"Please pass an account object, silent flow is not supported without account information",[Go]:"Cache record object was null or undefined.",[cn]:"Invalid environment when attempting to create cache entry",[xt]:"No account found in cache for given key.",[Bt]:"No crypto object detected.",[Ft]:"Unexpected credential type.",[Ki]:"Client assertion must meet requirements described in https://tools.ietf.org/html/rfc7515",[xi]:"Client credential (secret, certificate, or assertion) must not be empty when creating a confidential client. An application should at most have one credential",[se]:"Cannot return token from cache because it must be refreshed. This may be due to one of the following reasons: forceRefresh parameter is set to true, claims have been requested, there is no cached access token or it is expired.",[Bi]:"User defined timeout for device code polling reached",[zo]:"Cannot generate a POP jwt if the token_claims are not populated",[qo]:"Server response does not contain an authorization code to proceed",[Vo]:"Could not remove the credential's binding key from storage.",[Yo]:"The provided authority does not support logout",[ln]:"A keyId value is missing from the requested bound token's cache record and is required to match the token to it's stored binding key.",[Fi]:"No network connectivity. Check your internet connection.",[Gi]:"User cancelled the flow.",[zi]:"A tenant id - not common, organizations, or consumers - must be specified when using the client_credentials flow.",[S]:"This method has not been implemented",[qi]:"The nested app auth bridge is disabled"};class Tt extends P{constructor(e,t){super(e,t?`${eo[e]}: ${t}`:eo[e]),this.name="ClientAuthError",Object.setPrototypeOf(this,Tt.prototype)}}function g(a,e){return new Tt(a,e)}/*! @azure/msal-common v14.16.0 2024-11-05 */const ht={createNewGuid:()=>{throw g(S)},base64Decode:()=>{throw g(S)},base64Encode:()=>{throw g(S)},base64UrlEncode:()=>{throw g(S)},encodeKid:()=>{throw g(S)},async getPublicKeyThumbprint(){throw g(S)},async removeTokenBindingKey(){throw g(S)},async clearKeystore(){throw g(S)},async signJwt(){throw g(S)},async hashString(){throw g(S)}};/*! @azure/msal-common v14.16.0 2024-11-05 */var N;(function(a){a[a.Error=0]="Error",a[a.Warning=1]="Warning",a[a.Info=2]="Info",a[a.Verbose=3]="Verbose",a[a.Trace=4]="Trace"})(N||(N={}));class pe{constructor(e,t,n){this.level=N.Info;const o=()=>{},r=e||pe.createDefaultLoggerOptions();this.localCallback=r.loggerCallback||o,this.piiLoggingEnabled=r.piiLoggingEnabled||!1,this.level=typeof r.logLevel=="number"?r.logLevel:N.Info,this.correlationId=r.correlationId||u.EMPTY_STRING,this.packageName=t||u.EMPTY_STRING,this.packageVersion=n||u.EMPTY_STRING}static createDefaultLoggerOptions(){return{loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:N.Info}}clone(e,t,n){return new pe({loggerCallback:this.localCallback,piiLoggingEnabled:this.piiLoggingEnabled,logLevel:this.level,correlationId:n||this.correlationId},e,t)}logMessage(e,t){if(t.logLevel>this.level||!this.piiLoggingEnabled&&t.containsPii)return;const r=`${`[${new Date().toUTCString()}] : [${t.correlationId||this.correlationId||""}]`} : ${this.packageName}@${this.packageVersion} : ${N[t.logLevel]} - ${e}`;this.executeCallback(t.logLevel,r,t.containsPii||!1)}executeCallback(e,t,n){this.localCallback&&this.localCallback(e,t,n)}error(e,t){this.logMessage(e,{logLevel:N.Error,containsPii:!1,correlationId:t||u.EMPTY_STRING})}errorPii(e,t){this.logMessage(e,{logLevel:N.Error,containsPii:!0,correlationId:t||u.EMPTY_STRING})}warning(e,t){this.logMessage(e,{logLevel:N.Warning,containsPii:!1,correlationId:t||u.EMPTY_STRING})}warningPii(e,t){this.logMessage(e,{logLevel:N.Warning,containsPii:!0,correlationId:t||u.EMPTY_STRING})}info(e,t){this.logMessage(e,{logLevel:N.Info,containsPii:!1,correlationId:t||u.EMPTY_STRING})}infoPii(e,t){this.logMessage(e,{logLevel:N.Info,containsPii:!0,correlationId:t||u.EMPTY_STRING})}verbose(e,t){this.logMessage(e,{logLevel:N.Verbose,containsPii:!1,correlationId:t||u.EMPTY_STRING})}verbosePii(e,t){this.logMessage(e,{logLevel:N.Verbose,containsPii:!0,correlationId:t||u.EMPTY_STRING})}trace(e,t){this.logMessage(e,{logLevel:N.Trace,containsPii:!1,correlationId:t||u.EMPTY_STRING})}tracePii(e,t){this.logMessage(e,{logLevel:N.Trace,containsPii:!0,correlationId:t||u.EMPTY_STRING})}isPiiLoggingEnabled(){return this.piiLoggingEnabled||!1}}/*! @azure/msal-common v14.16.0 2024-11-05 */const $o="@azure/msal-common",hn="14.16.0";/*! @azure/msal-common v14.16.0 2024-11-05 */const dn={None:"none",AzurePublic:"https://login.microsoftonline.com",AzurePpe:"https://login.windows-ppe.net",AzureChina:"https://login.chinacloudapi.cn",AzureGermany:"https://login.microsoftonline.de",AzureUsGovernment:"https://login.microsoftonline.us"};/*! @azure/msal-common v14.16.0 2024-11-05 */function Ee(a,e){const t=Vi(a);try{const n=e(t);return JSON.parse(n)}catch{throw g(rn)}}function Vi(a){if(!a)throw g(No);const t=/^([^\.\s]*)\.([^\.\s]+)\.([^\.\s]*)$/.exec(a);if(!t||t.length<4)throw g(rn);return t[2]}function Qo(a,e){if(e===0||Date.now()-3e5>a+e)throw g(Do)}/*! @azure/msal-common v14.16.0 2024-11-05 */function re(){return Math.round(new Date().getTime()/1e3)}function Gt(a,e){const t=Number(a)||0;return re()+e>t}function Yi(a){return Number(a)>re()}/*! @azure/msal-common v14.16.0 2024-11-05 */function Re(a){return[$i(a),Qi(a),Wi(a),ji(a),Ji(a)].join(B.CACHE_KEY_SEPARATOR).toLowerCase()}function At(a,e,t,n,o){return{credentialType:E.ID_TOKEN,homeAccountId:a,environment:e,clientId:n,secret:t,realm:o}}function It(a,e,t,n,o,r,i,s,c,l,d,m,f,T,v){var _,L;const y={homeAccountId:a,credentialType:E.ACCESS_TOKEN,secret:t,cachedAt:re().toString(),expiresOn:i.toString(),extendedExpiresOn:s.toString(),environment:e,clientId:n,realm:o,target:r,tokenType:d||R.BEARER};if(m&&(y.userAssertionHash=m),l&&(y.refreshOn=l.toString()),T&&(y.requestedClaims=T,y.requestedClaimsHash=v),((_=y.tokenType)==null?void 0:_.toLowerCase())!==R.BEARER.toLowerCase())switch(y.credentialType=E.ACCESS_TOKEN_WITH_AUTH_SCHEME,y.tokenType){case R.POP:const z=Ee(t,c);if(!((L=z==null?void 0:z.cnf)!=null&&L.kid))throw g(zo);y.keyId=z.cnf.kid;break;case R.SSH:y.keyId=f}return y}function Wo(a,e,t,n,o,r,i){const s={credentialType:E.REFRESH_TOKEN,homeAccountId:a,environment:e,clientId:n,secret:t};return r&&(s.userAssertionHash=r),o&&(s.familyId=o),i&&(s.expiresOn=i.toString()),s}function un(a){return a.hasOwnProperty("homeAccountId")&&a.hasOwnProperty("environment")&&a.hasOwnProperty("credentialType")&&a.hasOwnProperty("clientId")&&a.hasOwnProperty("secret")}function to(a){return a?un(a)&&a.hasOwnProperty("realm")&&a.hasOwnProperty("target")&&(a.credentialType===E.ACCESS_TOKEN||a.credentialType===E.ACCESS_TOKEN_WITH_AUTH_SCHEME):!1}function no(a){return a?un(a)&&a.hasOwnProperty("realm")&&a.credentialType===E.ID_TOKEN:!1}function oo(a){return a?un(a)&&a.credentialType===E.REFRESH_TOKEN:!1}function $i(a){return[a.homeAccountId,a.environment].join(B.CACHE_KEY_SEPARATOR).toLowerCase()}function Qi(a){const e=a.credentialType===E.REFRESH_TOKEN&&a.familyId||a.clientId;return[a.credentialType,e,a.realm||""].join(B.CACHE_KEY_SEPARATOR).toLowerCase()}function Wi(a){return(a.target||"").toLowerCase()}function ji(a){return(a.requestedClaimsHash||"").toLowerCase()}function Ji(a){return a.tokenType&&a.tokenType.toLowerCase()!==R.BEARER.toLowerCase()?a.tokenType.toLowerCase():""}function Xi(a,e){const t=a.indexOf(K.CACHE_KEY)===0;let n=!0;return e&&(n=e.hasOwnProperty("failedRequests")&&e.hasOwnProperty("errors")&&e.hasOwnProperty("cacheHits")),t&&n}function Zi(a,e){let t=!1;a&&(t=a.indexOf(Ge.THROTTLING_PREFIX)===0);let n=!0;return e&&(n=e.hasOwnProperty("throttleTime")),t&&n}function ea({environment:a,clientId:e}){return[tn,a,e].join(B.CACHE_KEY_SEPARATOR).toLowerCase()}function ta(a,e){return e?a.indexOf(tn)===0&&e.hasOwnProperty("clientId")&&e.hasOwnProperty("environment"):!1}function na(a,e){return e?a.indexOf(ct.CACHE_KEY)===0&&e.hasOwnProperty("aliases")&&e.hasOwnProperty("preferred_cache")&&e.hasOwnProperty("preferred_network")&&e.hasOwnProperty("canonical_authority")&&e.hasOwnProperty("authorization_endpoint")&&e.hasOwnProperty("token_endpoint")&&e.hasOwnProperty("issuer")&&e.hasOwnProperty("aliasesFromNetwork")&&e.hasOwnProperty("endpointsFromNetwork")&&e.hasOwnProperty("expiresAt")&&e.hasOwnProperty("jwks_uri"):!1}function ro(){return re()+ct.REFRESH_TIME_SECONDS}function ot(a,e,t){a.authorization_endpoint=e.authorization_endpoint,a.token_endpoint=e.token_endpoint,a.end_session_endpoint=e.end_session_endpoint,a.issuer=e.issuer,a.endpointsFromNetwork=t,a.jwks_uri=e.jwks_uri}function Ut(a,e,t){a.aliases=e.aliases,a.preferred_cache=e.preferred_cache,a.preferred_network=e.preferred_network,a.aliasesFromNetwork=t}function io(a){return a.expiresAt<=re()}/*! @azure/msal-common v14.16.0 2024-11-05 */const jo="redirect_uri_empty",oa="claims_request_parsing_error",Jo="authority_uri_insecure",Be="url_parse_error",Xo="empty_url_error",Zo="empty_input_scopes_error",er="invalid_prompt_value",gn="invalid_claims",tr="token_request_empty",nr="logout_request_empty",or="invalid_code_challenge_method",mn="pkce_params_missing",pn="invalid_cloud_discovery_metadata",rr="invalid_authority_metadata",ir="untrusted_authority",Et="missing_ssh_jwk",ar="missing_ssh_kid",ra="missing_nonce_authentication_header",ia="invalid_authentication_header",sr="cannot_set_OIDCOptions",cr="cannot_allow_native_broker",lr="authority_mismatch";/*! @azure/msal-common v14.16.0 2024-11-05 */const aa={[jo]:"A redirect URI is required for all calls, and none has been set.",[oa]:"Could not parse the given claims request object.",[Jo]:"Authority URIs must use https.  Please see here for valid authority configuration options: https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-js-initializing-client-applications#configuration-options",[Be]:"URL could not be parsed into appropriate segments.",[Xo]:"URL was empty or null.",[Zo]:"Scopes cannot be passed as null, undefined or empty array because they are required to obtain an access token.",[er]:"Please see here for valid configuration options: https://azuread.github.io/microsoft-authentication-library-for-js/ref/modules/_azure_msal_common.html#commonauthorizationurlrequest",[gn]:"Given claims parameter must be a stringified JSON object.",[tr]:"Token request was empty and not found in cache.",[nr]:"The logout request was null or undefined.",[or]:'code_challenge_method passed is invalid. Valid values are "plain" and "S256".',[mn]:"Both params: code_challenge and code_challenge_method are to be passed if to be sent in the request",[pn]:"Invalid cloudDiscoveryMetadata provided. Must be a stringified JSON object containing tenant_discovery_endpoint and metadata fields",[rr]:"Invalid authorityMetadata provided. Must by a stringified JSON object containing authorization_endpoint, token_endpoint, issuer fields.",[ir]:"The provided authority is not a trusted authority. Please include this authority in the knownAuthorities config parameter.",[Et]:"Missing sshJwk in SSH certificate request. A stringified JSON Web Key is required when using the SSH authentication scheme.",[ar]:"Missing sshKid in SSH certificate request. A string that uniquely identifies the public SSH key is required when using the SSH authentication scheme.",[ra]:"Unable to find an authentication header containing server nonce. Either the Authentication-Info or WWW-Authenticate headers must be present in order to obtain a server nonce.",[ia]:"Invalid authentication header provided",[sr]:"Cannot set OIDCOptions parameter. Please change the protocol mode to OIDC or use a non-Microsoft authority.",[cr]:"Cannot set allowNativeBroker parameter to true when not in AAD protocol mode.",[lr]:"Authority mismatch error. Authority provided in login request or PublicClientApplication config does not match the environment of the provided account. Please use a matching account or make an interactive request to login to this authority."};class fn extends P{constructor(e){super(e,aa[e]),this.name="ClientConfigurationError",Object.setPrototypeOf(this,fn.prototype)}}function b(a){return new fn(a)}/*! @azure/msal-common v14.16.0 2024-11-05 */class j{static isEmptyObj(e){if(e)try{const t=JSON.parse(e);return Object.keys(t).length===0}catch{}return!0}static startsWith(e,t){return e.indexOf(t)===0}static endsWith(e,t){return e.length>=t.length&&e.lastIndexOf(t)===e.length-t.length}static queryStringToObject(e){const t={},n=e.split("&"),o=r=>decodeURIComponent(r.replace(/\+/g," "));return n.forEach(r=>{if(r.trim()){const[i,s]=r.split(/=(.+)/g,2);i&&s&&(t[o(i)]=o(s))}}),t}static trimArrayEntries(e){return e.map(t=>t.trim())}static removeEmptyStringsFromArray(e){return e.filter(t=>!!t)}static jsonParseHelper(e){try{return JSON.parse(e)}catch{return null}}static matchPattern(e,t){return new RegExp(e.replace(/\\/g,"\\\\").replace(/\*/g,"[^ ]*").replace(/\?/g,"\\?")).test(t)}}/*! @azure/msal-common v14.16.0 2024-11-05 */class M{constructor(e){const t=e?j.trimArrayEntries([...e]):[],n=t?j.removeEmptyStringsFromArray(t):[];this.validateInputScopes(n),this.scopes=new Set,n.forEach(o=>this.scopes.add(o))}static fromString(e){const n=(e||u.EMPTY_STRING).split(" ");return new M(n)}static createSearchScopes(e){const t=new M(e);return t.containsOnlyOIDCScopes()?t.removeScope(u.OFFLINE_ACCESS_SCOPE):t.removeOIDCScopes(),t}validateInputScopes(e){if(!e||e.length<1)throw b(Zo)}containsScope(e){const t=this.printScopesLowerCase().split(" "),n=new M(t);return e?n.scopes.has(e.toLowerCase()):!1}containsScopeSet(e){return!e||e.scopes.size<=0?!1:this.scopes.size>=e.scopes.size&&e.asArray().every(t=>this.containsScope(t))}containsOnlyOIDCScopes(){let e=0;return Wn.forEach(t=>{this.containsScope(t)&&(e+=1)}),this.scopes.size===e}appendScope(e){e&&this.scopes.add(e.trim())}appendScopes(e){try{e.forEach(t=>this.appendScope(t))}catch{throw g(Fo)}}removeScope(e){if(!e)throw g(Bo);this.scopes.delete(e.trim())}removeOIDCScopes(){Wn.forEach(e=>{this.scopes.delete(e)})}unionScopeSets(e){if(!e)throw g(Kt);const t=new Set;return e.scopes.forEach(n=>t.add(n.toLowerCase())),this.scopes.forEach(n=>t.add(n.toLowerCase())),t}intersectingScopeSets(e){if(!e)throw g(Kt);e.containsOnlyOIDCScopes()||e.removeOIDCScopes();const t=this.unionScopeSets(e),n=e.getScopeCount(),o=this.getScopeCount();return t.size<o+n}getScopeCount(){return this.scopes.size}asArray(){const e=[];return this.scopes.forEach(t=>e.push(t)),e}printScopes(){return this.scopes?this.asArray().join(" "):u.EMPTY_STRING}printScopesLowerCase(){return this.printScopes().toLowerCase()}}/*! @azure/msal-common v14.16.0 2024-11-05 */function dt(a,e){if(!a)throw g(Oo);try{const t=e(a);return JSON.parse(t)}catch{throw g(on)}}function be(a){if(!a)throw g(on);const e=a.split(B.CLIENT_INFO_SEPARATOR,2);return{uid:e[0],utid:e.length<2?u.EMPTY_STRING:e[1]}}/*! @azure/msal-common v14.16.0 2024-11-05 */function ut(a,e){return!!a&&!!e&&a===e.split(".")[1]}function Cn(a,e,t,n){if(n){const{oid:o,sub:r,tid:i,name:s,tfp:c,acr:l}=n,d=i||c||l||"";return{tenantId:d,localAccountId:o||r||"",name:s,isHomeTenant:ut(d,a)}}else return{tenantId:t,localAccountId:e,isHomeTenant:ut(t,a)}}function yn(a,e,t,n){let o=a;if(e){const{isHomeTenant:r,...i}=e;o={...a,...i}}if(t){const{isHomeTenant:r,...i}=Cn(a.homeAccountId,a.localAccountId,a.tenantId,t);return o={...o,...i,idTokenClaims:t,idToken:n},o}return o}/*! @azure/msal-common v14.16.0 2024-11-05 */const W={Default:0,Adfs:1,Dsts:2,Ciam:3};/*! @azure/msal-common v14.16.0 2024-11-05 */function hr(a){return a&&(a.tid||a.tfp||a.acr)||null}/*! @azure/msal-common v14.16.0 2024-11-05 */const le={AAD:"AAD",OIDC:"OIDC"};/*! @azure/msal-common v14.16.0 2024-11-05 */class U{generateAccountId(){return[this.homeAccountId,this.environment].join(B.CACHE_KEY_SEPARATOR).toLowerCase()}generateAccountKey(){return U.generateAccountCacheKey({homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId})}getAccountInfo(){return{homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId,name:this.name,nativeAccountId:this.nativeAccountId,authorityType:this.authorityType,tenantProfiles:new Map((this.tenantProfiles||[]).map(e=>[e.tenantId,e]))}}isSingleTenant(){return!this.tenantProfiles}static generateAccountCacheKey(e){const t=e.homeAccountId.split(".")[1];return[e.homeAccountId,e.environment||"",t||e.tenantId||""].join(B.CACHE_KEY_SEPARATOR).toLowerCase()}static createAccount(e,t,n){var l,d,m,f,T,v;const o=new U;t.authorityType===W.Adfs?o.authorityType=tt.ADFS_ACCOUNT_TYPE:t.protocolMode===le.AAD?o.authorityType=tt.MSSTS_ACCOUNT_TYPE:o.authorityType=tt.GENERIC_ACCOUNT_TYPE;let r;e.clientInfo&&n&&(r=dt(e.clientInfo,n)),o.clientInfo=e.clientInfo,o.homeAccountId=e.homeAccountId,o.nativeAccountId=e.nativeAccountId;const i=e.environment||t&&t.getPreferredCache();if(!i)throw g(cn);o.environment=i,o.realm=(r==null?void 0:r.utid)||hr(e.idTokenClaims)||"",o.localAccountId=(r==null?void 0:r.uid)||((l=e.idTokenClaims)==null?void 0:l.oid)||((d=e.idTokenClaims)==null?void 0:d.sub)||"";const s=((m=e.idTokenClaims)==null?void 0:m.preferred_username)||((f=e.idTokenClaims)==null?void 0:f.upn),c=(T=e.idTokenClaims)!=null&&T.emails?e.idTokenClaims.emails[0]:null;if(o.username=s||c||"",o.name=((v=e.idTokenClaims)==null?void 0:v.name)||"",o.cloudGraphHostName=e.cloudGraphHostName,o.msGraphHost=e.msGraphHost,e.tenantProfiles)o.tenantProfiles=e.tenantProfiles;else{const y=Cn(e.homeAccountId,o.localAccountId,o.realm,e.idTokenClaims);o.tenantProfiles=[y]}return o}static createFromAccountInfo(e,t,n){var r;const o=new U;return o.authorityType=e.authorityType||tt.GENERIC_ACCOUNT_TYPE,o.homeAccountId=e.homeAccountId,o.localAccountId=e.localAccountId,o.nativeAccountId=e.nativeAccountId,o.realm=e.tenantId,o.environment=e.environment,o.username=e.username,o.name=e.name,o.cloudGraphHostName=t,o.msGraphHost=n,o.tenantProfiles=Array.from(((r=e.tenantProfiles)==null?void 0:r.values())||[]),o}static generateHomeAccountId(e,t,n,o,r){if(!(t===W.Adfs||t===W.Dsts)){if(e)try{const i=dt(e,o.base64Decode);if(i.uid&&i.utid)return`${i.uid}.${i.utid}`}catch{}n.warning("No client info in response")}return(r==null?void 0:r.sub)||""}static isAccountEntity(e){return e?e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("realm")&&e.hasOwnProperty("localAccountId")&&e.hasOwnProperty("username")&&e.hasOwnProperty("authorityType"):!1}static accountInfoIsEqual(e,t,n){if(!e||!t)return!1;let o=!0;if(n){const r=e.idTokenClaims||{},i=t.idTokenClaims||{};o=r.iat===i.iat&&r.nonce===i.nonce}return e.homeAccountId===t.homeAccountId&&e.localAccountId===t.localAccountId&&e.username===t.username&&e.tenantId===t.tenantId&&e.environment===t.environment&&e.nativeAccountId===t.nativeAccountId&&o}}/*! @azure/msal-common v14.16.0 2024-11-05 */function dr(a){return a.startsWith("#/")?a.substring(2):a.startsWith("#")||a.startsWith("?")?a.substring(1):a}function gt(a){if(!a||a.indexOf("=")<0)return null;try{const e=dr(a),t=Object.fromEntries(new URLSearchParams(e));if(t.code||t.error||t.error_description||t.state)return t}catch{throw g(Uo)}return null}/*! @azure/msal-common v14.16.0 2024-11-05 */class w{get urlString(){return this._urlString}constructor(e){if(this._urlString=e,!this._urlString)throw b(Xo);e.includes("#")||(this._urlString=w.canonicalizeUri(e))}static canonicalizeUri(e){if(e){let t=e.toLowerCase();return j.endsWith(t,"?")?t=t.slice(0,-1):j.endsWith(t,"?/")&&(t=t.slice(0,-2)),j.endsWith(t,"/")||(t+="/"),t}return e}validateAsUri(){let e;try{e=this.getUrlComponents()}catch{throw b(Be)}if(!e.HostNameAndPort||!e.PathSegments)throw b(Be);if(!e.Protocol||e.Protocol.toLowerCase()!=="https:")throw b(Jo)}static appendQueryString(e,t){return t?e.indexOf("?")<0?`${e}?${t}`:`${e}&${t}`:e}static removeHashFromUrl(e){return w.canonicalizeUri(e.split("#")[0])}replaceTenantPath(e){const t=this.getUrlComponents(),n=t.PathSegments;return e&&n.length!==0&&(n[0]===me.COMMON||n[0]===me.ORGANIZATIONS)&&(n[0]=e),w.constructAuthorityUriFromObject(t)}getUrlComponents(){const e=RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?"),t=this.urlString.match(e);if(!t)throw b(Be);const n={Protocol:t[1],HostNameAndPort:t[4],AbsolutePath:t[5],QueryString:t[7]};let o=n.AbsolutePath.split("/");return o=o.filter(r=>r&&r.length>0),n.PathSegments=o,n.QueryString&&n.QueryString.endsWith("/")&&(n.QueryString=n.QueryString.substring(0,n.QueryString.length-1)),n}static getDomainFromUrl(e){const t=RegExp("^([^:/?#]+://)?([^/?#]*)"),n=e.match(t);if(!n)throw b(Be);return n[2]}static getAbsoluteUrl(e,t){if(e[0]===u.FORWARD_SLASH){const o=new w(t).getUrlComponents();return o.Protocol+"//"+o.HostNameAndPort+e}return e}static constructAuthorityUriFromObject(e){return new w(e.Protocol+"//"+e.HostNameAndPort+"/"+e.PathSegments.join("/"))}static hashContainsKnownProperties(e){return!!gt(e)}}/*! @azure/msal-common v14.16.0 2024-11-05 */const ur={endpointMetadata:{"login.microsoftonline.com":{token_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.com/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.com/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/logout"},"login.chinacloudapi.cn":{token_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.chinacloudapi.cn/{tenantid}/discovery/v2.0/keys",issuer:"https://login.partner.microsoftonline.cn/{tenantid}/v2.0",authorization_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/logout"},"login.microsoftonline.us":{token_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.us/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.us/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/logout"}},instanceDiscoveryMetadata:{tenant_discovery_endpoint:"https://{canonicalAuthority}/v2.0/.well-known/openid-configuration",metadata:[{preferred_network:"login.microsoftonline.com",preferred_cache:"login.windows.net",aliases:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"]},{preferred_network:"login.partner.microsoftonline.cn",preferred_cache:"login.partner.microsoftonline.cn",aliases:["login.partner.microsoftonline.cn","login.chinacloudapi.cn"]},{preferred_network:"login.microsoftonline.de",preferred_cache:"login.microsoftonline.de",aliases:["login.microsoftonline.de"]},{preferred_network:"login.microsoftonline.us",preferred_cache:"login.microsoftonline.us",aliases:["login.microsoftonline.us","login.usgovcloudapi.net"]},{preferred_network:"login-us.microsoftonline.com",preferred_cache:"login-us.microsoftonline.com",aliases:["login-us.microsoftonline.com"]}]}},ao=ur.endpointMetadata,Tn=ur.instanceDiscoveryMetadata,gr=new Set;Tn.metadata.forEach(a=>{a.aliases.forEach(e=>{gr.add(e)})});function sa(a,e){var o;let t;const n=a.canonicalAuthority;if(n){const r=new w(n).getUrlComponents().HostNameAndPort;t=so(r,(o=a.cloudDiscoveryMetadata)==null?void 0:o.metadata,V.CONFIG,e)||so(r,Tn.metadata,V.HARDCODED_VALUES,e)||a.knownAuthorities}return t||[]}function so(a,e,t,n){if(n==null||n.trace(`getAliasesFromMetadata called with source: ${t}`),a&&e){const o=mt(e,a);if(o)return n==null||n.trace(`getAliasesFromMetadata: found cloud discovery metadata in ${t}, returning aliases`),o.aliases;n==null||n.trace(`getAliasesFromMetadata: did not find cloud discovery metadata in ${t}`)}return null}function ca(a){return mt(Tn.metadata,a)}function mt(a,e){for(let t=0;t<a.length;t++){const n=a[t];if(n.aliases.includes(e))return n}return null}/*! @azure/msal-common v14.16.0 2024-11-05 */const mr="cache_quota_exceeded",An="cache_error_unknown";/*! @azure/msal-common v14.16.0 2024-11-05 */const Lt={[mr]:"Exceeded cache storage capacity.",[An]:"Unexpected error occurred when using cache storage."};class Ne extends Error{constructor(e,t){const n=t||(Lt[e]?Lt[e]:Lt[An]);super(`${e}: ${n}`),Object.setPrototypeOf(this,Ne.prototype),this.name="CacheError",this.errorCode=e,this.errorMessage=n}}/*! @azure/msal-common v14.16.0 2024-11-05 */class Ue{constructor(e,t,n,o){this.clientId=e,this.cryptoImpl=t,this.commonLogger=n.clone($o,hn),this.staticAuthorityOptions=o}getAllAccounts(e){return this.buildTenantProfiles(this.getAccountsFilteredBy(e||{}),e)}getAccountInfoFilteredBy(e){const t=this.getAllAccounts(e);return t.length>1?t.sort(o=>o.idTokenClaims?-1:1)[0]:t.length===1?t[0]:null}getBaseAccountInfo(e){const t=this.getAccountsFilteredBy(e);return t.length>0?t[0].getAccountInfo():null}buildTenantProfiles(e,t){return e.flatMap(n=>this.getTenantProfilesFromAccountEntity(n,t==null?void 0:t.tenantId,t))}getTenantedAccountInfoByFilter(e,t,n,o){let r=null,i;if(o&&!this.tenantProfileMatchesFilter(n,o))return null;const s=this.getIdToken(e,t,n.tenantId);return s&&(i=Ee(s.secret,this.cryptoImpl.base64Decode),!this.idTokenClaimsMatchTenantProfileFilter(i,o))?null:(r=yn(e,n,i,s==null?void 0:s.secret),r)}getTenantProfilesFromAccountEntity(e,t,n){const o=e.getAccountInfo();let r=o.tenantProfiles||new Map;const i=this.getTokenKeys();if(t){const c=r.get(t);if(c)r=new Map([[t,c]]);else return[]}const s=[];return r.forEach(c=>{const l=this.getTenantedAccountInfoByFilter(o,i,c,n);l&&s.push(l)}),s}tenantProfileMatchesFilter(e,t){return!(t.localAccountId&&!this.matchLocalAccountIdFromTenantProfile(e,t.localAccountId)||t.name&&e.name!==t.name||t.isHomeTenant!==void 0&&e.isHomeTenant!==t.isHomeTenant)}idTokenClaimsMatchTenantProfileFilter(e,t){return!(t&&(t.localAccountId&&!this.matchLocalAccountIdFromTokenClaims(e,t.localAccountId)||t.loginHint&&!this.matchLoginHintFromTokenClaims(e,t.loginHint)||t.username&&!this.matchUsername(e.preferred_username,t.username)||t.name&&!this.matchName(e,t.name)||t.sid&&!this.matchSid(e,t.sid)))}async saveCacheRecord(e,t,n){var o,r,i,s;if(!e)throw g(Go);try{e.account&&this.setAccount(e.account),e.idToken&&(t==null?void 0:t.idToken)!==!1&&this.setIdTokenCredential(e.idToken),e.accessToken&&(t==null?void 0:t.accessToken)!==!1&&await this.saveAccessToken(e.accessToken),e.refreshToken&&(t==null?void 0:t.refreshToken)!==!1&&this.setRefreshTokenCredential(e.refreshToken),e.appMetadata&&this.setAppMetadata(e.appMetadata)}catch(c){throw(o=this.commonLogger)==null||o.error("CacheManager.saveCacheRecord: failed"),c instanceof Error?((r=this.commonLogger)==null||r.errorPii(`CacheManager.saveCacheRecord: ${c.message}`,n),c.name==="QuotaExceededError"||c.name==="NS_ERROR_DOM_QUOTA_REACHED"||c.message.includes("exceeded the quota")?((i=this.commonLogger)==null||i.error("CacheManager.saveCacheRecord: exceeded storage quota",n),new Ne(mr)):new Ne(c.name,c.message)):((s=this.commonLogger)==null||s.errorPii(`CacheManager.saveCacheRecord: ${c}`,n),new Ne(An))}}async saveAccessToken(e){const t={clientId:e.clientId,credentialType:e.credentialType,environment:e.environment,homeAccountId:e.homeAccountId,realm:e.realm,tokenType:e.tokenType,requestedClaimsHash:e.requestedClaimsHash},n=this.getTokenKeys(),o=M.fromString(e.target),r=[];n.accessToken.forEach(i=>{if(!this.accessTokenKeyMatchesFilter(i,t,!1))return;const s=this.getAccessTokenCredential(i);s&&this.credentialMatchesFilter(s,t)&&M.fromString(s.target).intersectingScopeSets(o)&&r.push(this.removeAccessToken(i))}),await Promise.all(r),this.setAccessTokenCredential(e)}getAccountsFilteredBy(e){const t=this.getAccountKeys(),n=[];return t.forEach(o=>{var c;if(!this.isAccountKey(o,e.homeAccountId))return;const r=this.getAccount(o,this.commonLogger);if(!r||e.homeAccountId&&!this.matchHomeAccountId(r,e.homeAccountId)||e.username&&!this.matchUsername(r.username,e.username)||e.environment&&!this.matchEnvironment(r,e.environment)||e.realm&&!this.matchRealm(r,e.realm)||e.nativeAccountId&&!this.matchNativeAccountId(r,e.nativeAccountId)||e.authorityType&&!this.matchAuthorityType(r,e.authorityType))return;const i={localAccountId:e==null?void 0:e.localAccountId,name:e==null?void 0:e.name},s=(c=r.tenantProfiles)==null?void 0:c.filter(l=>this.tenantProfileMatchesFilter(l,i));s&&s.length===0||n.push(r)}),n}isAccountKey(e,t,n){return!(e.split(B.CACHE_KEY_SEPARATOR).length<3||t&&!e.toLowerCase().includes(t.toLowerCase())||n&&!e.toLowerCase().includes(n.toLowerCase()))}isCredentialKey(e){if(e.split(B.CACHE_KEY_SEPARATOR).length<6)return!1;const t=e.toLowerCase();if(t.indexOf(E.ID_TOKEN.toLowerCase())===-1&&t.indexOf(E.ACCESS_TOKEN.toLowerCase())===-1&&t.indexOf(E.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase())===-1&&t.indexOf(E.REFRESH_TOKEN.toLowerCase())===-1)return!1;if(t.indexOf(E.REFRESH_TOKEN.toLowerCase())>-1){const n=`${E.REFRESH_TOKEN}${B.CACHE_KEY_SEPARATOR}${this.clientId}${B.CACHE_KEY_SEPARATOR}`,o=`${E.REFRESH_TOKEN}${B.CACHE_KEY_SEPARATOR}${Fe}${B.CACHE_KEY_SEPARATOR}`;if(t.indexOf(n.toLowerCase())===-1&&t.indexOf(o.toLowerCase())===-1)return!1}else if(t.indexOf(this.clientId.toLowerCase())===-1)return!1;return!0}credentialMatchesFilter(e,t){return!(t.clientId&&!this.matchClientId(e,t.clientId)||t.userAssertionHash&&!this.matchUserAssertionHash(e,t.userAssertionHash)||typeof t.homeAccountId=="string"&&!this.matchHomeAccountId(e,t.homeAccountId)||t.environment&&!this.matchEnvironment(e,t.environment)||t.realm&&!this.matchRealm(e,t.realm)||t.credentialType&&!this.matchCredentialType(e,t.credentialType)||t.familyId&&!this.matchFamilyId(e,t.familyId)||t.target&&!this.matchTarget(e,t.target)||(t.requestedClaimsHash||e.requestedClaimsHash)&&e.requestedClaimsHash!==t.requestedClaimsHash||e.credentialType===E.ACCESS_TOKEN_WITH_AUTH_SCHEME&&(t.tokenType&&!this.matchTokenType(e,t.tokenType)||t.tokenType===R.SSH&&t.keyId&&!this.matchKeyId(e,t.keyId)))}getAppMetadataFilteredBy(e){const t=this.getKeys(),n={};return t.forEach(o=>{if(!this.isAppMetadata(o))return;const r=this.getAppMetadata(o);r&&(e.environment&&!this.matchEnvironment(r,e.environment)||e.clientId&&!this.matchClientId(r,e.clientId)||(n[o]=r))}),n}getAuthorityMetadataByAlias(e){const t=this.getAuthorityMetadataKeys();let n=null;return t.forEach(o=>{if(!this.isAuthorityMetadata(o)||o.indexOf(this.clientId)===-1)return;const r=this.getAuthorityMetadata(o);r&&r.aliases.indexOf(e)!==-1&&(n=r)}),n}async removeAllAccounts(){const e=this.getAccountKeys(),t=[];e.forEach(n=>{t.push(this.removeAccount(n))}),await Promise.all(t)}async removeAccount(e){const t=this.getAccount(e,this.commonLogger);t&&(await this.removeAccountContext(t),this.removeItem(e))}async removeAccountContext(e){const t=this.getTokenKeys(),n=e.generateAccountId(),o=[];t.idToken.forEach(r=>{r.indexOf(n)===0&&this.removeIdToken(r)}),t.accessToken.forEach(r=>{r.indexOf(n)===0&&o.push(this.removeAccessToken(r))}),t.refreshToken.forEach(r=>{r.indexOf(n)===0&&this.removeRefreshToken(r)}),await Promise.all(o)}updateOutdatedCachedAccount(e,t,n){var o;if(t&&t.isSingleTenant()){(o=this.commonLogger)==null||o.verbose("updateOutdatedCachedAccount: Found a single-tenant (outdated) account entity in the cache, migrating to multi-tenant account entity");const r=this.getAccountKeys().filter(d=>d.startsWith(t.homeAccountId)),i=[];r.forEach(d=>{const m=this.getCachedAccountEntity(d);m&&i.push(m)});const s=i.find(d=>ut(d.realm,d.homeAccountId))||i[0];s.tenantProfiles=i.map(d=>({tenantId:d.realm,localAccountId:d.localAccountId,name:d.name,isHomeTenant:ut(d.realm,d.homeAccountId)}));const c=Ue.toObject(new U,{...s}),l=c.generateAccountKey();return r.forEach(d=>{d!==l&&this.removeOutdatedAccount(e)}),this.setAccount(c),n==null||n.verbose("Updated an outdated account entity in the cache"),c}return t}async removeAccessToken(e){const t=this.getAccessTokenCredential(e);if(t){if(t.credentialType.toLowerCase()===E.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase()&&t.tokenType===R.POP){const o=t.keyId;if(o)try{await this.cryptoImpl.removeTokenBindingKey(o)}catch{throw g(Vo)}}return this.removeItem(e)}}removeAppMetadata(){return this.getKeys().forEach(t=>{this.isAppMetadata(t)&&this.removeItem(t)}),!0}readAccountFromCache(e){const t=U.generateAccountCacheKey(e);return this.getAccount(t,this.commonLogger)}getIdToken(e,t,n,o,r){this.commonLogger.trace("CacheManager - getIdToken called");const i={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:E.ID_TOKEN,clientId:this.clientId,realm:n},s=this.getIdTokensByFilter(i,t),c=s.size;if(c<1)return this.commonLogger.info("CacheManager:getIdToken - No token found"),null;if(c>1){let l=s;if(!n){const d=new Map;s.forEach((f,T)=>{f.realm===e.tenantId&&d.set(T,f)});const m=d.size;if(m<1)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account but none match account entity tenant id, returning first result"),s.values().next().value;if(m===1)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account, defaulting to home tenant profile"),d.values().next().value;l=d}return this.commonLogger.info("CacheManager:getIdToken - Multiple matching ID tokens found, clearing them"),l.forEach((d,m)=>{this.removeIdToken(m)}),o&&r&&o.addFields({multiMatchedID:s.size},r),null}return this.commonLogger.info("CacheManager:getIdToken - Returning ID token"),s.values().next().value}getIdTokensByFilter(e,t){const n=t&&t.idToken||this.getTokenKeys().idToken,o=new Map;return n.forEach(r=>{if(!this.idTokenKeyMatchesFilter(r,{clientId:this.clientId,...e}))return;const i=this.getIdTokenCredential(r);i&&this.credentialMatchesFilter(i,e)&&o.set(r,i)}),o}idTokenKeyMatchesFilter(e,t){const n=e.toLowerCase();return!(t.clientId&&n.indexOf(t.clientId.toLowerCase())===-1||t.homeAccountId&&n.indexOf(t.homeAccountId.toLowerCase())===-1)}removeIdToken(e){this.removeItem(e)}removeRefreshToken(e){this.removeItem(e)}getAccessToken(e,t,n,o,r,i){this.commonLogger.trace("CacheManager - getAccessToken called");const s=M.createSearchScopes(t.scopes),c=t.authenticationScheme||R.BEARER,l=c.toLowerCase()!==R.BEARER.toLowerCase()?E.ACCESS_TOKEN_WITH_AUTH_SCHEME:E.ACCESS_TOKEN,d={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:l,clientId:this.clientId,realm:o||e.tenantId,target:s,tokenType:c,keyId:t.sshKid,requestedClaimsHash:t.requestedClaimsHash},m=n&&n.accessToken||this.getTokenKeys().accessToken,f=[];m.forEach(v=>{if(this.accessTokenKeyMatchesFilter(v,d,!0)){const y=this.getAccessTokenCredential(v);y&&this.credentialMatchesFilter(y,d)&&f.push(y)}});const T=f.length;return T<1?(this.commonLogger.info("CacheManager:getAccessToken - No token found"),null):T>1?(this.commonLogger.info("CacheManager:getAccessToken - Multiple access tokens found, clearing them"),f.forEach(v=>{this.removeAccessToken(Re(v))}),r&&i&&r.addFields({multiMatchedAT:f.length},i),null):(this.commonLogger.info("CacheManager:getAccessToken - Returning access token"),f[0])}accessTokenKeyMatchesFilter(e,t,n){const o=e.toLowerCase();if(t.clientId&&o.indexOf(t.clientId.toLowerCase())===-1||t.homeAccountId&&o.indexOf(t.homeAccountId.toLowerCase())===-1||t.realm&&o.indexOf(t.realm.toLowerCase())===-1||t.requestedClaimsHash&&o.indexOf(t.requestedClaimsHash.toLowerCase())===-1)return!1;if(t.target){const r=t.target.asArray();for(let i=0;i<r.length;i++){if(n&&!o.includes(r[i].toLowerCase()))return!1;if(!n&&o.includes(r[i].toLowerCase()))return!0}}return!0}getAccessTokensByFilter(e){const t=this.getTokenKeys(),n=[];return t.accessToken.forEach(o=>{if(!this.accessTokenKeyMatchesFilter(o,e,!0))return;const r=this.getAccessTokenCredential(o);r&&this.credentialMatchesFilter(r,e)&&n.push(r)}),n}getRefreshToken(e,t,n,o,r){this.commonLogger.trace("CacheManager - getRefreshToken called");const i=t?Fe:void 0,s={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:E.REFRESH_TOKEN,clientId:this.clientId,familyId:i},c=n&&n.refreshToken||this.getTokenKeys().refreshToken,l=[];c.forEach(m=>{if(this.refreshTokenKeyMatchesFilter(m,s)){const f=this.getRefreshTokenCredential(m);f&&this.credentialMatchesFilter(f,s)&&l.push(f)}});const d=l.length;return d<1?(this.commonLogger.info("CacheManager:getRefreshToken - No refresh token found."),null):(d>1&&o&&r&&o.addFields({multiMatchedRT:d},r),this.commonLogger.info("CacheManager:getRefreshToken - returning refresh token"),l[0])}refreshTokenKeyMatchesFilter(e,t){const n=e.toLowerCase();return!(t.familyId&&n.indexOf(t.familyId.toLowerCase())===-1||!t.familyId&&t.clientId&&n.indexOf(t.clientId.toLowerCase())===-1||t.homeAccountId&&n.indexOf(t.homeAccountId.toLowerCase())===-1)}readAppMetadataFromCache(e){const t={environment:e,clientId:this.clientId},n=this.getAppMetadataFilteredBy(t),o=Object.keys(n).map(i=>n[i]),r=o.length;if(r<1)return null;if(r>1)throw g(Ko);return o[0]}isAppMetadataFOCI(e){const t=this.readAppMetadataFromCache(e);return!!(t&&t.familyId===Fe)}matchHomeAccountId(e,t){return typeof e.homeAccountId=="string"&&t===e.homeAccountId}matchLocalAccountIdFromTokenClaims(e,t){const n=e.oid||e.sub;return t===n}matchLocalAccountIdFromTenantProfile(e,t){return e.localAccountId===t}matchName(e,t){var n;return t.toLowerCase()===((n=e.name)==null?void 0:n.toLowerCase())}matchUsername(e,t){return!!(e&&typeof e=="string"&&(t==null?void 0:t.toLowerCase())===e.toLowerCase())}matchUserAssertionHash(e,t){return!!(e.userAssertionHash&&t===e.userAssertionHash)}matchEnvironment(e,t){if(this.staticAuthorityOptions){const o=sa(this.staticAuthorityOptions,this.commonLogger);if(o.includes(t)&&o.includes(e.environment))return!0}const n=this.getAuthorityMetadataByAlias(t);return!!(n&&n.aliases.indexOf(e.environment)>-1)}matchCredentialType(e,t){return e.credentialType&&t.toLowerCase()===e.credentialType.toLowerCase()}matchClientId(e,t){return!!(e.clientId&&t===e.clientId)}matchFamilyId(e,t){return!!(e.familyId&&t===e.familyId)}matchRealm(e,t){var n;return((n=e.realm)==null?void 0:n.toLowerCase())===t.toLowerCase()}matchNativeAccountId(e,t){return!!(e.nativeAccountId&&t===e.nativeAccountId)}matchLoginHintFromTokenClaims(e,t){return e.login_hint===t||e.preferred_username===t||e.upn===t}matchSid(e,t){return e.sid===t}matchAuthorityType(e,t){return!!(e.authorityType&&t.toLowerCase()===e.authorityType.toLowerCase())}matchTarget(e,t){return e.credentialType!==E.ACCESS_TOKEN&&e.credentialType!==E.ACCESS_TOKEN_WITH_AUTH_SCHEME||!e.target?!1:M.fromString(e.target).containsScopeSet(t)}matchTokenType(e,t){return!!(e.tokenType&&e.tokenType===t)}matchKeyId(e,t){return!!(e.keyId&&e.keyId===t)}isAppMetadata(e){return e.indexOf(tn)!==-1}isAuthorityMetadata(e){return e.indexOf(ct.CACHE_KEY)!==-1}generateAuthorityMetadataCacheKey(e){return`${ct.CACHE_KEY}-${this.clientId}-${e}`}static toObject(e,t){for(const n in t)e[n]=t[n];return e}}class la extends Ue{setAccount(){throw g(S)}getAccount(){throw g(S)}getCachedAccountEntity(){throw g(S)}setIdTokenCredential(){throw g(S)}getIdTokenCredential(){throw g(S)}setAccessTokenCredential(){throw g(S)}getAccessTokenCredential(){throw g(S)}setRefreshTokenCredential(){throw g(S)}getRefreshTokenCredential(){throw g(S)}setAppMetadata(){throw g(S)}getAppMetadata(){throw g(S)}setServerTelemetry(){throw g(S)}getServerTelemetry(){throw g(S)}setAuthorityMetadata(){throw g(S)}getAuthorityMetadata(){throw g(S)}getAuthorityMetadataKeys(){throw g(S)}setThrottlingCache(){throw g(S)}getThrottlingCache(){throw g(S)}removeItem(){throw g(S)}getKeys(){throw g(S)}getAccountKeys(){throw g(S)}getTokenKeys(){throw g(S)}updateCredentialCacheKey(){throw g(S)}removeOutdatedAccount(){throw g(S)}}/*! @azure/msal-common v14.16.0 2024-11-05 */const pr={tokenRenewalOffsetSeconds:Ni,preventCorsPreflight:!1},ha={loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:N.Info,correlationId:u.EMPTY_STRING},da={claimsBasedCachingEnabled:!1},ua={async sendGetRequestAsync(){throw g(S)},async sendPostRequestAsync(){throw g(S)}},ga={sku:u.SKU,version:hn,cpu:u.EMPTY_STRING,os:u.EMPTY_STRING},ma={clientSecret:u.EMPTY_STRING,clientAssertion:void 0},pa={azureCloudInstance:dn.None,tenant:`${u.DEFAULT_COMMON_TENANT}`},fa={application:{appName:"",appVersion:""}};function Ca({authOptions:a,systemOptions:e,loggerOptions:t,cacheOptions:n,storageInterface:o,networkInterface:r,cryptoInterface:i,clientCredentials:s,libraryInfo:c,telemetry:l,serverTelemetryManager:d,persistencePlugin:m,serializableCache:f}){const T={...ha,...t};return{authOptions:ya(a),systemOptions:{...pr,...e},loggerOptions:T,cacheOptions:{...da,...n},storageInterface:o||new la(a.clientId,ht,new pe(T)),networkInterface:r||ua,cryptoInterface:i||ht,clientCredentials:s||ma,libraryInfo:{...ga,...c},telemetry:{...fa,...l},serverTelemetryManager:d||null,persistencePlugin:m||null,serializableCache:f||null}}function ya(a){return{clientCapabilities:[],azureCloudOptions:pa,skipAuthorityMetadataCache:!1,instanceAware:!1,...a}}function zt(a){return a.authOptions.authority.options.protocolMode===le.OIDC}/*! @azure/msal-common v14.16.0 2024-11-05 */const Q={HOME_ACCOUNT_ID:"home_account_id",UPN:"UPN"};/*! @azure/msal-common v14.16.0 2024-11-05 */const ye="client_id",fr="redirect_uri",co="response_type",Ta="response_mode",Aa="grant_type",Ia="claims",Ea="scope",va="refresh_token",Sa="state",wa="nonce",_a="prompt",ka="code",Ra="code_challenge",ba="code_challenge_method",Oa="code_verifier",Na="client-request-id",Pa="x-client-SKU",Ma="x-client-VER",Ua="x-client-OS",La="x-client-CPU",Ha="x-client-current-telemetry",Da="x-client-last-telemetry",Ka="x-ms-lib-capability",xa="x-app-name",Ba="x-app-ver",Fa="post_logout_redirect_uri",Ga="id_token_hint",za="device_code",qa="client_secret",Va="client_assertion",Ya="client_assertion_type",lo="token_type",ho="req_cnf",$a="assertion",Qa="requested_token_use",uo="return_spa_code",Wa="nativebroker",ja="logout_hint",Ja="sid",Xa="login_hint",Za="domain_hint",es="x-client-xtra-sku",In="brk_client_id",qt="brk_redirect_uri";/*! @azure/msal-common v14.16.0 2024-11-05 */class we{static validateRedirectUri(e){if(!e)throw b(jo)}static validatePrompt(e){const t=[];for(const n in D)t.push(D[n]);if(t.indexOf(e)<0)throw b(er)}static validateClaims(e){try{JSON.parse(e)}catch{throw b(gn)}}static validateCodeChallengeParams(e,t){if(!e||!t)throw b(mn);this.validateCodeChallengeMethod(t)}static validateCodeChallengeMethod(e){if([jn.PLAIN,jn.S256].indexOf(e)<0)throw b(or)}}/*! @azure/msal-common v14.16.0 2024-11-05 */function ts(a,e,t){if(!e)return;const n=a.get(ye);n&&a.has(In)&&(t==null||t.addFields({embeddedClientId:n,embeddedRedirectUri:a.get(fr)},e))}class ze{constructor(e,t){this.parameters=new Map,this.performanceClient=t,this.correlationId=e}addResponseTypeCode(){this.parameters.set(co,encodeURIComponent(u.CODE_RESPONSE_TYPE))}addResponseTypeForTokenAndIdToken(){this.parameters.set(co,encodeURIComponent(`${u.TOKEN_RESPONSE_TYPE} ${u.ID_TOKEN_RESPONSE_TYPE}`))}addResponseMode(e){this.parameters.set(Ta,encodeURIComponent(e||Ri.QUERY))}addNativeBroker(){this.parameters.set(Wa,encodeURIComponent("1"))}addScopes(e,t=!0,n=De){t&&!n.includes("openid")&&!e.includes("openid")&&n.push("openid");const o=t?[...e||[],...n]:e||[],r=new M(o);this.parameters.set(Ea,encodeURIComponent(r.printScopes()))}addClientId(e){this.parameters.set(ye,encodeURIComponent(e))}addRedirectUri(e){we.validateRedirectUri(e),this.parameters.set(fr,encodeURIComponent(e))}addPostLogoutRedirectUri(e){we.validateRedirectUri(e),this.parameters.set(Fa,encodeURIComponent(e))}addIdTokenHint(e){this.parameters.set(Ga,encodeURIComponent(e))}addDomainHint(e){this.parameters.set(Za,encodeURIComponent(e))}addLoginHint(e){this.parameters.set(Xa,encodeURIComponent(e))}addCcsUpn(e){this.parameters.set(G.CCS_HEADER,encodeURIComponent(`UPN:${e}`))}addCcsOid(e){this.parameters.set(G.CCS_HEADER,encodeURIComponent(`Oid:${e.uid}@${e.utid}`))}addSid(e){this.parameters.set(Ja,encodeURIComponent(e))}addClaims(e,t){const n=this.addClientCapabilitiesToClaims(e,t);we.validateClaims(n),this.parameters.set(Ia,encodeURIComponent(n))}addCorrelationId(e){this.parameters.set(Na,encodeURIComponent(e))}addLibraryInfo(e){this.parameters.set(Pa,e.sku),this.parameters.set(Ma,e.version),e.os&&this.parameters.set(Ua,e.os),e.cpu&&this.parameters.set(La,e.cpu)}addApplicationTelemetry(e){e!=null&&e.appName&&this.parameters.set(xa,e.appName),e!=null&&e.appVersion&&this.parameters.set(Ba,e.appVersion)}addPrompt(e){we.validatePrompt(e),this.parameters.set(`${_a}`,encodeURIComponent(e))}addState(e){e&&this.parameters.set(Sa,encodeURIComponent(e))}addNonce(e){this.parameters.set(wa,encodeURIComponent(e))}addCodeChallengeParams(e,t){if(we.validateCodeChallengeParams(e,t),e&&t)this.parameters.set(Ra,encodeURIComponent(e)),this.parameters.set(ba,encodeURIComponent(t));else throw b(mn)}addAuthorizationCode(e){this.parameters.set(ka,encodeURIComponent(e))}addDeviceCode(e){this.parameters.set(za,encodeURIComponent(e))}addRefreshToken(e){this.parameters.set(va,encodeURIComponent(e))}addCodeVerifier(e){this.parameters.set(Oa,encodeURIComponent(e))}addClientSecret(e){this.parameters.set(qa,encodeURIComponent(e))}addClientAssertion(e){e&&this.parameters.set(Va,encodeURIComponent(e))}addClientAssertionType(e){e&&this.parameters.set(Ya,encodeURIComponent(e))}addOboAssertion(e){this.parameters.set($a,encodeURIComponent(e))}addRequestTokenUse(e){this.parameters.set(Qa,encodeURIComponent(e))}addGrantType(e){this.parameters.set(Aa,encodeURIComponent(e))}addClientInfo(){this.parameters.set(bi,"1")}addExtraQueryParameters(e){Object.entries(e).forEach(([t,n])=>{!this.parameters.has(t)&&n&&this.parameters.set(t,n)})}addClientCapabilitiesToClaims(e,t){let n;if(!e)n={};else try{n=JSON.parse(e)}catch{throw b(gn)}return t&&t.length>0&&(n.hasOwnProperty(et.ACCESS_TOKEN)||(n[et.ACCESS_TOKEN]={}),n[et.ACCESS_TOKEN][et.XMS_CC]={values:t}),JSON.stringify(n)}addUsername(e){this.parameters.set(Xn.username,encodeURIComponent(e))}addPassword(e){this.parameters.set(Xn.password,encodeURIComponent(e))}addPopToken(e){e&&(this.parameters.set(lo,R.POP),this.parameters.set(ho,encodeURIComponent(e)))}addSshJwk(e){e&&(this.parameters.set(lo,R.SSH),this.parameters.set(ho,encodeURIComponent(e)))}addServerTelemetry(e){this.parameters.set(Ha,e.generateCurrentRequestHeaderValue()),this.parameters.set(Da,e.generateLastRequestHeaderValue())}addThrottling(){this.parameters.set(Ka,Ge.X_MS_LIB_CAPABILITY_VALUE)}addLogoutHint(e){this.parameters.set(ja,encodeURIComponent(e))}addBrokerParameters(e){const t={};t[In]=e.brokerClientId,t[qt]=e.brokerRedirectUri,this.addExtraQueryParameters(t)}createQueryString(){const e=new Array;return this.parameters.forEach((t,n)=>{e.push(`${n}=${t}`)}),ts(this.parameters,this.correlationId,this.performanceClient),e.join("&")}}/*! @azure/msal-common v14.16.0 2024-11-05 */function ns(a){return a.hasOwnProperty("authorization_endpoint")&&a.hasOwnProperty("token_endpoint")&&a.hasOwnProperty("issuer")&&a.hasOwnProperty("jwks_uri")}/*! @azure/msal-common v14.16.0 2024-11-05 */function os(a){return a.hasOwnProperty("tenant_discovery_endpoint")&&a.hasOwnProperty("metadata")}/*! @azure/msal-common v14.16.0 2024-11-05 */function rs(a){return a.hasOwnProperty("error")&&a.hasOwnProperty("error_description")}/*! @azure/msal-common v14.16.0 2024-11-05 */const h={AcquireTokenByCode:"acquireTokenByCode",AcquireTokenByRefreshToken:"acquireTokenByRefreshToken",AcquireTokenSilent:"acquireTokenSilent",AcquireTokenSilentAsync:"acquireTokenSilentAsync",AcquireTokenPopup:"acquireTokenPopup",AcquireTokenPreRedirect:"acquireTokenPreRedirect",AcquireTokenRedirect:"acquireTokenRedirect",CryptoOptsGetPublicKeyThumbprint:"cryptoOptsGetPublicKeyThumbprint",CryptoOptsSignJwt:"cryptoOptsSignJwt",SilentCacheClientAcquireToken:"silentCacheClientAcquireToken",SilentIframeClientAcquireToken:"silentIframeClientAcquireToken",AwaitConcurrentIframe:"awaitConcurrentIframe",SilentRefreshClientAcquireToken:"silentRefreshClientAcquireToken",SsoSilent:"ssoSilent",StandardInteractionClientGetDiscoveredAuthority:"standardInteractionClientGetDiscoveredAuthority",FetchAccountIdWithNativeBroker:"fetchAccountIdWithNativeBroker",NativeInteractionClientAcquireToken:"nativeInteractionClientAcquireToken",BaseClientCreateTokenRequestHeaders:"baseClientCreateTokenRequestHeaders",NetworkClientSendPostRequestAsync:"networkClientSendPostRequestAsync",RefreshTokenClientExecutePostToTokenEndpoint:"refreshTokenClientExecutePostToTokenEndpoint",AuthorizationCodeClientExecutePostToTokenEndpoint:"authorizationCodeClientExecutePostToTokenEndpoint",BrokerHandhshake:"brokerHandshake",AcquireTokenByRefreshTokenInBroker:"acquireTokenByRefreshTokenInBroker",AcquireTokenByBroker:"acquireTokenByBroker",RefreshTokenClientExecuteTokenRequest:"refreshTokenClientExecuteTokenRequest",RefreshTokenClientAcquireToken:"refreshTokenClientAcquireToken",RefreshTokenClientAcquireTokenWithCachedRefreshToken:"refreshTokenClientAcquireTokenWithCachedRefreshToken",RefreshTokenClientAcquireTokenByRefreshToken:"refreshTokenClientAcquireTokenByRefreshToken",RefreshTokenClientCreateTokenRequestBody:"refreshTokenClientCreateTokenRequestBody",AcquireTokenFromCache:"acquireTokenFromCache",SilentFlowClientAcquireCachedToken:"silentFlowClientAcquireCachedToken",SilentFlowClientGenerateResultFromCacheRecord:"silentFlowClientGenerateResultFromCacheRecord",AcquireTokenBySilentIframe:"acquireTokenBySilentIframe",InitializeBaseRequest:"initializeBaseRequest",InitializeSilentRequest:"initializeSilentRequest",InitializeClientApplication:"initializeClientApplication",SilentIframeClientTokenHelper:"silentIframeClientTokenHelper",SilentHandlerInitiateAuthRequest:"silentHandlerInitiateAuthRequest",SilentHandlerMonitorIframeForHash:"silentHandlerMonitorIframeForHash",SilentHandlerLoadFrame:"silentHandlerLoadFrame",SilentHandlerLoadFrameSync:"silentHandlerLoadFrameSync",StandardInteractionClientCreateAuthCodeClient:"standardInteractionClientCreateAuthCodeClient",StandardInteractionClientGetClientConfiguration:"standardInteractionClientGetClientConfiguration",StandardInteractionClientInitializeAuthorizationRequest:"standardInteractionClientInitializeAuthorizationRequest",StandardInteractionClientInitializeAuthorizationCodeRequest:"standardInteractionClientInitializeAuthorizationCodeRequest",GetAuthCodeUrl:"getAuthCodeUrl",HandleCodeResponseFromServer:"handleCodeResponseFromServer",HandleCodeResponse:"handleCodeResponse",UpdateTokenEndpointAuthority:"updateTokenEndpointAuthority",AuthClientAcquireToken:"authClientAcquireToken",AuthClientExecuteTokenRequest:"authClientExecuteTokenRequest",AuthClientCreateTokenRequestBody:"authClientCreateTokenRequestBody",AuthClientCreateQueryString:"authClientCreateQueryString",PopTokenGenerateCnf:"popTokenGenerateCnf",PopTokenGenerateKid:"popTokenGenerateKid",HandleServerTokenResponse:"handleServerTokenResponse",DeserializeResponse:"deserializeResponse",AuthorityFactoryCreateDiscoveredInstance:"authorityFactoryCreateDiscoveredInstance",AuthorityResolveEndpointsAsync:"authorityResolveEndpointsAsync",AuthorityResolveEndpointsFromLocalSources:"authorityResolveEndpointsFromLocalSources",AuthorityGetCloudDiscoveryMetadataFromNetwork:"authorityGetCloudDiscoveryMetadataFromNetwork",AuthorityUpdateCloudDiscoveryMetadata:"authorityUpdateCloudDiscoveryMetadata",AuthorityGetEndpointMetadataFromNetwork:"authorityGetEndpointMetadataFromNetwork",AuthorityUpdateEndpointMetadata:"authorityUpdateEndpointMetadata",AuthorityUpdateMetadataWithRegionalInformation:"authorityUpdateMetadataWithRegionalInformation",RegionDiscoveryDetectRegion:"regionDiscoveryDetectRegion",RegionDiscoveryGetRegionFromIMDS:"regionDiscoveryGetRegionFromIMDS",RegionDiscoveryGetCurrentVersion:"regionDiscoveryGetCurrentVersion",AcquireTokenByCodeAsync:"acquireTokenByCodeAsync",GetEndpointMetadataFromNetwork:"getEndpointMetadataFromNetwork",GetCloudDiscoveryMetadataFromNetworkMeasurement:"getCloudDiscoveryMetadataFromNetworkMeasurement",HandleRedirectPromiseMeasurement:"handleRedirectPromise",HandleNativeRedirectPromiseMeasurement:"handleNativeRedirectPromise",UpdateCloudDiscoveryMetadataMeasurement:"updateCloudDiscoveryMetadataMeasurement",UsernamePasswordClientAcquireToken:"usernamePasswordClientAcquireToken",NativeMessageHandlerHandshake:"nativeMessageHandlerHandshake",NativeGenerateAuthResult:"nativeGenerateAuthResult",RemoveHiddenIframe:"removeHiddenIframe",ClearTokensAndKeysWithClaims:"clearTokensAndKeysWithClaims",CacheManagerGetRefreshToken:"cacheManagerGetRefreshToken",GeneratePkceCodes:"generatePkceCodes",GenerateCodeVerifier:"generateCodeVerifier",GenerateCodeChallengeFromVerifier:"generateCodeChallengeFromVerifier",Sha256Digest:"sha256Digest",GetRandomValues:"getRandomValues"},is={NotStarted:0,InProgress:1,Completed:2};/*! @azure/msal-common v14.16.0 2024-11-05 */const ve=(a,e,t,n,o)=>(...r)=>{t.trace(`Executing function ${e}`);const i=n==null?void 0:n.startMeasurement(e,o);if(o){const s=e+"CallCount";n==null||n.incrementFields({[s]:1},o)}try{const s=a(...r);return i==null||i.end({success:!0}),t.trace(`Returning result from ${e}`),s}catch(s){t.trace(`Error occurred in ${e}`);try{t.trace(JSON.stringify(s))}catch{t.trace("Unable to print error message.")}throw i==null||i.end({success:!1},s),s}},p=(a,e,t,n,o)=>(...r)=>{t.trace(`Executing function ${e}`);const i=n==null?void 0:n.startMeasurement(e,o);if(o){const s=e+"CallCount";n==null||n.incrementFields({[s]:1},o)}return n==null||n.setPreQueueTime(e,o),a(...r).then(s=>(t.trace(`Returning result from ${e}`),i==null||i.end({success:!0}),s)).catch(s=>{t.trace(`Error occurred in ${e}`);try{t.trace(JSON.stringify(s))}catch{t.trace("Unable to print error message.")}throw i==null||i.end({success:!1},s),s})};/*! @azure/msal-common v14.16.0 2024-11-05 */class vt{constructor(e,t,n,o){this.networkInterface=e,this.logger=t,this.performanceClient=n,this.correlationId=o}async detectRegion(e,t){var o;(o=this.performanceClient)==null||o.addQueueMeasurement(h.RegionDiscoveryDetectRegion,this.correlationId);let n=e;if(n)t.region_source=Se.ENVIRONMENT_VARIABLE;else{const r=vt.IMDS_OPTIONS;try{const i=await p(this.getRegionFromIMDS.bind(this),h.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(u.IMDS_VERSION,r);if(i.status===nt.httpSuccess&&(n=i.body,t.region_source=Se.IMDS),i.status===nt.httpBadRequest){const s=await p(this.getCurrentVersion.bind(this),h.RegionDiscoveryGetCurrentVersion,this.logger,this.performanceClient,this.correlationId)(r);if(!s)return t.region_source=Se.FAILED_AUTO_DETECTION,null;const c=await p(this.getRegionFromIMDS.bind(this),h.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(s,r);c.status===nt.httpSuccess&&(n=c.body,t.region_source=Se.IMDS)}}catch{return t.region_source=Se.FAILED_AUTO_DETECTION,null}}return n||(t.region_source=Se.FAILED_AUTO_DETECTION),n||null}async getRegionFromIMDS(e,t){var n;return(n=this.performanceClient)==null||n.addQueueMeasurement(h.RegionDiscoveryGetRegionFromIMDS,this.correlationId),this.networkInterface.sendGetRequestAsync(`${u.IMDS_ENDPOINT}?api-version=${e}&format=text`,t,u.IMDS_TIMEOUT)}async getCurrentVersion(e){var t;(t=this.performanceClient)==null||t.addQueueMeasurement(h.RegionDiscoveryGetCurrentVersion,this.correlationId);try{const n=await this.networkInterface.sendGetRequestAsync(`${u.IMDS_ENDPOINT}?format=json`,e);return n.status===nt.httpBadRequest&&n.body&&n.body["newest-versions"]&&n.body["newest-versions"].length>0?n.body["newest-versions"][0]:null}catch{return null}}}vt.IMDS_OPTIONS={headers:{Metadata:"true"}};/*! @azure/msal-common v14.16.0 2024-11-05 */class x{constructor(e,t,n,o,r,i,s,c){this.canonicalAuthority=e,this._canonicalAuthority.validateAsUri(),this.networkInterface=t,this.cacheManager=n,this.authorityOptions=o,this.regionDiscoveryMetadata={region_used:void 0,region_source:void 0,region_outcome:void 0},this.logger=r,this.performanceClient=s,this.correlationId=i,this.managedIdentity=c||!1,this.regionDiscovery=new vt(t,this.logger,this.performanceClient,this.correlationId)}getAuthorityType(e){if(e.HostNameAndPort.endsWith(u.CIAM_AUTH_URL))return W.Ciam;const t=e.PathSegments;if(t.length)switch(t[0].toLowerCase()){case u.ADFS:return W.Adfs;case u.DSTS:return W.Dsts}return W.Default}get authorityType(){return this.getAuthorityType(this.canonicalAuthorityUrlComponents)}get protocolMode(){return this.authorityOptions.protocolMode}get options(){return this.authorityOptions}get canonicalAuthority(){return this._canonicalAuthority.urlString}set canonicalAuthority(e){this._canonicalAuthority=new w(e),this._canonicalAuthority.validateAsUri(),this._canonicalAuthorityUrlComponents=null}get canonicalAuthorityUrlComponents(){return this._canonicalAuthorityUrlComponents||(this._canonicalAuthorityUrlComponents=this._canonicalAuthority.getUrlComponents()),this._canonicalAuthorityUrlComponents}get hostnameAndPort(){return this.canonicalAuthorityUrlComponents.HostNameAndPort.toLowerCase()}get tenant(){return this.canonicalAuthorityUrlComponents.PathSegments[0]}get authorizationEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.authorization_endpoint);throw g(ae)}get tokenEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint);throw g(ae)}get deviceCodeEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint.replace("/token","/devicecode"));throw g(ae)}get endSessionEndpoint(){if(this.discoveryComplete()){if(!this.metadata.end_session_endpoint)throw g(Yo);return this.replacePath(this.metadata.end_session_endpoint)}else throw g(ae)}get selfSignedJwtAudience(){if(this.discoveryComplete())return this.replacePath(this.metadata.issuer);throw g(ae)}get jwksUri(){if(this.discoveryComplete())return this.replacePath(this.metadata.jwks_uri);throw g(ae)}canReplaceTenant(e){return e.PathSegments.length===1&&!x.reservedTenantDomains.has(e.PathSegments[0])&&this.getAuthorityType(e)===W.Default&&this.protocolMode===le.AAD}replaceTenant(e){return e.replace(/{tenant}|{tenantid}/g,this.tenant)}replacePath(e){let t=e;const o=new w(this.metadata.canonical_authority).getUrlComponents(),r=o.PathSegments;return this.canonicalAuthorityUrlComponents.PathSegments.forEach((s,c)=>{let l=r[c];if(c===0&&this.canReplaceTenant(o)){const d=new w(this.metadata.authorization_endpoint).getUrlComponents().PathSegments[0];l!==d&&(this.logger.verbose(`Replacing tenant domain name ${l} with id ${d}`),l=d)}s!==l&&(t=t.replace(`/${l}/`,`/${s}/`))}),this.replaceTenant(t)}get defaultOpenIdConfigurationEndpoint(){const e=this.hostnameAndPort;return this.canonicalAuthority.endsWith("v2.0/")||this.authorityType===W.Adfs||this.protocolMode!==le.AAD&&!this.isAliasOfKnownMicrosoftAuthority(e)?`${this.canonicalAuthority}.well-known/openid-configuration`:`${this.canonicalAuthority}v2.0/.well-known/openid-configuration`}discoveryComplete(){return!!this.metadata}async resolveEndpointsAsync(){var o,r;(o=this.performanceClient)==null||o.addQueueMeasurement(h.AuthorityResolveEndpointsAsync,this.correlationId);const e=this.getCurrentMetadataEntity(),t=await p(this.updateCloudDiscoveryMetadata.bind(this),h.AuthorityUpdateCloudDiscoveryMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.canonicalAuthority=this.canonicalAuthority.replace(this.hostnameAndPort,e.preferred_network);const n=await p(this.updateEndpointMetadata.bind(this),h.AuthorityUpdateEndpointMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.updateCachedMetadata(e,t,{source:n}),(r=this.performanceClient)==null||r.addFields({cloudDiscoverySource:t,authorityEndpointSource:n},this.correlationId)}getCurrentMetadataEntity(){let e=this.cacheManager.getAuthorityMetadataByAlias(this.hostnameAndPort);return e||(e={aliases:[],preferred_cache:this.hostnameAndPort,preferred_network:this.hostnameAndPort,canonical_authority:this.canonicalAuthority,authorization_endpoint:"",token_endpoint:"",end_session_endpoint:"",issuer:"",aliasesFromNetwork:!1,endpointsFromNetwork:!1,expiresAt:ro(),jwks_uri:""}),e}updateCachedMetadata(e,t,n){t!==V.CACHE&&(n==null?void 0:n.source)!==V.CACHE&&(e.expiresAt=ro(),e.canonical_authority=this.canonicalAuthority);const o=this.cacheManager.generateAuthorityMetadataCacheKey(e.preferred_cache);this.cacheManager.setAuthorityMetadata(o,e),this.metadata=e}async updateEndpointMetadata(e){var o,r,i;(o=this.performanceClient)==null||o.addQueueMeasurement(h.AuthorityUpdateEndpointMetadata,this.correlationId);const t=this.updateEndpointMetadataFromLocalSources(e);if(t){if(t.source===V.HARDCODED_VALUES&&(r=this.authorityOptions.azureRegionConfiguration)!=null&&r.azureRegion&&t.metadata){const s=await p(this.updateMetadataWithRegionalInformation.bind(this),h.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(t.metadata);ot(e,s,!1),e.canonical_authority=this.canonicalAuthority}return t.source}let n=await p(this.getEndpointMetadataFromNetwork.bind(this),h.AuthorityGetEndpointMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(n)return(i=this.authorityOptions.azureRegionConfiguration)!=null&&i.azureRegion&&(n=await p(this.updateMetadataWithRegionalInformation.bind(this),h.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(n)),ot(e,n,!0),V.NETWORK;throw g(Mo,this.defaultOpenIdConfigurationEndpoint)}updateEndpointMetadataFromLocalSources(e){this.logger.verbose("Attempting to get endpoint metadata from authority configuration");const t=this.getEndpointMetadataFromConfig();if(t)return this.logger.verbose("Found endpoint metadata in authority configuration"),ot(e,t,!1),{source:V.CONFIG};if(this.logger.verbose("Did not find endpoint metadata in the config... Attempting to get endpoint metadata from the hardcoded values."),this.authorityOptions.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get endpoint metadata from the network metadata cache.");else{const o=this.getEndpointMetadataFromHardcodedValues();if(o)return ot(e,o,!1),{source:V.HARDCODED_VALUES,metadata:o};this.logger.verbose("Did not find endpoint metadata in hardcoded values... Attempting to get endpoint metadata from the network metadata cache.")}const n=io(e);return this.isAuthoritySameType(e)&&e.endpointsFromNetwork&&!n?(this.logger.verbose("Found endpoint metadata in the cache."),{source:V.CACHE}):(n&&this.logger.verbose("The metadata entity is expired."),null)}isAuthoritySameType(e){return new w(e.canonical_authority).getUrlComponents().PathSegments.length===this.canonicalAuthorityUrlComponents.PathSegments.length}getEndpointMetadataFromConfig(){if(this.authorityOptions.authorityMetadata)try{return JSON.parse(this.authorityOptions.authorityMetadata)}catch{throw b(rr)}return null}async getEndpointMetadataFromNetwork(){var n;(n=this.performanceClient)==null||n.addQueueMeasurement(h.AuthorityGetEndpointMetadataFromNetwork,this.correlationId);const e={},t=this.defaultOpenIdConfigurationEndpoint;this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: attempting to retrieve OAuth endpoints from ${t}`);try{const o=await this.networkInterface.sendGetRequestAsync(t,e);return ns(o.body)?o.body:(this.logger.verbose("Authority.getEndpointMetadataFromNetwork: could not parse response as OpenID configuration"),null)}catch(o){return this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: ${o}`),null}}getEndpointMetadataFromHardcodedValues(){return this.hostnameAndPort in ao?ao[this.hostnameAndPort]:null}async updateMetadataWithRegionalInformation(e){var n,o,r;(n=this.performanceClient)==null||n.addQueueMeasurement(h.AuthorityUpdateMetadataWithRegionalInformation,this.correlationId);const t=(o=this.authorityOptions.azureRegionConfiguration)==null?void 0:o.azureRegion;if(t){if(t!==u.AZURE_REGION_AUTO_DISCOVER_FLAG)return this.regionDiscoveryMetadata.region_outcome=Mt.CONFIGURED_NO_AUTO_DETECTION,this.regionDiscoveryMetadata.region_used=t,x.replaceWithRegionalInformation(e,t);const i=await p(this.regionDiscovery.detectRegion.bind(this.regionDiscovery),h.RegionDiscoveryDetectRegion,this.logger,this.performanceClient,this.correlationId)((r=this.authorityOptions.azureRegionConfiguration)==null?void 0:r.environmentRegion,this.regionDiscoveryMetadata);if(i)return this.regionDiscoveryMetadata.region_outcome=Mt.AUTO_DETECTION_REQUESTED_SUCCESSFUL,this.regionDiscoveryMetadata.region_used=i,x.replaceWithRegionalInformation(e,i);this.regionDiscoveryMetadata.region_outcome=Mt.AUTO_DETECTION_REQUESTED_FAILED}return e}async updateCloudDiscoveryMetadata(e){var o;(o=this.performanceClient)==null||o.addQueueMeasurement(h.AuthorityUpdateCloudDiscoveryMetadata,this.correlationId);const t=this.updateCloudDiscoveryMetadataFromLocalSources(e);if(t)return t;const n=await p(this.getCloudDiscoveryMetadataFromNetwork.bind(this),h.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(n)return Ut(e,n,!0),V.NETWORK;throw b(ir)}updateCloudDiscoveryMetadataFromLocalSources(e){this.logger.verbose("Attempting to get cloud discovery metadata  from authority configuration"),this.logger.verbosePii(`Known Authorities: ${this.authorityOptions.knownAuthorities||u.NOT_APPLICABLE}`),this.logger.verbosePii(`Authority Metadata: ${this.authorityOptions.authorityMetadata||u.NOT_APPLICABLE}`),this.logger.verbosePii(`Canonical Authority: ${e.canonical_authority||u.NOT_APPLICABLE}`);const t=this.getCloudDiscoveryMetadataFromConfig();if(t)return this.logger.verbose("Found cloud discovery metadata in authority configuration"),Ut(e,t,!1),V.CONFIG;if(this.logger.verbose("Did not find cloud discovery metadata in the config... Attempting to get cloud discovery metadata from the hardcoded values."),this.options.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded cloud discovery metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get cloud discovery metadata from the network metadata cache.");else{const o=ca(this.hostnameAndPort);if(o)return this.logger.verbose("Found cloud discovery metadata from hardcoded values."),Ut(e,o,!1),V.HARDCODED_VALUES;this.logger.verbose("Did not find cloud discovery metadata in hardcoded values... Attempting to get cloud discovery metadata from the network metadata cache.")}const n=io(e);return this.isAuthoritySameType(e)&&e.aliasesFromNetwork&&!n?(this.logger.verbose("Found cloud discovery metadata in the cache."),V.CACHE):(n&&this.logger.verbose("The metadata entity is expired."),null)}getCloudDiscoveryMetadataFromConfig(){if(this.authorityType===W.Ciam)return this.logger.verbose("CIAM authorities do not support cloud discovery metadata, generate the aliases from authority host."),x.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort);if(this.authorityOptions.cloudDiscoveryMetadata){this.logger.verbose("The cloud discovery metadata has been provided as a network response, in the config.");try{this.logger.verbose("Attempting to parse the cloud discovery metadata.");const e=JSON.parse(this.authorityOptions.cloudDiscoveryMetadata),t=mt(e.metadata,this.hostnameAndPort);if(this.logger.verbose("Parsed the cloud discovery metadata."),t)return this.logger.verbose("There is returnable metadata attached to the parsed cloud discovery metadata."),t;this.logger.verbose("There is no metadata attached to the parsed cloud discovery metadata.")}catch{throw this.logger.verbose("Unable to parse the cloud discovery metadata. Throwing Invalid Cloud Discovery Metadata Error."),b(pn)}}return this.isInKnownAuthorities()?(this.logger.verbose("The host is included in knownAuthorities. Creating new cloud discovery metadata from the host."),x.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)):null}async getCloudDiscoveryMetadataFromNetwork(){var o;(o=this.performanceClient)==null||o.addQueueMeasurement(h.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.correlationId);const e=`${u.AAD_INSTANCE_DISCOVERY_ENDPT}${this.canonicalAuthority}oauth2/v2.0/authorize`,t={};let n=null;try{const r=await this.networkInterface.sendGetRequestAsync(e,t);let i,s;if(os(r.body))i=r.body,s=i.metadata,this.logger.verbosePii(`tenant_discovery_endpoint is: ${i.tenant_discovery_endpoint}`);else if(rs(r.body)){if(this.logger.warning(`A CloudInstanceDiscoveryErrorResponse was returned. The cloud instance discovery network request's status code is: ${r.status}`),i=r.body,i.error===u.INVALID_INSTANCE)return this.logger.error("The CloudInstanceDiscoveryErrorResponse error is invalid_instance."),null;this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error is ${i.error}`),this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error description is ${i.error_description}`),this.logger.warning("Setting the value of the CloudInstanceDiscoveryMetadata (returned from the network) to []"),s=[]}else return this.logger.error("AAD did not return a CloudInstanceDiscoveryResponse or CloudInstanceDiscoveryErrorResponse"),null;this.logger.verbose("Attempting to find a match between the developer's authority and the CloudInstanceDiscoveryMetadata returned from the network request."),n=mt(s,this.hostnameAndPort)}catch(r){if(r instanceof P)this.logger.error(`There was a network error while attempting to get the cloud discovery instance metadata.
Error: ${r.errorCode}
Error Description: ${r.errorMessage}`);else{const i=r;this.logger.error(`A non-MSALJS error was thrown while attempting to get the cloud instance discovery metadata.
Error: ${i.name}
Error Description: ${i.message}`)}return null}return n||(this.logger.warning("The developer's authority was not found within the CloudInstanceDiscoveryMetadata returned from the network request."),this.logger.verbose("Creating custom Authority for custom domain scenario."),n=x.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)),n}isInKnownAuthorities(){return this.authorityOptions.knownAuthorities.filter(t=>t&&w.getDomainFromUrl(t).toLowerCase()===this.hostnameAndPort).length>0}static generateAuthority(e,t){let n;if(t&&t.azureCloudInstance!==dn.None){const o=t.tenant?t.tenant:u.DEFAULT_COMMON_TENANT;n=`${t.azureCloudInstance}/${o}/`}return n||e}static createCloudDiscoveryMetadataFromHost(e){return{preferred_network:e,preferred_cache:e,aliases:[e]}}getPreferredCache(){if(this.managedIdentity)return u.DEFAULT_AUTHORITY_HOST;if(this.discoveryComplete())return this.metadata.preferred_cache;throw g(ae)}isAlias(e){return this.metadata.aliases.indexOf(e)>-1}isAliasOfKnownMicrosoftAuthority(e){return gr.has(e)}static isPublicCloudAuthority(e){return u.KNOWN_PUBLIC_CLOUDS.indexOf(e)>=0}static buildRegionalAuthorityString(e,t,n){const o=new w(e);o.validateAsUri();const r=o.getUrlComponents();let i=`${t}.${r.HostNameAndPort}`;this.isPublicCloudAuthority(r.HostNameAndPort)&&(i=`${t}.${u.REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX}`);const s=w.constructAuthorityUriFromObject({...o.getUrlComponents(),HostNameAndPort:i}).urlString;return n?`${s}?${n}`:s}static replaceWithRegionalInformation(e,t){const n={...e};return n.authorization_endpoint=x.buildRegionalAuthorityString(n.authorization_endpoint,t),n.token_endpoint=x.buildRegionalAuthorityString(n.token_endpoint,t),n.end_session_endpoint&&(n.end_session_endpoint=x.buildRegionalAuthorityString(n.end_session_endpoint,t)),n}static transformCIAMAuthority(e){let t=e;const o=new w(e).getUrlComponents();if(o.PathSegments.length===0&&o.HostNameAndPort.endsWith(u.CIAM_AUTH_URL)){const r=o.HostNameAndPort.split(".")[0];t=`${t}${r}${u.AAD_TENANT_DOMAIN_SUFFIX}`}return t}}x.reservedTenantDomains=new Set(["{tenant}","{tenantid}",me.COMMON,me.CONSUMERS,me.ORGANIZATIONS]);function as(a){var o;const n=(o=new w(a).getUrlComponents().PathSegments.slice(-1)[0])==null?void 0:o.toLowerCase();switch(n){case me.COMMON:case me.ORGANIZATIONS:case me.CONSUMERS:return;default:return n}}function Cr(a){return a.endsWith(u.FORWARD_SLASH)?a:`${a}${u.FORWARD_SLASH}`}function ss(a){const e=a.cloudDiscoveryMetadata;let t;if(e)try{t=JSON.parse(e)}catch{throw b(pn)}return{canonicalAuthority:a.authority?Cr(a.authority):void 0,knownAuthorities:a.knownAuthorities,cloudDiscoveryMetadata:t}}/*! @azure/msal-common v14.16.0 2024-11-05 */async function yr(a,e,t,n,o,r,i){i==null||i.addQueueMeasurement(h.AuthorityFactoryCreateDiscoveredInstance,r);const s=x.transformCIAMAuthority(Cr(a)),c=new x(s,e,t,n,o,r,i);try{return await p(c.resolveEndpointsAsync.bind(c),h.AuthorityResolveEndpointsAsync,o,i,r)(),c}catch{throw g(ae)}}/*! @azure/msal-common v14.16.0 2024-11-05 */class fe extends P{constructor(e,t,n,o,r){super(e,t,n),this.name="ServerError",this.errorNo=o,this.status=r,Object.setPrototypeOf(this,fe.prototype)}}/*! @azure/msal-common v14.16.0 2024-11-05 */class ee{static generateThrottlingStorageKey(e){return`${Ge.THROTTLING_PREFIX}.${JSON.stringify(e)}`}static preProcess(e,t){var r;const n=ee.generateThrottlingStorageKey(t),o=e.getThrottlingCache(n);if(o){if(o.throttleTime<Date.now()){e.removeItem(n);return}throw new fe(((r=o.errorCodes)==null?void 0:r.join(" "))||u.EMPTY_STRING,o.errorMessage,o.subError)}}static postProcess(e,t,n){if(ee.checkResponseStatus(n)||ee.checkResponseForRetryAfter(n)){const o={throttleTime:ee.calculateThrottleTime(parseInt(n.headers[G.RETRY_AFTER])),error:n.body.error,errorCodes:n.body.error_codes,errorMessage:n.body.error_description,subError:n.body.suberror};e.setThrottlingCache(ee.generateThrottlingStorageKey(t),o)}}static checkResponseStatus(e){return e.status===429||e.status>=500&&e.status<600}static checkResponseForRetryAfter(e){return e.headers?e.headers.hasOwnProperty(G.RETRY_AFTER)&&(e.status<200||e.status>=300):!1}static calculateThrottleTime(e){const t=e<=0?0:e,n=Date.now()/1e3;return Math.floor(Math.min(n+(t||Ge.DEFAULT_THROTTLE_TIME_SECONDS),n+Ge.DEFAULT_MAX_THROTTLE_TIME_SECONDS)*1e3)}static removeThrottle(e,t,n,o){const r={clientId:t,authority:n.authority,scopes:n.scopes,homeAccountIdentifier:o,claims:n.claims,authenticationScheme:n.authenticationScheme,resourceRequestMethod:n.resourceRequestMethod,resourceRequestUri:n.resourceRequestUri,shrClaims:n.shrClaims,sshKid:n.sshKid},i=this.generateThrottlingStorageKey(r);e.removeItem(i)}}/*! @azure/msal-common v14.16.0 2024-11-05 */class St extends P{constructor(e,t,n){super(e.errorCode,e.errorMessage,e.subError),Object.setPrototypeOf(this,St.prototype),this.name="NetworkError",this.error=e,this.httpStatus=t,this.responseHeaders=n}}function go(a,e,t){return new St(a,e,t)}/*! @azure/msal-common v14.16.0 2024-11-05 */class En{constructor(e,t){this.config=Ca(e),this.logger=new pe(this.config.loggerOptions,$o,hn),this.cryptoUtils=this.config.cryptoInterface,this.cacheManager=this.config.storageInterface,this.networkClient=this.config.networkInterface,this.serverTelemetryManager=this.config.serverTelemetryManager,this.authority=this.config.authOptions.authority,this.performanceClient=t}createTokenRequestHeaders(e){const t={};if(t[G.CONTENT_TYPE]=u.URL_FORM_CONTENT_TYPE,!this.config.systemOptions.preventCorsPreflight&&e)switch(e.type){case Q.HOME_ACCOUNT_ID:try{const n=be(e.credential);t[G.CCS_HEADER]=`Oid:${n.uid}@${n.utid}`}catch(n){this.logger.verbose("Could not parse home account ID for CCS Header: "+n)}break;case Q.UPN:t[G.CCS_HEADER]=`UPN: ${e.credential}`;break}return t}async executePostToTokenEndpoint(e,t,n,o,r,i){var c;i&&((c=this.performanceClient)==null||c.addQueueMeasurement(i,r));const s=await this.sendPostRequest(o,e,{body:t,headers:n},r);return this.config.serverTelemetryManager&&s.status<500&&s.status!==429&&this.config.serverTelemetryManager.clearTelemetryCache(),s}async sendPostRequest(e,t,n,o){var i,s,c;ee.preProcess(this.cacheManager,e);let r;try{r=await p(this.networkClient.sendPostRequestAsync.bind(this.networkClient),h.NetworkClientSendPostRequestAsync,this.logger,this.performanceClient,o)(t,n);const l=r.headers||{};(s=this.performanceClient)==null||s.addFields({refreshTokenSize:((i=r.body.refresh_token)==null?void 0:i.length)||0,httpVerToken:l[G.X_MS_HTTP_VERSION]||"",requestId:l[G.X_MS_REQUEST_ID]||""},o)}catch(l){if(l instanceof St){const d=l.responseHeaders;throw d&&((c=this.performanceClient)==null||c.addFields({httpVerToken:d[G.X_MS_HTTP_VERSION]||"",requestId:d[G.X_MS_REQUEST_ID]||"",contentTypeHeader:d[G.CONTENT_TYPE]||void 0,contentLengthHeader:d[G.CONTENT_LENGTH]||void 0,httpStatus:l.httpStatus},o)),l.error}throw l instanceof P?l:g(Po)}return ee.postProcess(this.cacheManager,e,r),r}async updateAuthority(e,t){var r;(r=this.performanceClient)==null||r.addQueueMeasurement(h.UpdateTokenEndpointAuthority,t);const n=`https://${e}/${this.authority.tenant}/`,o=await yr(n,this.networkClient,this.cacheManager,this.authority.options,this.logger,t,this.performanceClient);this.authority=o}createTokenQueryParameters(e){const t=new ze(e.correlationId,this.performanceClient);return e.embeddedClientId&&t.addBrokerParameters({brokerClientId:this.config.authOptions.clientId,brokerRedirectUri:this.config.authOptions.redirectUri}),e.tokenQueryParameters&&t.addExtraQueryParameters(e.tokenQueryParameters),t.addCorrelationId(e.correlationId),t.createQueryString()}}/*! @azure/msal-common v14.16.0 2024-11-05 */const pt="no_tokens_found",Tr="native_account_unavailable",vn="refresh_token_expired",cs="interaction_required",ls="consent_required",hs="login_required",wt="bad_token";/*! @azure/msal-common v14.16.0 2024-11-05 */const mo=[cs,ls,hs,wt],ds=["message_only","additional_action","basic_action","user_password_expired","consent_required","bad_token"],us={[pt]:"No refresh token found in the cache. Please sign-in.",[Tr]:"The requested account is not available in the native broker. It may have been deleted or logged out. Please sign-in again using an interactive API.",[vn]:"Refresh token has expired.",[wt]:"Identity provider returned bad_token due to an expired or invalid refresh token. Please invoke an interactive API to resolve."};class X extends P{constructor(e,t,n,o,r,i,s,c){super(e,t,n),Object.setPrototypeOf(this,X.prototype),this.timestamp=o||u.EMPTY_STRING,this.traceId=r||u.EMPTY_STRING,this.correlationId=i||u.EMPTY_STRING,this.claims=s||u.EMPTY_STRING,this.name="InteractionRequiredAuthError",this.errorNo=c}}function po(a,e,t){const n=!!a&&mo.indexOf(a)>-1,o=!!t&&ds.indexOf(t)>-1,r=!!e&&mo.some(i=>e.indexOf(i)>-1);return n||r||o}function Vt(a){return new X(a,us[a])}/*! @azure/msal-common v14.16.0 2024-11-05 */class J{static setRequestState(e,t,n){const o=J.generateLibraryState(e,n);return t?`${o}${u.RESOURCE_DELIM}${t}`:o}static generateLibraryState(e,t){if(!e)throw g(Bt);const n={id:e.createNewGuid()};t&&(n.meta=t);const o=JSON.stringify(n);return e.base64Encode(o)}static parseRequestState(e,t){if(!e)throw g(Bt);if(!t)throw g(Me);try{const n=t.split(u.RESOURCE_DELIM),o=n[0],r=n.length>1?n.slice(1).join(u.RESOURCE_DELIM):u.EMPTY_STRING,i=e.base64Decode(o),s=JSON.parse(i);return{userRequestState:r||u.EMPTY_STRING,libraryState:s}}catch{throw g(Me)}}}/*! @azure/msal-common v14.16.0 2024-11-05 */const gs={SW:"sw",UHW:"uhw"};class Le{constructor(e,t){this.cryptoUtils=e,this.performanceClient=t}async generateCnf(e,t){var r;(r=this.performanceClient)==null||r.addQueueMeasurement(h.PopTokenGenerateCnf,e.correlationId);const n=await p(this.generateKid.bind(this),h.PopTokenGenerateCnf,t,this.performanceClient,e.correlationId)(e),o=this.cryptoUtils.base64UrlEncode(JSON.stringify(n));return{kid:n.kid,reqCnfString:o}}async generateKid(e){var n;return(n=this.performanceClient)==null||n.addQueueMeasurement(h.PopTokenGenerateKid,e.correlationId),{kid:await this.cryptoUtils.getPublicKeyThumbprint(e),xms_ksl:gs.SW}}async signPopToken(e,t,n){return this.signPayload(e,t,n)}async signPayload(e,t,n,o){const{resourceRequestMethod:r,resourceRequestUri:i,shrClaims:s,shrNonce:c,shrOptions:l}=n,d=i?new w(i):void 0,m=d==null?void 0:d.getUrlComponents();return this.cryptoUtils.signJwt({at:e,ts:re(),m:r==null?void 0:r.toUpperCase(),u:m==null?void 0:m.HostNameAndPort,nonce:c||this.cryptoUtils.createNewGuid(),p:m==null?void 0:m.AbsolutePath,q:m!=null&&m.QueryString?[[],m.QueryString]:void 0,client_claims:s||void 0,...o},t,l,n.correlationId)}}/*! @azure/msal-common v14.16.0 2024-11-05 */class ms{constructor(e,t){this.cache=e,this.hasChanged=t}get cacheHasChanged(){return this.hasChanged}get tokenCache(){return this.cache}}/*! @azure/msal-common v14.16.0 2024-11-05 */function ps(a){var n,o;const e="code=",t=(n=a.error_uri)==null?void 0:n.lastIndexOf(e);return t&&t>=0?(o=a.error_uri)==null?void 0:o.substring(t+e.length):void 0}class Te{constructor(e,t,n,o,r,i,s){this.clientId=e,this.cacheStorage=t,this.cryptoObj=n,this.logger=o,this.serializableCache=r,this.persistencePlugin=i,this.performanceClient=s}validateServerAuthorizationCodeResponse(e,t){if(!e.state||!t)throw e.state?g(lt,"Cached State"):g(lt,"Server State");let n,o;try{n=decodeURIComponent(e.state)}catch{throw g(Me,e.state)}try{o=decodeURIComponent(t)}catch{throw g(Me,e.state)}if(n!==o)throw g(Lo);if(e.error||e.error_description||e.suberror){const r=ps(e);throw po(e.error,e.error_description,e.suberror)?new X(e.error||"",e.error_description,e.suberror,e.timestamp||"",e.trace_id||"",e.correlation_id||"",e.claims||"",r):new fe(e.error||"",e.error_description,e.suberror,r)}}validateTokenResponse(e,t){var n;if(e.error||e.error_description||e.suberror){const o=`Error(s): ${e.error_codes||u.NOT_AVAILABLE} - Timestamp: ${e.timestamp||u.NOT_AVAILABLE} - Description: ${e.error_description||u.NOT_AVAILABLE} - Correlation ID: ${e.correlation_id||u.NOT_AVAILABLE} - Trace ID: ${e.trace_id||u.NOT_AVAILABLE}`,r=(n=e.error_codes)!=null&&n.length?e.error_codes[0]:void 0,i=new fe(e.error,o,e.suberror,r,e.status);if(t&&e.status&&e.status>=Ze.SERVER_ERROR_RANGE_START&&e.status<=Ze.SERVER_ERROR_RANGE_END){this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently unavailable and the access token is unable to be refreshed.
${i}`);return}else if(t&&e.status&&e.status>=Ze.CLIENT_ERROR_RANGE_START&&e.status<=Ze.CLIENT_ERROR_RANGE_END){this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently available but is unable to refresh the access token.
${i}`);return}throw po(e.error,e.error_description,e.suberror)?new X(e.error,e.error_description,e.suberror,e.timestamp||u.EMPTY_STRING,e.trace_id||u.EMPTY_STRING,e.correlation_id||u.EMPTY_STRING,e.claims||u.EMPTY_STRING,r):i}}async handleServerTokenResponse(e,t,n,o,r,i,s,c,l){var v;(v=this.performanceClient)==null||v.addQueueMeasurement(h.HandleServerTokenResponse,e.correlation_id);let d;if(e.id_token){if(d=Ee(e.id_token||u.EMPTY_STRING,this.cryptoObj.base64Decode),r&&r.nonce&&d.nonce!==r.nonce)throw g(Ho);if(o.maxAge||o.maxAge===0){const y=d.auth_time;if(!y)throw g(an);Qo(y,o.maxAge)}}this.homeAccountIdentifier=U.generateHomeAccountId(e.client_info||u.EMPTY_STRING,t.authorityType,this.logger,this.cryptoObj,d);let m;r&&r.state&&(m=J.parseRequestState(this.cryptoObj,r.state)),e.key_id=e.key_id||o.sshKid||void 0;const f=this.generateCacheRecord(e,t,n,o,d,i,r);let T;try{if(this.persistencePlugin&&this.serializableCache&&(this.logger.verbose("Persistence enabled, calling beforeCacheAccess"),T=new ms(this.serializableCache,!0),await this.persistencePlugin.beforeCacheAccess(T)),s&&!c&&f.account){const y=f.account.generateAccountKey();if(!this.cacheStorage.getAccount(y,this.logger))return this.logger.warning("Account used to refresh tokens not in persistence, refreshed tokens will not be stored in the cache"),await Te.generateAuthenticationResult(this.cryptoObj,t,f,!1,o,d,m,void 0,l)}await this.cacheStorage.saveCacheRecord(f,o.storeInCache,o.correlationId)}finally{this.persistencePlugin&&this.serializableCache&&T&&(this.logger.verbose("Persistence enabled, calling afterCacheAccess"),await this.persistencePlugin.afterCacheAccess(T))}return Te.generateAuthenticationResult(this.cryptoObj,t,f,!1,o,d,m,e,l)}generateCacheRecord(e,t,n,o,r,i,s){const c=t.getPreferredCache();if(!c)throw g(cn);const l=hr(r);let d,m;e.id_token&&r&&(d=At(this.homeAccountIdentifier,c,e.id_token,this.clientId,l||""),m=Sn(this.cacheStorage,t,this.homeAccountIdentifier,this.cryptoObj.base64Decode,r,e.client_info,c,l,s,void 0,this.logger));let f=null;if(e.access_token){const y=e.scope?M.fromString(e.scope):new M(o.scopes||[]),_=(typeof e.expires_in=="string"?parseInt(e.expires_in,10):e.expires_in)||0,L=(typeof e.ext_expires_in=="string"?parseInt(e.ext_expires_in,10):e.ext_expires_in)||0,z=(typeof e.refresh_in=="string"?parseInt(e.refresh_in,10):e.refresh_in)||void 0,de=n+_,We=de+L,je=z&&z>0?n+z:void 0;f=It(this.homeAccountIdentifier,c,e.access_token,this.clientId,l||t.tenant||"",y.printScopes(),de,We,this.cryptoObj.base64Decode,je,e.token_type,i,e.key_id,o.claims,o.requestedClaimsHash)}let T=null;if(e.refresh_token){let y;if(e.refresh_token_expires_in){const _=typeof e.refresh_token_expires_in=="string"?parseInt(e.refresh_token_expires_in,10):e.refresh_token_expires_in;y=n+_}T=Wo(this.homeAccountIdentifier,c,e.refresh_token,this.clientId,e.foci,i,y)}let v=null;return e.foci&&(v={clientId:this.clientId,environment:c,familyId:e.foci}),{account:m,idToken:d,accessToken:f,refreshToken:T,appMetadata:v}}static async generateAuthenticationResult(e,t,n,o,r,i,s,c,l){var de,We,je,Gn,zn;let d=u.EMPTY_STRING,m=[],f=null,T,v,y=u.EMPTY_STRING;if(n.accessToken){if(n.accessToken.tokenType===R.POP&&!r.popKid){const mi=new Le(e),{secret:pi,keyId:qn}=n.accessToken;if(!qn)throw g(ln);d=await mi.signPopToken(pi,qn,r)}else d=n.accessToken.secret;m=M.fromString(n.accessToken.target).asArray(),f=new Date(Number(n.accessToken.expiresOn)*1e3),T=new Date(Number(n.accessToken.extendedExpiresOn)*1e3),n.accessToken.refreshOn&&(v=new Date(Number(n.accessToken.refreshOn)*1e3))}n.appMetadata&&(y=n.appMetadata.familyId===Fe?Fe:"");const _=(i==null?void 0:i.oid)||(i==null?void 0:i.sub)||"",L=(i==null?void 0:i.tid)||"";c!=null&&c.spa_accountid&&n.account&&(n.account.nativeAccountId=c==null?void 0:c.spa_accountid);const z=n.account?yn(n.account.getAccountInfo(),void 0,i,(de=n.idToken)==null?void 0:de.secret):null;return{authority:t.canonicalAuthority,uniqueId:_,tenantId:L,scopes:m,account:z,idToken:((We=n==null?void 0:n.idToken)==null?void 0:We.secret)||"",idTokenClaims:i||{},accessToken:d,fromCache:o,expiresOn:f,extExpiresOn:T,refreshOn:v,correlationId:r.correlationId,requestId:l||u.EMPTY_STRING,familyId:y,tokenType:((je=n.accessToken)==null?void 0:je.tokenType)||u.EMPTY_STRING,state:s?s.userRequestState:u.EMPTY_STRING,cloudGraphHostName:((Gn=n.account)==null?void 0:Gn.cloudGraphHostName)||u.EMPTY_STRING,msGraphHost:((zn=n.account)==null?void 0:zn.msGraphHost)||u.EMPTY_STRING,code:c==null?void 0:c.spa_code,fromNativeBroker:!1}}}function Sn(a,e,t,n,o,r,i,s,c,l,d){d==null||d.verbose("setCachedAccount called");const f=a.getAccountKeys().find(L=>L.startsWith(t));let T=null;f&&(T=a.getAccount(f,d));const v=T||U.createAccount({homeAccountId:t,idTokenClaims:o,clientInfo:r,environment:i,cloudGraphHostName:c==null?void 0:c.cloud_graph_host_name,msGraphHost:c==null?void 0:c.msgraph_host,nativeAccountId:l},e,n),y=v.tenantProfiles||[],_=s||v.realm;if(_&&!y.find(L=>L.tenantId===_)){const L=Cn(t,v.localAccountId,_,o);y.push(L)}return v.tenantProfiles=y,v}/*! @azure/msal-common v14.16.0 2024-11-05 */async function Ar(a,e,t){return typeof a=="string"?a:a({clientId:e,tokenEndpoint:t})}/*! @azure/msal-common v14.16.0 2024-11-05 */class Ir extends En{constructor(e,t){var n;super(e,t),this.includeRedirectUri=!0,this.oidcDefaultScopes=(n=this.config.authOptions.authority.options.OIDCOptions)==null?void 0:n.defaultScopes}async getAuthCodeUrl(e){var n;(n=this.performanceClient)==null||n.addQueueMeasurement(h.GetAuthCodeUrl,e.correlationId);const t=await p(this.createAuthCodeUrlQueryString.bind(this),h.AuthClientCreateQueryString,this.logger,this.performanceClient,e.correlationId)(e);return w.appendQueryString(this.authority.authorizationEndpoint,t)}async acquireToken(e,t){var s,c;if((s=this.performanceClient)==null||s.addQueueMeasurement(h.AuthClientAcquireToken,e.correlationId),!e.code)throw g(xo);const n=re(),o=await p(this.executeTokenRequest.bind(this),h.AuthClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(this.authority,e),r=(c=o.headers)==null?void 0:c[G.X_MS_REQUEST_ID],i=new Te(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin,this.performanceClient);return i.validateTokenResponse(o.body),p(i.handleServerTokenResponse.bind(i),h.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(o.body,this.authority,n,e,t,void 0,void 0,void 0,r)}handleFragmentResponse(e,t){if(new Te(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,null,null).validateServerAuthorizationCodeResponse(e,t),!e.code)throw g(qo);return e}getLogoutUri(e){if(!e)throw b(nr);const t=this.createLogoutUrlQueryString(e);return w.appendQueryString(this.authority.endSessionEndpoint,t)}async executeTokenRequest(e,t){var l,d;(l=this.performanceClient)==null||l.addQueueMeasurement(h.AuthClientExecuteTokenRequest,t.correlationId);const n=this.createTokenQueryParameters(t),o=w.appendQueryString(e.tokenEndpoint,n),r=await p(this.createTokenRequestBody.bind(this),h.AuthClientCreateTokenRequestBody,this.logger,this.performanceClient,t.correlationId)(t);let i;if(t.clientInfo)try{const m=dt(t.clientInfo,this.cryptoUtils.base64Decode);i={credential:`${m.uid}${B.CLIENT_INFO_SEPARATOR}${m.utid}`,type:Q.HOME_ACCOUNT_ID}}catch(m){this.logger.verbose("Could not parse client info for CCS Header: "+m)}const s=this.createTokenRequestHeaders(i||t.ccsCredential),c={clientId:((d=t.tokenBodyParameters)==null?void 0:d.clientId)||this.config.authOptions.clientId,authority:e.canonicalAuthority,scopes:t.scopes,claims:t.claims,authenticationScheme:t.authenticationScheme,resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,sshKid:t.sshKid};return p(this.executePostToTokenEndpoint.bind(this),h.AuthorizationCodeClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,t.correlationId)(o,r,s,c,t.correlationId,h.AuthorizationCodeClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){var o,r;(o=this.performanceClient)==null||o.addQueueMeasurement(h.AuthClientCreateTokenRequestBody,e.correlationId);const t=new ze(e.correlationId,this.performanceClient);if(t.addClientId(e.embeddedClientId||((r=e.tokenBodyParameters)==null?void 0:r[ye])||this.config.authOptions.clientId),this.includeRedirectUri?t.addRedirectUri(e.redirectUri):we.validateRedirectUri(e.redirectUri),t.addScopes(e.scopes,!0,this.oidcDefaultScopes),t.addAuthorizationCode(e.code),t.addLibraryInfo(this.config.libraryInfo),t.addApplicationTelemetry(this.config.telemetry.application),t.addThrottling(),this.serverTelemetryManager&&!zt(this.config)&&t.addServerTelemetry(this.serverTelemetryManager),e.codeVerifier&&t.addCodeVerifier(e.codeVerifier),this.config.clientCredentials.clientSecret&&t.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const i=this.config.clientCredentials.clientAssertion;t.addClientAssertion(await Ar(i.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),t.addClientAssertionType(i.assertionType)}if(t.addGrantType(Ro.AUTHORIZATION_CODE_GRANT),t.addClientInfo(),e.authenticationScheme===R.POP){const i=new Le(this.cryptoUtils,this.performanceClient);let s;e.popKid?s=this.cryptoUtils.encodeKid(e.popKid):s=(await p(i.generateCnf.bind(i),h.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString,t.addPopToken(s)}else if(e.authenticationScheme===R.SSH)if(e.sshJwk)t.addSshJwk(e.sshJwk);else throw b(Et);(!j.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&t.addClaims(e.claims,this.config.authOptions.clientCapabilities);let n;if(e.clientInfo)try{const i=dt(e.clientInfo,this.cryptoUtils.base64Decode);n={credential:`${i.uid}${B.CLIENT_INFO_SEPARATOR}${i.utid}`,type:Q.HOME_ACCOUNT_ID}}catch(i){this.logger.verbose("Could not parse client info for CCS Header: "+i)}else n=e.ccsCredential;if(this.config.systemOptions.preventCorsPreflight&&n)switch(n.type){case Q.HOME_ACCOUNT_ID:try{const i=be(n.credential);t.addCcsOid(i)}catch(i){this.logger.verbose("Could not parse home account ID for CCS Header: "+i)}break;case Q.UPN:t.addCcsUpn(n.credential);break}return e.embeddedClientId&&t.addBrokerParameters({brokerClientId:this.config.authOptions.clientId,brokerRedirectUri:this.config.authOptions.redirectUri}),e.tokenBodyParameters&&t.addExtraQueryParameters(e.tokenBodyParameters),e.enableSpaAuthorizationCode&&(!e.tokenBodyParameters||!e.tokenBodyParameters[uo])&&t.addExtraQueryParameters({[uo]:"1"}),t.createQueryString()}async createAuthCodeUrlQueryString(e){var r,i;const t=e.correlationId||this.config.cryptoInterface.createNewGuid();(r=this.performanceClient)==null||r.addQueueMeasurement(h.AuthClientCreateQueryString,t);const n=new ze(t,this.performanceClient);n.addClientId(e.embeddedClientId||((i=e.extraQueryParameters)==null?void 0:i[ye])||this.config.authOptions.clientId);const o=[...e.scopes||[],...e.extraScopesToConsent||[]];if(n.addScopes(o,!0,this.oidcDefaultScopes),n.addRedirectUri(e.redirectUri),n.addCorrelationId(t),n.addResponseMode(e.responseMode),n.addResponseTypeCode(),n.addLibraryInfo(this.config.libraryInfo),zt(this.config)||n.addApplicationTelemetry(this.config.telemetry.application),n.addClientInfo(),e.codeChallenge&&e.codeChallengeMethod&&n.addCodeChallengeParams(e.codeChallenge,e.codeChallengeMethod),e.prompt&&n.addPrompt(e.prompt),e.domainHint&&n.addDomainHint(e.domainHint),e.prompt!==D.SELECT_ACCOUNT)if(e.sid&&e.prompt===D.NONE)this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from request"),n.addSid(e.sid);else if(e.account){const s=this.extractAccountSid(e.account);let c=this.extractLoginHint(e.account);if(c&&e.domainHint&&(this.logger.warning('AuthorizationCodeClient.createAuthCodeUrlQueryString: "domainHint" param is set, skipping opaque "login_hint" claim. Please consider not passing domainHint'),c=null),c){this.logger.verbose("createAuthCodeUrlQueryString: login_hint claim present on account"),n.addLoginHint(c);try{const l=be(e.account.homeAccountId);n.addCcsOid(l)}catch{this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(s&&e.prompt===D.NONE){this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from account"),n.addSid(s);try{const l=be(e.account.homeAccountId);n.addCcsOid(l)}catch{this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(e.loginHint)this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from request"),n.addLoginHint(e.loginHint),n.addCcsUpn(e.loginHint);else if(e.account.username){this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from account"),n.addLoginHint(e.account.username);try{const l=be(e.account.homeAccountId);n.addCcsOid(l)}catch{this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}}else e.loginHint&&(this.logger.verbose("createAuthCodeUrlQueryString: No account, adding login_hint from request"),n.addLoginHint(e.loginHint),n.addCcsUpn(e.loginHint));else this.logger.verbose("createAuthCodeUrlQueryString: Prompt is select_account, ignoring account hints");if(e.nonce&&n.addNonce(e.nonce),e.state&&n.addState(e.state),(e.claims||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&n.addClaims(e.claims,this.config.authOptions.clientCapabilities),e.embeddedClientId&&n.addBrokerParameters({brokerClientId:this.config.authOptions.clientId,brokerRedirectUri:this.config.authOptions.redirectUri}),this.addExtraQueryParams(e,n),e.nativeBroker&&(n.addNativeBroker(),e.authenticationScheme===R.POP)){const s=new Le(this.cryptoUtils);let c;e.popKid?c=this.cryptoUtils.encodeKid(e.popKid):c=(await p(s.generateCnf.bind(s),h.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString,n.addPopToken(c)}return n.createQueryString()}createLogoutUrlQueryString(e){const t=new ze(e.correlationId,this.performanceClient);return e.postLogoutRedirectUri&&t.addPostLogoutRedirectUri(e.postLogoutRedirectUri),e.correlationId&&t.addCorrelationId(e.correlationId),e.idTokenHint&&t.addIdTokenHint(e.idTokenHint),e.state&&t.addState(e.state),e.logoutHint&&t.addLogoutHint(e.logoutHint),this.addExtraQueryParams(e,t),t.createQueryString()}addExtraQueryParams(e,t){!(e.extraQueryParameters&&e.extraQueryParameters.hasOwnProperty("instance_aware"))&&this.config.authOptions.instanceAware&&(e.extraQueryParameters=e.extraQueryParameters||{},e.extraQueryParameters.instance_aware="true"),e.extraQueryParameters&&t.addExtraQueryParameters(e.extraQueryParameters)}extractAccountSid(e){var t;return((t=e.idTokenClaims)==null?void 0:t.sid)||null}extractLoginHint(e){var t;return((t=e.idTokenClaims)==null?void 0:t.login_hint)||null}}/*! @azure/msal-common v14.16.0 2024-11-05 */const fs=300;class Yt extends En{constructor(e,t){super(e,t)}async acquireToken(e){var i,s;(i=this.performanceClient)==null||i.addQueueMeasurement(h.RefreshTokenClientAcquireToken,e.correlationId);const t=re(),n=await p(this.executeTokenRequest.bind(this),h.RefreshTokenClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(e,this.authority),o=(s=n.headers)==null?void 0:s[G.X_MS_REQUEST_ID],r=new Te(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin);return r.validateTokenResponse(n.body),p(r.handleServerTokenResponse.bind(r),h.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(n.body,this.authority,t,e,void 0,void 0,!0,e.forceCache,o)}async acquireTokenByRefreshToken(e){var n;if(!e)throw b(tr);if((n=this.performanceClient)==null||n.addQueueMeasurement(h.RefreshTokenClientAcquireTokenByRefreshToken,e.correlationId),!e.account)throw g(sn);if(this.cacheManager.isAppMetadataFOCI(e.account.environment))try{return await p(this.acquireTokenWithCachedRefreshToken.bind(this),h.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!0)}catch(o){const r=o instanceof X&&o.errorCode===pt,i=o instanceof fe&&o.errorCode===Jn.INVALID_GRANT_ERROR&&o.subError===Jn.CLIENT_MISMATCH_ERROR;if(r||i)return p(this.acquireTokenWithCachedRefreshToken.bind(this),h.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1);throw o}return p(this.acquireTokenWithCachedRefreshToken.bind(this),h.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1)}async acquireTokenWithCachedRefreshToken(e,t){var r;(r=this.performanceClient)==null||r.addQueueMeasurement(h.RefreshTokenClientAcquireTokenWithCachedRefreshToken,e.correlationId);const n=ve(this.cacheManager.getRefreshToken.bind(this.cacheManager),h.CacheManagerGetRefreshToken,this.logger,this.performanceClient,e.correlationId)(e.account,t,void 0,this.performanceClient,e.correlationId);if(!n)throw Vt(pt);if(n.expiresOn&&Gt(n.expiresOn,e.refreshTokenExpirationOffsetSeconds||fs))throw Vt(vn);const o={...e,refreshToken:n.secret,authenticationScheme:e.authenticationScheme||R.BEARER,ccsCredential:{credential:e.account.homeAccountId,type:Q.HOME_ACCOUNT_ID}};try{return await p(this.acquireToken.bind(this),h.RefreshTokenClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(o)}catch(i){if(i instanceof X&&i.subError===wt){this.logger.verbose("acquireTokenWithRefreshToken: bad refresh token, removing from cache");const s=Re(n);this.cacheManager.removeRefreshToken(s)}throw i}}async executeTokenRequest(e,t){var c,l;(c=this.performanceClient)==null||c.addQueueMeasurement(h.RefreshTokenClientExecuteTokenRequest,e.correlationId);const n=this.createTokenQueryParameters(e),o=w.appendQueryString(t.tokenEndpoint,n),r=await p(this.createTokenRequestBody.bind(this),h.RefreshTokenClientCreateTokenRequestBody,this.logger,this.performanceClient,e.correlationId)(e),i=this.createTokenRequestHeaders(e.ccsCredential),s={clientId:((l=e.tokenBodyParameters)==null?void 0:l.clientId)||this.config.authOptions.clientId,authority:t.canonicalAuthority,scopes:e.scopes,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid};return p(this.executePostToTokenEndpoint.bind(this),h.RefreshTokenClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,e.correlationId)(o,r,i,s,e.correlationId,h.RefreshTokenClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){var o,r,i;(o=this.performanceClient)==null||o.addQueueMeasurement(h.RefreshTokenClientCreateTokenRequestBody,e.correlationId);const t=e.correlationId,n=new ze(t,this.performanceClient);if(n.addClientId(e.embeddedClientId||((r=e.tokenBodyParameters)==null?void 0:r[ye])||this.config.authOptions.clientId),e.redirectUri&&n.addRedirectUri(e.redirectUri),n.addScopes(e.scopes,!0,(i=this.config.authOptions.authority.options.OIDCOptions)==null?void 0:i.defaultScopes),n.addGrantType(Ro.REFRESH_TOKEN_GRANT),n.addClientInfo(),n.addLibraryInfo(this.config.libraryInfo),n.addApplicationTelemetry(this.config.telemetry.application),n.addThrottling(),this.serverTelemetryManager&&!zt(this.config)&&n.addServerTelemetry(this.serverTelemetryManager),n.addRefreshToken(e.refreshToken),this.config.clientCredentials.clientSecret&&n.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const s=this.config.clientCredentials.clientAssertion;n.addClientAssertion(await Ar(s.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),n.addClientAssertionType(s.assertionType)}if(e.authenticationScheme===R.POP){const s=new Le(this.cryptoUtils,this.performanceClient);let c;e.popKid?c=this.cryptoUtils.encodeKid(e.popKid):c=(await p(s.generateCnf.bind(s),h.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString,n.addPopToken(c)}else if(e.authenticationScheme===R.SSH)if(e.sshJwk)n.addSshJwk(e.sshJwk);else throw b(Et);if((!j.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&n.addClaims(e.claims,this.config.authOptions.clientCapabilities),this.config.systemOptions.preventCorsPreflight&&e.ccsCredential)switch(e.ccsCredential.type){case Q.HOME_ACCOUNT_ID:try{const s=be(e.ccsCredential.credential);n.addCcsOid(s)}catch(s){this.logger.verbose("Could not parse home account ID for CCS Header: "+s)}break;case Q.UPN:n.addCcsUpn(e.ccsCredential.credential);break}return e.embeddedClientId&&n.addBrokerParameters({brokerClientId:this.config.authOptions.clientId,brokerRedirectUri:this.config.authOptions.redirectUri}),e.tokenBodyParameters&&n.addExtraQueryParameters(e.tokenBodyParameters),n.createQueryString()}}/*! @azure/msal-common v14.16.0 2024-11-05 */class Cs extends En{constructor(e,t){super(e,t)}async acquireToken(e){var t;try{const[n,o]=await this.acquireCachedToken({...e,scopes:(t=e.scopes)!=null&&t.length?e.scopes:[...De]});return o===ge.PROACTIVELY_REFRESHED&&(this.logger.info("SilentFlowClient:acquireCachedToken - Cached access token's refreshOn property has been exceeded'. It's not expired, but must be refreshed."),new Yt(this.config,this.performanceClient).acquireTokenByRefreshToken(e).catch(()=>{})),n}catch(n){if(n instanceof Tt&&n.errorCode===se)return new Yt(this.config,this.performanceClient).acquireTokenByRefreshToken(e);throw n}}async acquireCachedToken(e){var c;(c=this.performanceClient)==null||c.addQueueMeasurement(h.SilentFlowClientAcquireCachedToken,e.correlationId);let t=ge.NOT_APPLICABLE;if(e.forceRefresh||!this.config.cacheOptions.claimsBasedCachingEnabled&&!j.isEmptyObj(e.claims))throw this.setCacheOutcome(ge.FORCE_REFRESH_OR_CLAIMS,e.correlationId),g(se);if(!e.account)throw g(sn);const n=e.account.tenantId||as(e.authority),o=this.cacheManager.getTokenKeys(),r=this.cacheManager.getAccessToken(e.account,e,o,n,this.performanceClient,e.correlationId);if(r){if(Yi(r.cachedAt)||Gt(r.expiresOn,this.config.systemOptions.tokenRenewalOffsetSeconds))throw this.setCacheOutcome(ge.CACHED_ACCESS_TOKEN_EXPIRED,e.correlationId),g(se);r.refreshOn&&Gt(r.refreshOn,0)&&(t=ge.PROACTIVELY_REFRESHED)}else throw this.setCacheOutcome(ge.NO_CACHED_ACCESS_TOKEN,e.correlationId),g(se);const i=e.authority||this.authority.getPreferredCache(),s={account:this.cacheManager.readAccountFromCache(e.account),accessToken:r,idToken:this.cacheManager.getIdToken(e.account,o,n,this.performanceClient,e.correlationId),refreshToken:null,appMetadata:this.cacheManager.readAppMetadataFromCache(i)};return this.setCacheOutcome(t,e.correlationId),this.config.serverTelemetryManager&&this.config.serverTelemetryManager.incrementCacheHits(),[await p(this.generateResultFromCacheRecord.bind(this),h.SilentFlowClientGenerateResultFromCacheRecord,this.logger,this.performanceClient,e.correlationId)(s,e),t]}setCacheOutcome(e,t){var n,o;(n=this.serverTelemetryManager)==null||n.setCacheOutcome(e),(o=this.performanceClient)==null||o.addFields({cacheOutcome:e},t),e!==ge.NOT_APPLICABLE&&this.logger.info(`Token refresh is required due to cache outcome: ${e}`)}async generateResultFromCacheRecord(e,t){var o;(o=this.performanceClient)==null||o.addQueueMeasurement(h.SilentFlowClientGenerateResultFromCacheRecord,t.correlationId);let n;if(e.idToken&&(n=Ee(e.idToken.secret,this.config.cryptoInterface.base64Decode)),t.maxAge||t.maxAge===0){const r=n==null?void 0:n.auth_time;if(!r)throw g(an);Qo(r,t.maxAge)}return Te.generateAuthenticationResult(this.cryptoUtils,this.authority,e,!0,t,n)}}/*! @azure/msal-common v14.16.0 2024-11-05 */const ys={sendGetRequestAsync:()=>Promise.reject(g(S)),sendPostRequestAsync:()=>Promise.reject(g(S))};/*! @azure/msal-common v14.16.0 2024-11-05 */const fo=",",Er="|";function Ts(a){const{skus:e,libraryName:t,libraryVersion:n,extensionName:o,extensionVersion:r}=a,i=new Map([[0,[t,n]],[2,[o,r]]]);let s=[];if(e!=null&&e.length){if(s=e.split(fo),s.length<4)return e}else s=Array.from({length:4},()=>Er);return i.forEach((c,l)=>{var d,m;c.length===2&&((d=c[0])!=null&&d.length)&&((m=c[1])!=null&&m.length)&&As({skuArr:s,index:l,skuName:c[0],skuVersion:c[1]})}),s.join(fo)}function As(a){const{skuArr:e,index:t,skuName:n,skuVersion:o}=a;t>=e.length||(e[t]=[n,o].join(Er))}class qe{constructor(e,t){this.cacheOutcome=ge.NOT_APPLICABLE,this.cacheManager=t,this.apiId=e.apiId,this.correlationId=e.correlationId,this.wrapperSKU=e.wrapperSKU||u.EMPTY_STRING,this.wrapperVer=e.wrapperVer||u.EMPTY_STRING,this.telemetryCacheKey=K.CACHE_KEY+B.CACHE_KEY_SEPARATOR+e.clientId}generateCurrentRequestHeaderValue(){const e=`${this.apiId}${K.VALUE_SEPARATOR}${this.cacheOutcome}`,t=[this.wrapperSKU,this.wrapperVer],n=this.getNativeBrokerErrorCode();n!=null&&n.length&&t.push(`broker_error=${n}`);const o=t.join(K.VALUE_SEPARATOR),r=this.getRegionDiscoveryFields(),i=[e,r].join(K.VALUE_SEPARATOR);return[K.SCHEMA_VERSION,i,o].join(K.CATEGORY_SEPARATOR)}generateLastRequestHeaderValue(){const e=this.getLastRequests(),t=qe.maxErrorsToSend(e),n=e.failedRequests.slice(0,2*t).join(K.VALUE_SEPARATOR),o=e.errors.slice(0,t).join(K.VALUE_SEPARATOR),r=e.errors.length,i=t<r?K.OVERFLOW_TRUE:K.OVERFLOW_FALSE,s=[r,i].join(K.VALUE_SEPARATOR);return[K.SCHEMA_VERSION,e.cacheHits,n,o,s].join(K.CATEGORY_SEPARATOR)}cacheFailedRequest(e){const t=this.getLastRequests();t.errors.length>=K.MAX_CACHED_ERRORS&&(t.failedRequests.shift(),t.failedRequests.shift(),t.errors.shift()),t.failedRequests.push(this.apiId,this.correlationId),e instanceof Error&&e&&e.toString()?e instanceof P?e.subError?t.errors.push(e.subError):e.errorCode?t.errors.push(e.errorCode):t.errors.push(e.toString()):t.errors.push(e.toString()):t.errors.push(K.UNKNOWN_ERROR),this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t)}incrementCacheHits(){const e=this.getLastRequests();return e.cacheHits+=1,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e),e.cacheHits}getLastRequests(){const e={failedRequests:[],errors:[],cacheHits:0};return this.cacheManager.getServerTelemetry(this.telemetryCacheKey)||e}clearTelemetryCache(){const e=this.getLastRequests(),t=qe.maxErrorsToSend(e),n=e.errors.length;if(t===n)this.cacheManager.removeItem(this.telemetryCacheKey);else{const o={failedRequests:e.failedRequests.slice(t*2),errors:e.errors.slice(t),cacheHits:0};this.cacheManager.setServerTelemetry(this.telemetryCacheKey,o)}}static maxErrorsToSend(e){let t,n=0,o=0;const r=e.errors.length;for(t=0;t<r;t++){const i=e.failedRequests[2*t]||u.EMPTY_STRING,s=e.failedRequests[2*t+1]||u.EMPTY_STRING,c=e.errors[t]||u.EMPTY_STRING;if(o+=i.toString().length+s.toString().length+c.length+3,o<K.MAX_LAST_HEADER_BYTES)n+=1;else break}return n}getRegionDiscoveryFields(){const e=[];return e.push(this.regionUsed||u.EMPTY_STRING),e.push(this.regionSource||u.EMPTY_STRING),e.push(this.regionOutcome||u.EMPTY_STRING),e.join(",")}updateRegionDiscoveryMetadata(e){this.regionUsed=e.region_used,this.regionSource=e.region_source,this.regionOutcome=e.region_outcome}setCacheOutcome(e){this.cacheOutcome=e}setNativeBrokerErrorCode(e){const t=this.getLastRequests();t.nativeBrokerErrorCode=e,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t)}getNativeBrokerErrorCode(){return this.getLastRequests().nativeBrokerErrorCode}clearNativeBrokerErrorCode(){const e=this.getLastRequests();delete e.nativeBrokerErrorCode,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e)}static makeExtraSkuString(e){return Ts(e)}}/*! @azure/msal-common v14.16.0 2024-11-05 */const vr="missing_kid_error",Sr="missing_alg_error";/*! @azure/msal-common v14.16.0 2024-11-05 */const Is={[vr]:"The JOSE Header for the requested JWT, JWS or JWK object requires a keyId to be configured as the 'kid' header claim. No 'kid' value was provided.",[Sr]:"The JOSE Header for the requested JWT, JWS or JWK object requires an algorithm to be specified as the 'alg' header claim. No 'alg' value was provided."};class wn extends P{constructor(e,t){super(e,t),this.name="JoseHeaderError",Object.setPrototypeOf(this,wn.prototype)}}function Co(a){return new wn(a,Is[a])}/*! @azure/msal-common v14.16.0 2024-11-05 */class _n{constructor(e){this.typ=e.typ,this.alg=e.alg,this.kid=e.kid}static getShrHeaderString(e){if(!e.kid)throw Co(vr);if(!e.alg)throw Co(Sr);const t=new _n({typ:e.typ||Oi.Pop,kid:e.kid,alg:e.alg});return JSON.stringify(t)}}/*! @azure/msal-common v14.16.0 2024-11-05 */class yo{startMeasurement(){}endMeasurement(){}flushMeasurement(){return null}}class Es{generateId(){return"callback-id"}startMeasurement(e,t){return{end:()=>null,discard:()=>{},add:()=>{},increment:()=>{},event:{eventId:this.generateId(),status:is.InProgress,authority:"",libraryName:"",libraryVersion:"",clientId:"",name:e,startTimeMs:Date.now(),correlationId:t||""},measurement:new yo}}startPerformanceMeasurement(){return new yo}calculateQueuedTime(){return 0}addQueueMeasurement(){}setPreQueueTime(){}endMeasurement(){return null}discardMeasurements(){}removePerformanceCallback(){return!0}addPerformanceCallback(){return""}emitEvents(){}addFields(){}incrementFields(){}cacheEventByCorrelationId(){}}/*! @azure/msal-browser v3.28.0 2024-12-12 */const kn="pkce_not_created",$t="crypto_nonexistent",_t="empty_navigate_uri",wr="hash_empty_error",Rn="no_state_in_hash",_r="hash_does_not_contain_known_properties",kr="unable_to_parse_state",Rr="state_interaction_type_mismatch",br="interaction_in_progress",Or="popup_window_error",Nr="empty_window_error",Ae="user_cancelled",vs="monitor_popup_timeout",Pr="monitor_window_timeout",Mr="redirect_in_iframe",Ur="block_iframe_reload",Lr="block_nested_popups",Ss="iframe_closed_prematurely",kt="silent_logout_unsupported",Hr="no_account_error",ws="silent_prompt_value_error",Dr="no_token_request_cache_error",Kr="unable_to_parse_token_request_cache_error",bn="no_cached_authority_error",_s="auth_request_not_set_error",ks="invalid_cache_type",Rt="non_browser_environment",_e="database_not_open",ft="no_network_connectivity",xr="post_request_failed",Br="get_request_failed",Qt="failed_to_parse_response",Fr="unable_to_load_token",On="crypto_key_not_found",Gr="auth_code_required",zr="auth_code_or_nativeAccountId_required",qr="spa_code_and_nativeAccountId_present",Nn="database_unavailable",Vr="unable_to_acquire_token_from_native_platform",Yr="native_handshake_timeout",$r="native_extension_not_installed",$e="native_connection_not_established",Qr="uninitialized_public_client_application",Wr="native_prompt_not_supported",jr="invalid_base64_string",Jr="invalid_pop_token_request",Xr="failed_to_build_headers",Zr="failed_to_parse_headers";/*! @azure/msal-browser v3.28.0 2024-12-12 */const ie="For more visit: aka.ms/msaljs/browser-errors",Rs={[kn]:"The PKCE code challenge and verifier could not be generated.",[$t]:"The crypto object or function is not available.",[_t]:"Navigation URI is empty. Please check stack trace for more info.",[wr]:`Hash value cannot be processed because it is empty. Please verify that your redirectUri is not clearing the hash. ${ie}`,[Rn]:"Hash does not contain state. Please verify that the request originated from msal.",[_r]:`Hash does not contain known properites. Please verify that your redirectUri is not changing the hash.  ${ie}`,[kr]:"Unable to parse state. Please verify that the request originated from msal.",[Rr]:"Hash contains state but the interaction type does not match the caller.",[br]:`Interaction is currently in progress. Please ensure that this interaction has been completed before calling an interactive API.   ${ie}`,[Or]:"Error opening popup window. This can happen if you are using IE or if popups are blocked in the browser.",[Nr]:"window.open returned null or undefined window object.",[Ae]:"User cancelled the flow.",[vs]:`Token acquisition in popup failed due to timeout.  ${ie}`,[Pr]:`Token acquisition in iframe failed due to timeout.  ${ie}`,[Mr]:"Redirects are not supported for iframed or brokered applications. Please ensure you are using MSAL.js in a top frame of the window if using the redirect APIs, or use the popup APIs.",[Ur]:`Request was blocked inside an iframe because MSAL detected an authentication response.  ${ie}`,[Lr]:"Request was blocked inside a popup because MSAL detected it was running in a popup.",[Ss]:"The iframe being monitored was closed prematurely.",[kt]:"Silent logout not supported. Please call logoutRedirect or logoutPopup instead.",[Hr]:"No account object provided to acquireTokenSilent and no active account has been set. Please call setActiveAccount or provide an account on the request.",[ws]:"The value given for the prompt value is not valid for silent requests - must be set to 'none' or 'no_session'.",[Dr]:"No token request found in cache.",[Kr]:"The cached token request could not be parsed.",[bn]:"No cached authority found.",[_s]:"Auth Request not set. Please ensure initiateAuthRequest was called from the InteractionHandler",[ks]:"Invalid cache type",[Rt]:"Login and token requests are not supported in non-browser environments.",[_e]:"Database is not open!",[ft]:"No network connectivity. Check your internet connection.",[xr]:"Network request failed: If the browser threw a CORS error, check that the redirectUri is registered in the Azure App Portal as type 'SPA'",[Br]:"Network request failed. Please check the network trace to determine root cause.",[Qt]:"Failed to parse network response. Check network trace.",[Fr]:"Error loading token to cache.",[On]:"Cryptographic Key or Keypair not found in browser storage.",[Gr]:"An authorization code must be provided (as the `code` property on the request) to this flow.",[zr]:"An authorization code or nativeAccountId must be provided to this flow.",[qr]:"Request cannot contain both spa code and native account id.",[Nn]:"IndexedDB, which is required for persistent cryptographic key storage, is unavailable. This may be caused by browser privacy features which block persistent storage in third-party contexts.",[Vr]:`Unable to acquire token from native platform.  ${ie}`,[Yr]:"Timed out while attempting to establish connection to browser extension",[$r]:"Native extension is not installed. If you think this is a mistake call the initialize function.",[$e]:`Connection to native platform has not been established. Please install a compatible browser extension and run initialize().  ${ie}`,[Qr]:`You must call and await the initialize function before attempting to call any other MSAL API.  ${ie}`,[Wr]:"The provided prompt is not supported by the native platform. This request should be routed to the web based flow.",[jr]:"Invalid base64 encoded string.",[Jr]:"Invalid PoP token request. The request should not have both a popKid value and signPopToken set to true.",[Xr]:"Failed to build request headers object.",[Zr]:"Failed to parse response headers"};class Qe extends P{constructor(e,t){super(e,Rs[e],t),Object.setPrototypeOf(this,Qe.prototype),this.name="BrowserAuthError"}}function C(a,e){return new Qe(a,e)}/*! @azure/msal-browser v3.28.0 2024-12-12 */const $={INTERACTION_IN_PROGRESS_VALUE:"interaction_in_progress",INVALID_GRANT_ERROR:"invalid_grant",POPUP_WIDTH:483,POPUP_HEIGHT:600,POPUP_NAME_PREFIX:"msal",DEFAULT_POLL_INTERVAL_MS:30,MSAL_SKU:"msal.js.browser"},Oe={CHANNEL_ID:"53ee284d-920a-4b59-9d30-a60315b26836",PREFERRED_EXTENSION_ID:"ppnbnpeolgkicgegkbkbjmhlideopiji",MATS_TELEMETRY:"MATS"},Ce={HandshakeRequest:"Handshake",HandshakeResponse:"HandshakeResponse",GetToken:"GetToken",Response:"Response"},q={LocalStorage:"localStorage",SessionStorage:"sessionStorage",MemoryStorage:"memoryStorage"},To={GET:"GET",POST:"POST"},k={AUTHORITY:"authority",ACQUIRE_TOKEN_ACCOUNT:"acquireToken.account",SESSION_STATE:"session.state",REQUEST_STATE:"request.state",NONCE_IDTOKEN:"nonce.id_token",ORIGIN_URI:"request.origin",RENEW_STATUS:"token.renew.status",URL_HASH:"urlHash",REQUEST_PARAMS:"request.params",SCOPES:"scopes",INTERACTION_STATUS_KEY:"interaction.status",CCS_CREDENTIAL:"ccs.credential",CORRELATION_ID:"request.correlationId",NATIVE_REQUEST:"request.native",REDIRECT_CONTEXT:"request.redirect.context"},ue={ACCOUNT_KEYS:"msal.account.keys",TOKEN_KEYS:"msal.token.keys"},rt={WRAPPER_SKU:"wrapper.sku",WRAPPER_VER:"wrapper.version"},O={acquireTokenRedirect:861,acquireTokenPopup:862,ssoSilent:863,acquireTokenSilent_authCode:864,handleRedirectPromise:865,acquireTokenByCode:866,acquireTokenSilent_silentFlow:61,logout:961,logoutPopup:962};var A;(function(a){a.Redirect="redirect",a.Popup="popup",a.Silent="silent",a.None="none"})(A||(A={}));const Ao={scopes:De},ei="jwk",Wt="msal.db",bs=1,Os=`${Wt}.keys`,Y={Default:0,AccessToken:1,AccessTokenAndRefreshToken:2,RefreshToken:3,RefreshTokenAndNetwork:4,Skip:5},Ns=[Y.Default,Y.Skip,Y.RefreshTokenAndNetwork],Ps="msal.browser.log.level",Ms="msal.browser.log.pii";/*! @azure/msal-browser v3.28.0 2024-12-12 */function it(a){return encodeURIComponent(Pn(a).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_"))}function bt(a){return ti(a).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}function Pn(a){return ti(new TextEncoder().encode(a))}function ti(a){const e=Array.from(a,t=>String.fromCodePoint(t)).join("");return btoa(e)}/*! @azure/msal-browser v3.28.0 2024-12-12 */const Us="RSASSA-PKCS1-v1_5",ni="SHA-256",Ls=2048,Hs=new Uint8Array([1,0,1]),Io="0123456789abcdef",Eo=new Uint32Array(1),Ds="crypto_subtle_undefined",Mn={name:Us,hash:ni,modulusLength:Ls,publicExponent:Hs};function Ks(){if(!window)throw C(Rt);if(!window.crypto)throw C($t);if(!window.crypto.subtle)throw C($t,Ds)}async function oi(a,e,t){e==null||e.addQueueMeasurement(h.Sha256Digest,t);const o=new TextEncoder().encode(a);return window.crypto.subtle.digest(ni,o)}function xs(a){return window.crypto.getRandomValues(a)}function Ht(){return window.crypto.getRandomValues(Eo),Eo[0]}function he(){const a=Date.now(),e=Ht()*1024+(Ht()&1023),t=new Uint8Array(16),n=Math.trunc(e/2**30),o=e&2**30-1,r=Ht();t[0]=a/2**40,t[1]=a/2**32,t[2]=a/2**24,t[3]=a/2**16,t[4]=a/2**8,t[5]=a,t[6]=112|n>>>8,t[7]=n,t[8]=128|o>>>24,t[9]=o>>>16,t[10]=o>>>8,t[11]=o,t[12]=r>>>24,t[13]=r>>>16,t[14]=r>>>8,t[15]=r;let i="";for(let s=0;s<t.length;s++)i+=Io.charAt(t[s]>>>4),i+=Io.charAt(t[s]&15),(s===3||s===5||s===7||s===9)&&(i+="-");return i}async function Bs(a,e){return window.crypto.subtle.generateKey(Mn,a,e)}async function Dt(a){return window.crypto.subtle.exportKey(ei,a)}async function Fs(a,e,t){return window.crypto.subtle.importKey(ei,a,Mn,e,t)}async function Gs(a,e){return window.crypto.subtle.sign(Mn,a,e)}async function ri(a){const e=await oi(a),t=new Uint8Array(e);return bt(t)}/*! @azure/msal-browser v3.28.0 2024-12-12 */const Ve="storage_not_supported",jt="stubbed_public_client_application_called",Ct="in_mem_redirect_unavailable";/*! @azure/msal-browser v3.28.0 2024-12-12 */const st={[Ve]:"Given storage configuration option was not supported.",[jt]:"Stub instance of Public Client Application was called. If using msal-react, please ensure context is not used without a provider. For more visit: aka.ms/msaljs/browser-errors",[Ct]:"Redirect cannot be supported. In-memory storage was selected and storeAuthStateInCookie=false, which would cause the library to be unable to handle the incoming hash. If you would like to use the redirect API, please use session/localStorage or set storeAuthStateInCookie=true."};st[Ve],st[jt],st[Ct];class Un extends P{constructor(e,t){super(e,t),this.name="BrowserConfigurationAuthError",Object.setPrototypeOf(this,Un.prototype)}}function Ln(a){return new Un(a,st[a])}/*! @azure/msal-browser v3.28.0 2024-12-12 */function zs(a){a.location.hash="",typeof a.history.replaceState=="function"&&a.history.replaceState(null,"",`${a.location.origin}${a.location.pathname}${a.location.search}`)}function qs(a){const e=a.split("#");e.shift(),window.location.hash=e.length>0?e.join("#"):""}function Hn(){return window.parent!==window}function Vs(){return typeof window<"u"&&!!window.opener&&window.opener!==window&&typeof window.name=="string"&&window.name.indexOf(`${$.POPUP_NAME_PREFIX}.`)===0}function ce(){return window.location.href.split("?")[0].split("#")[0]}function Ys(){const e=new w(window.location.href).getUrlComponents();return`${e.Protocol}//${e.HostNameAndPort}/`}function $s(){if(w.hashContainsKnownProperties(window.location.hash)&&Hn())throw C(Ur)}function Qs(a){if(Hn()&&!a)throw C(Mr)}function Ws(){if(Vs())throw C(Lr)}function ii(){if(typeof window>"u")throw C(Rt)}function ai(a){if(!a)throw C(Qr)}function Dn(a){ii(),$s(),Ws(),ai(a)}function vo(a,e){if(Dn(a),Qs(e.system.allowRedirectInIframe),e.cache.cacheLocation===q.MemoryStorage&&!e.cache.storeAuthStateInCookie)throw Ln(Ct)}function si(a){const e=document.createElement("link");e.rel="preconnect",e.href=new URL(a).origin,e.crossOrigin="anonymous",document.head.appendChild(e),window.setTimeout(()=>{try{document.head.removeChild(e)}catch{}},1e4)}function js(){return he()}/*! @azure/msal-browser v3.28.0 2024-12-12 */class yt{navigateInternal(e,t){return yt.defaultNavigateWindow(e,t)}navigateExternal(e,t){return yt.defaultNavigateWindow(e,t)}static defaultNavigateWindow(e,t){return t.noHistory?window.location.replace(e):window.location.assign(e),new Promise(n=>{setTimeout(()=>{n(!0)},t.timeout)})}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Js{async sendGetRequestAsync(e,t){let n,o={},r=0;const i=So(t);try{n=await fetch(e,{method:To.GET,headers:i})}catch{throw C(window.navigator.onLine?Br:ft)}o=wo(n.headers);try{return r=n.status,{headers:o,body:await n.json(),status:r}}catch{throw go(C(Qt),r,o)}}async sendPostRequestAsync(e,t){const n=t&&t.body||"",o=So(t);let r,i=0,s={};try{r=await fetch(e,{method:To.POST,headers:o,body:n})}catch{throw C(window.navigator.onLine?xr:ft)}s=wo(r.headers);try{return i=r.status,{headers:s,body:await r.json(),status:i}}catch{throw go(C(Qt),i,s)}}}function So(a){try{const e=new Headers;if(!(a&&a.headers))return e;const t=a.headers;return Object.entries(t).forEach(([n,o])=>{e.append(n,o)}),e}catch{throw C(Xr)}}function wo(a){try{const e={};return a.forEach((t,n)=>{e[n]=t}),e}catch{throw C(Zr)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */const Xs=6e4,Jt=1e4,Zs=3e4,ec=2e3;function tc({auth:a,cache:e,system:t,telemetry:n},o){const r={clientId:u.EMPTY_STRING,authority:`${u.DEFAULT_AUTHORITY}`,knownAuthorities:[],cloudDiscoveryMetadata:u.EMPTY_STRING,authorityMetadata:u.EMPTY_STRING,redirectUri:typeof window<"u"?ce():"",postLogoutRedirectUri:u.EMPTY_STRING,navigateToLoginRequestUrl:!0,clientCapabilities:[],protocolMode:le.AAD,OIDCOptions:{serverResponseType:Ye.FRAGMENT,defaultScopes:[u.OPENID_SCOPE,u.PROFILE_SCOPE,u.OFFLINE_ACCESS_SCOPE]},azureCloudOptions:{azureCloudInstance:dn.None,tenant:u.EMPTY_STRING},skipAuthorityMetadataCache:!1,supportsNestedAppAuth:!1,instanceAware:!1},i={cacheLocation:q.SessionStorage,temporaryCacheLocation:q.SessionStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!!(e&&e.cacheLocation===q.LocalStorage),claimsBasedCachingEnabled:!1},s={loggerCallback:()=>{},logLevel:N.Info,piiLoggingEnabled:!1},l={...{...pr,loggerOptions:s,networkClient:o?new Js:ys,navigationClient:new yt,loadFrameTimeout:0,windowHashTimeout:(t==null?void 0:t.loadFrameTimeout)||Xs,iframeHashTimeout:(t==null?void 0:t.loadFrameTimeout)||Jt,navigateFrameWait:0,redirectNavigationTimeout:Zs,asyncPopups:!1,allowRedirectInIframe:!1,allowNativeBroker:!1,nativeBrokerHandshakeTimeout:(t==null?void 0:t.nativeBrokerHandshakeTimeout)||ec,pollIntervalMilliseconds:$.DEFAULT_POLL_INTERVAL_MS},...t,loggerOptions:(t==null?void 0:t.loggerOptions)||s},d={application:{appName:u.EMPTY_STRING,appVersion:u.EMPTY_STRING},client:new Es};if((a==null?void 0:a.protocolMode)!==le.OIDC&&(a!=null&&a.OIDCOptions)&&new pe(l.loggerOptions).warning(JSON.stringify(b(sr))),a!=null&&a.protocolMode&&a.protocolMode!==le.AAD&&(l!=null&&l.allowNativeBroker))throw b(cr);return{auth:{...r,...a,OIDCOptions:{...r.OIDCOptions,...a==null?void 0:a.OIDCOptions}},cache:{...i,...e},system:l,telemetry:{...d,...n}}}/*! @azure/msal-browser v3.28.0 2024-12-12 */const nc="@azure/msal-browser",Ot="3.28.0";/*! @azure/msal-browser v3.28.0 2024-12-12 */class Kn{static loggerCallback(e,t){switch(e){case N.Error:console.error(t);return;case N.Info:console.info(t);return;case N.Verbose:console.debug(t);return;case N.Warning:console.warn(t);return;default:console.log(t);return}}constructor(e){var c;this.browserEnvironment=typeof window<"u",this.config=tc(e,this.browserEnvironment);let t;try{t=window[q.SessionStorage]}catch{}const n=t==null?void 0:t.getItem(Ps),o=(c=t==null?void 0:t.getItem(Ms))==null?void 0:c.toLowerCase(),r=o==="true"?!0:o==="false"?!1:void 0,i={...this.config.system.loggerOptions},s=n&&Object.keys(N).includes(n)?N[n]:void 0;s&&(i.loggerCallback=Kn.loggerCallback,i.logLevel=s),r!==void 0&&(i.piiLoggingEnabled=r),this.logger=new pe(i,nc,Ot),this.available=!1}getConfig(){return this.config}getLogger(){return this.logger}isAvailable(){return this.available}isBrowserEnvironment(){return this.browserEnvironment}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Ie extends Kn{getModuleName(){return Ie.MODULE_NAME}getId(){return Ie.ID}async initialize(){return this.available=typeof window<"u",this.available}}Ie.MODULE_NAME="";Ie.ID="StandardOperatingContext";/*! @azure/msal-browser v3.28.0 2024-12-12 */function oe(a){return new TextDecoder().decode(oc(a))}function oc(a){let e=a.replace(/-/g,"+").replace(/_/g,"/");switch(e.length%4){case 0:break;case 2:e+="==";break;case 3:e+="=";break;default:throw C(jr)}const t=atob(e);return Uint8Array.from(t,n=>n.codePointAt(0)||0)}/*! @azure/msal-browser v3.28.0 2024-12-12 */class rc{constructor(){this.dbName=Wt,this.version=bs,this.tableName=Os,this.dbOpen=!1}async open(){return new Promise((e,t)=>{const n=window.indexedDB.open(this.dbName,this.version);n.addEventListener("upgradeneeded",o=>{o.target.result.createObjectStore(this.tableName)}),n.addEventListener("success",o=>{const r=o;this.db=r.target.result,this.dbOpen=!0,e()}),n.addEventListener("error",()=>t(C(Nn)))})}closeConnection(){const e=this.db;e&&this.dbOpen&&(e.close(),this.dbOpen=!1)}async validateDbIsOpen(){if(!this.dbOpen)return this.open()}async getItem(e){return await this.validateDbIsOpen(),new Promise((t,n)=>{if(!this.db)return n(C(_e));const i=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).get(e);i.addEventListener("success",s=>{const c=s;this.closeConnection(),t(c.target.result)}),i.addEventListener("error",s=>{this.closeConnection(),n(s)})})}async setItem(e,t){return await this.validateDbIsOpen(),new Promise((n,o)=>{if(!this.db)return o(C(_e));const s=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).put(t,e);s.addEventListener("success",()=>{this.closeConnection(),n()}),s.addEventListener("error",c=>{this.closeConnection(),o(c)})})}async removeItem(e){return await this.validateDbIsOpen(),new Promise((t,n)=>{if(!this.db)return n(C(_e));const i=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).delete(e);i.addEventListener("success",()=>{this.closeConnection(),t()}),i.addEventListener("error",s=>{this.closeConnection(),n(s)})})}async getKeys(){return await this.validateDbIsOpen(),new Promise((e,t)=>{if(!this.db)return t(C(_e));const r=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).getAllKeys();r.addEventListener("success",i=>{const s=i;this.closeConnection(),e(s.target.result)}),r.addEventListener("error",i=>{this.closeConnection(),t(i)})})}async containsKey(e){return await this.validateDbIsOpen(),new Promise((t,n)=>{if(!this.db)return n(C(_e));const i=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).count(e);i.addEventListener("success",s=>{const c=s;this.closeConnection(),t(c.target.result===1)}),i.addEventListener("error",s=>{this.closeConnection(),n(s)})})}async deleteDatabase(){return this.db&&this.dbOpen&&this.closeConnection(),new Promise((e,t)=>{const n=window.indexedDB.deleteDatabase(Wt),o=setTimeout(()=>t(!1),200);n.addEventListener("success",()=>(clearTimeout(o),e(!0))),n.addEventListener("blocked",()=>(clearTimeout(o),e(!0))),n.addEventListener("error",()=>(clearTimeout(o),t(!1)))})}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Xt{constructor(){this.cache=new Map}getItem(e){return this.cache.get(e)||null}setItem(e,t){this.cache.set(e,t)}removeItem(e){this.cache.delete(e)}getKeys(){const e=[];return this.cache.forEach((t,n)=>{e.push(n)}),e}containsKey(e){return this.cache.has(e)}clear(){this.cache.clear()}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class ic{constructor(e){this.inMemoryCache=new Xt,this.indexedDBCache=new rc,this.logger=e}handleDatabaseAccessError(e){if(e instanceof Qe&&e.errorCode===Nn)this.logger.error("Could not access persistent storage. This may be caused by browser privacy features which block persistent storage in third-party contexts.");else throw e}async getItem(e){const t=this.inMemoryCache.getItem(e);if(!t)try{return this.logger.verbose("Queried item not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.getItem(e)}catch(n){this.handleDatabaseAccessError(n)}return t}async setItem(e,t){this.inMemoryCache.setItem(e,t);try{await this.indexedDBCache.setItem(e,t)}catch(n){this.handleDatabaseAccessError(n)}}async removeItem(e){this.inMemoryCache.removeItem(e);try{await this.indexedDBCache.removeItem(e)}catch(t){this.handleDatabaseAccessError(t)}}async getKeys(){const e=this.inMemoryCache.getKeys();if(e.length===0)try{return this.logger.verbose("In-memory cache is empty, now querying persistent storage."),await this.indexedDBCache.getKeys()}catch(t){this.handleDatabaseAccessError(t)}return e}async containsKey(e){const t=this.inMemoryCache.containsKey(e);if(!t)try{return this.logger.verbose("Key not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.containsKey(e)}catch(n){this.handleDatabaseAccessError(n)}return t}clearInMemory(){this.logger.verbose("Deleting in-memory keystore"),this.inMemoryCache.clear(),this.logger.verbose("In-memory keystore deleted")}async clearPersistent(){try{this.logger.verbose("Deleting persistent keystore");const e=await this.indexedDBCache.deleteDatabase();return e&&this.logger.verbose("Persistent keystore deleted"),e}catch(e){return this.handleDatabaseAccessError(e),!1}}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class He{constructor(e,t){this.logger=e,Ks(),this.cache=new ic(this.logger),this.performanceClient=t}createNewGuid(){return he()}base64Encode(e){return Pn(e)}base64Decode(e){return oe(e)}base64UrlEncode(e){return it(e)}encodeKid(e){return this.base64UrlEncode(JSON.stringify({kid:e}))}async getPublicKeyThumbprint(e){var d;const t=(d=this.performanceClient)==null?void 0:d.startMeasurement(h.CryptoOptsGetPublicKeyThumbprint,e.correlationId),n=await Bs(He.EXTRACTABLE,He.POP_KEY_USAGES),o=await Dt(n.publicKey),r={e:o.e,kty:o.kty,n:o.n},i=_o(r),s=await this.hashString(i),c=await Dt(n.privateKey),l=await Fs(c,!1,["sign"]);return await this.cache.setItem(s,{privateKey:l,publicKey:n.publicKey,requestMethod:e.resourceRequestMethod,requestUri:e.resourceRequestUri}),t&&t.end({success:!0}),s}async removeTokenBindingKey(e){return await this.cache.removeItem(e),!await this.cache.containsKey(e)}async clearKeystore(){this.cache.clearInMemory();try{return await this.cache.clearPersistent(),!0}catch(e){return e instanceof Error?this.logger.error(`Clearing keystore failed with error: ${e.message}`):this.logger.error("Clearing keystore failed with unknown error"),!1}}async signJwt(e,t,n,o){var de;const r=(de=this.performanceClient)==null?void 0:de.startMeasurement(h.CryptoOptsSignJwt,o),i=await this.cache.getItem(t);if(!i)throw C(On);const s=await Dt(i.publicKey),c=_o(s),l=it(JSON.stringify({kid:t})),d=_n.getShrHeaderString({...n==null?void 0:n.header,alg:s.alg,kid:l}),m=it(d);e.cnf={jwk:JSON.parse(c)};const f=it(JSON.stringify(e)),T=`${m}.${f}`,y=new TextEncoder().encode(T),_=await Gs(i.privateKey,y),L=bt(new Uint8Array(_)),z=`${T}.${L}`;return r&&r.end({success:!0}),z}async hashString(e){return ri(e)}}He.POP_KEY_USAGES=["sign","verify"];He.EXTRACTABLE=!0;function _o(a){return JSON.stringify(a,Object.keys(a).sort())}/*! @azure/msal-browser v3.28.0 2024-12-12 */class ac{constructor(){if(!window.localStorage)throw Ln(Ve)}getItem(e){return window.localStorage.getItem(e)}setItem(e,t){window.localStorage.setItem(e,t)}removeItem(e){window.localStorage.removeItem(e)}getKeys(){return Object.keys(window.localStorage)}containsKey(e){return window.localStorage.hasOwnProperty(e)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class sc{constructor(){if(!window.sessionStorage)throw Ln(Ve)}getItem(e){return window.sessionStorage.getItem(e)}setItem(e,t){window.sessionStorage.setItem(e,t)}removeItem(e){window.sessionStorage.removeItem(e)}getKeys(){return Object.keys(window.sessionStorage)}containsKey(e){return window.sessionStorage.hasOwnProperty(e)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */function ci(a,e){if(!e)return null;try{return J.parseRequestState(a,e).libraryState.meta}catch{throw g(Me)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */const cc=24*60*60*1e3;class lc{getItem(e){const t=`${encodeURIComponent(e)}`,n=document.cookie.split(";");for(let o=0;o<n.length;o++){const r=n[o],[i,...s]=decodeURIComponent(r).trim().split("="),c=s.join("=");if(i===t)return c}return""}setItem(e,t,n,o=!0){let r=`${encodeURIComponent(e)}=${encodeURIComponent(t)};path=/;SameSite=Lax;`;if(n){const i=hc(n);r+=`expires=${i};`}o&&(r+="Secure;"),document.cookie=r}removeItem(e){this.setItem(e,"",-1)}getKeys(){const e=document.cookie.split(";"),t=[];return e.forEach(n=>{const o=decodeURIComponent(n).trim().split("=");t.push(o[0])}),t}containsKey(e){return this.getKeys().includes(e)}}function hc(a){const e=new Date;return new Date(e.getTime()+a*cc).toUTCString()}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Zt extends Ue{constructor(e,t,n,o,r,i){super(e,n,o,r),this.cacheConfig=t,this.logger=o,this.internalStorage=new Xt,this.browserStorage=this.setupBrowserStorage(this.cacheConfig.cacheLocation),this.temporaryCacheStorage=this.setupBrowserStorage(this.cacheConfig.temporaryCacheLocation),this.cookieStorage=new lc,t.cacheMigrationEnabled&&(this.migrateCacheEntries(),this.createKeyMaps()),this.performanceClient=i}setupBrowserStorage(e){try{switch(e){case q.LocalStorage:return new ac;case q.SessionStorage:return new sc;case q.MemoryStorage:default:break}}catch(t){this.logger.error(t)}return this.cacheConfig.cacheLocation=q.MemoryStorage,new Xt}migrateCacheEntries(){const e=`${u.CACHE_PREFIX}.${H.ID_TOKEN}`,t=`${u.CACHE_PREFIX}.${H.CLIENT_INFO}`,n=`${u.CACHE_PREFIX}.${H.ERROR}`,o=`${u.CACHE_PREFIX}.${H.ERROR_DESC}`,r=this.browserStorage.getItem(e),i=this.browserStorage.getItem(t),s=this.browserStorage.getItem(n),c=this.browserStorage.getItem(o),l=[r,i,s,c];[H.ID_TOKEN,H.CLIENT_INFO,H.ERROR,H.ERROR_DESC].forEach((m,f)=>{const T=l[f];T&&this.setTemporaryCache(m,T,!0)})}createKeyMaps(){this.logger.trace("BrowserCacheManager - createKeyMaps called.");const e=this.getItem(ue.ACCOUNT_KEYS),t=this.getItem(`${ue.TOKEN_KEYS}.${this.clientId}`);if(e&&t){this.logger.verbose("BrowserCacheManager:createKeyMaps - account and token key maps already exist, skipping migration.");return}this.browserStorage.getKeys().forEach(o=>{if(this.isCredentialKey(o)){const r=this.getItem(o);if(r){const i=this.validateAndParseJson(r);if(i&&i.hasOwnProperty("credentialType"))switch(i.credentialType){case E.ID_TOKEN:if(no(i)){this.logger.trace("BrowserCacheManager:createKeyMaps - idToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - idToken with key: ${o} found, saving key to token key map`);const s=i,c=this.updateCredentialCacheKey(o,s);this.addTokenKey(c,E.ID_TOKEN);return}else this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching idToken schema with value containing idToken credentialType field but value failed IdTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed idToken validation on key: ${o}`);break;case E.ACCESS_TOKEN:case E.ACCESS_TOKEN_WITH_AUTH_SCHEME:if(to(i)){this.logger.trace("BrowserCacheManager:createKeyMaps - accessToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - accessToken with key: ${o} found, saving key to token key map`);const s=i,c=this.updateCredentialCacheKey(o,s);this.addTokenKey(c,E.ACCESS_TOKEN);return}else this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching accessToken schema with value containing accessToken credentialType field but value failed AccessTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed accessToken validation on key: ${o}`);break;case E.REFRESH_TOKEN:if(oo(i)){this.logger.trace("BrowserCacheManager:createKeyMaps - refreshToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - refreshToken with key: ${o} found, saving key to token key map`);const s=i,c=this.updateCredentialCacheKey(o,s);this.addTokenKey(c,E.REFRESH_TOKEN);return}else this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching refreshToken schema with value containing refreshToken credentialType field but value failed RefreshTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed refreshToken validation on key: ${o}`);break}}}if(this.isAccountKey(o)){const r=this.getItem(o);if(r){const i=this.validateAndParseJson(r);i&&U.isAccountEntity(i)&&(this.logger.trace("BrowserCacheManager:createKeyMaps - account found, saving key to account key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - account with key: ${o} found, saving key to account key map`),this.addAccountKeyToMap(o))}}})}validateAndParseJson(e){try{const t=JSON.parse(e);return t&&typeof t=="object"?t:null}catch{return null}}getItem(e){return this.browserStorage.getItem(e)}setItem(e,t){this.browserStorage.setItem(e,t)}getAccount(e,t){this.logger.trace("BrowserCacheManager.getAccount called");const n=this.getCachedAccountEntity(e);return this.updateOutdatedCachedAccount(e,n,t)}getCachedAccountEntity(e){const t=this.getItem(e);if(!t)return this.removeAccountKeyFromMap(e),null;const n=this.validateAndParseJson(t);return!n||!U.isAccountEntity(n)?(this.removeAccountKeyFromMap(e),null):Ue.toObject(new U,n)}setAccount(e){this.logger.trace("BrowserCacheManager.setAccount called");const t=e.generateAccountKey();this.setItem(t,JSON.stringify(e)),this.addAccountKeyToMap(t)}getAccountKeys(){this.logger.trace("BrowserCacheManager.getAccountKeys called");const e=this.getItem(ue.ACCOUNT_KEYS);return e?JSON.parse(e):(this.logger.verbose("BrowserCacheManager.getAccountKeys - No account keys found"),[])}addAccountKeyToMap(e){this.logger.trace("BrowserCacheManager.addAccountKeyToMap called"),this.logger.tracePii(`BrowserCacheManager.addAccountKeyToMap called with key: ${e}`);const t=this.getAccountKeys();t.indexOf(e)===-1?(t.push(e),this.setItem(ue.ACCOUNT_KEYS,JSON.stringify(t)),this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key added")):this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key already exists in map")}removeAccountKeyFromMap(e){this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap called"),this.logger.tracePii(`BrowserCacheManager.removeAccountKeyFromMap called with key: ${e}`);const t=this.getAccountKeys(),n=t.indexOf(e);n>-1?(t.splice(n,1),this.setItem(ue.ACCOUNT_KEYS,JSON.stringify(t)),this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap account key removed")):this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap key not found in existing map")}async removeAccount(e){super.removeAccount(e),this.removeAccountKeyFromMap(e)}removeOutdatedAccount(e){this.removeItem(e),this.removeAccountKeyFromMap(e)}removeIdToken(e){super.removeIdToken(e),this.removeTokenKey(e,E.ID_TOKEN)}async removeAccessToken(e){super.removeAccessToken(e),this.removeTokenKey(e,E.ACCESS_TOKEN)}removeRefreshToken(e){super.removeRefreshToken(e),this.removeTokenKey(e,E.REFRESH_TOKEN)}getTokenKeys(){this.logger.trace("BrowserCacheManager.getTokenKeys called");const e=this.getItem(`${ue.TOKEN_KEYS}.${this.clientId}`);if(e){const t=this.validateAndParseJson(e);if(t&&t.hasOwnProperty("idToken")&&t.hasOwnProperty("accessToken")&&t.hasOwnProperty("refreshToken"))return t;this.logger.error("BrowserCacheManager.getTokenKeys - Token keys found but in an unknown format. Returning empty key map.")}else this.logger.verbose("BrowserCacheManager.getTokenKeys - No token keys found");return{idToken:[],accessToken:[],refreshToken:[]}}addTokenKey(e,t){this.logger.trace("BrowserCacheManager addTokenKey called");const n=this.getTokenKeys();switch(t){case E.ID_TOKEN:n.idToken.indexOf(e)===-1&&(this.logger.info("BrowserCacheManager: addTokenKey - idToken added to map"),n.idToken.push(e));break;case E.ACCESS_TOKEN:n.accessToken.indexOf(e)===-1&&(this.logger.info("BrowserCacheManager: addTokenKey - accessToken added to map"),n.accessToken.push(e));break;case E.REFRESH_TOKEN:n.refreshToken.indexOf(e)===-1&&(this.logger.info("BrowserCacheManager: addTokenKey - refreshToken added to map"),n.refreshToken.push(e));break;default:throw this.logger.error(`BrowserCacheManager:addTokenKey - CredentialType provided invalid. CredentialType: ${t}`),g(Ft)}this.setItem(`${ue.TOKEN_KEYS}.${this.clientId}`,JSON.stringify(n))}removeTokenKey(e,t){this.logger.trace("BrowserCacheManager removeTokenKey called");const n=this.getTokenKeys();switch(t){case E.ID_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove idToken with key: ${e} from map`);const o=n.idToken.indexOf(e);o>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - idToken removed from map"),n.idToken.splice(o,1)):this.logger.info("BrowserCacheManager: removeTokenKey - idToken does not exist in map. Either it was previously removed or it was never added.");break;case E.ACCESS_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove accessToken with key: ${e} from map`);const r=n.accessToken.indexOf(e);r>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - accessToken removed from map"),n.accessToken.splice(r,1)):this.logger.info("BrowserCacheManager: removeTokenKey - accessToken does not exist in map. Either it was previously removed or it was never added.");break;case E.REFRESH_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove refreshToken with key: ${e} from map`);const i=n.refreshToken.indexOf(e);i>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken removed from map"),n.refreshToken.splice(i,1)):this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken does not exist in map. Either it was previously removed or it was never added.");break;default:throw this.logger.error(`BrowserCacheManager:removeTokenKey - CredentialType provided invalid. CredentialType: ${t}`),g(Ft)}this.setItem(`${ue.TOKEN_KEYS}.${this.clientId}`,JSON.stringify(n))}getIdTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,E.ID_TOKEN),null;const n=this.validateAndParseJson(t);return!n||!no(n)?(this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,E.ID_TOKEN),null):(this.logger.trace("BrowserCacheManager.getIdTokenCredential: cache hit"),n)}setIdTokenCredential(e){this.logger.trace("BrowserCacheManager.setIdTokenCredential called");const t=Re(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,E.ID_TOKEN)}getAccessTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,E.ACCESS_TOKEN),null;const n=this.validateAndParseJson(t);return!n||!to(n)?(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,E.ACCESS_TOKEN),null):(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: cache hit"),n)}setAccessTokenCredential(e){this.logger.trace("BrowserCacheManager.setAccessTokenCredential called");const t=Re(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,E.ACCESS_TOKEN)}getRefreshTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,E.REFRESH_TOKEN),null;const n=this.validateAndParseJson(t);return!n||!oo(n)?(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,E.REFRESH_TOKEN),null):(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: cache hit"),n)}setRefreshTokenCredential(e){this.logger.trace("BrowserCacheManager.setRefreshTokenCredential called");const t=Re(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,E.REFRESH_TOKEN)}getAppMetadata(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null;const n=this.validateAndParseJson(t);return!n||!ta(e,n)?(this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null):(this.logger.trace("BrowserCacheManager.getAppMetadata: cache hit"),n)}setAppMetadata(e){this.logger.trace("BrowserCacheManager.setAppMetadata called");const t=ea(e);this.setItem(t,JSON.stringify(e))}getServerTelemetry(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null;const n=this.validateAndParseJson(t);return!n||!Xi(e,n)?(this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null):(this.logger.trace("BrowserCacheManager.getServerTelemetry: cache hit"),n)}setServerTelemetry(e,t){this.logger.trace("BrowserCacheManager.setServerTelemetry called"),this.setItem(e,JSON.stringify(t))}getAuthorityMetadata(e){const t=this.internalStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAuthorityMetadata: called, no cache hit"),null;const n=this.validateAndParseJson(t);return n&&na(e,n)?(this.logger.trace("BrowserCacheManager.getAuthorityMetadata: cache hit"),n):null}getAuthorityMetadataKeys(){return this.internalStorage.getKeys().filter(t=>this.isAuthorityMetadata(t))}setWrapperMetadata(e,t){this.internalStorage.setItem(rt.WRAPPER_SKU,e),this.internalStorage.setItem(rt.WRAPPER_VER,t)}getWrapperMetadata(){const e=this.internalStorage.getItem(rt.WRAPPER_SKU)||u.EMPTY_STRING,t=this.internalStorage.getItem(rt.WRAPPER_VER)||u.EMPTY_STRING;return[e,t]}setAuthorityMetadata(e,t){this.logger.trace("BrowserCacheManager.setAuthorityMetadata called"),this.internalStorage.setItem(e,JSON.stringify(t))}getActiveAccount(){const e=this.generateCacheKey(H.ACTIVE_ACCOUNT_FILTERS),t=this.getItem(e);if(!t){this.logger.trace("BrowserCacheManager.getActiveAccount: No active account filters cache schema found, looking for legacy schema");const o=this.generateCacheKey(H.ACTIVE_ACCOUNT),r=this.getItem(o);if(!r)return this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null;const i=this.getAccountInfoFilteredBy({localAccountId:r});return i?(this.logger.trace("BrowserCacheManager.getActiveAccount: Legacy active account cache schema found"),this.logger.trace("BrowserCacheManager.getActiveAccount: Adding active account filters cache schema"),this.setActiveAccount(i),i):null}const n=this.validateAndParseJson(t);return n?(this.logger.trace("BrowserCacheManager.getActiveAccount: Active account filters schema found"),this.getAccountInfoFilteredBy({homeAccountId:n.homeAccountId,localAccountId:n.localAccountId,tenantId:n.tenantId})):(this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null)}setActiveAccount(e){const t=this.generateCacheKey(H.ACTIVE_ACCOUNT_FILTERS),n=this.generateCacheKey(H.ACTIVE_ACCOUNT);if(e){this.logger.verbose("setActiveAccount: Active account set");const o={homeAccountId:e.homeAccountId,localAccountId:e.localAccountId,tenantId:e.tenantId};this.browserStorage.setItem(t,JSON.stringify(o)),this.browserStorage.setItem(n,e.localAccountId)}else this.logger.verbose("setActiveAccount: No account passed, active account not set"),this.browserStorage.removeItem(t),this.browserStorage.removeItem(n)}getThrottlingCache(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null;const n=this.validateAndParseJson(t);return!n||!Zi(e,n)?(this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null):(this.logger.trace("BrowserCacheManager.getThrottlingCache: cache hit"),n)}setThrottlingCache(e,t){this.logger.trace("BrowserCacheManager.setThrottlingCache called"),this.setItem(e,JSON.stringify(t))}getTemporaryCache(e,t){const n=t?this.generateCacheKey(e):e;if(this.cacheConfig.storeAuthStateInCookie){const r=this.cookieStorage.getItem(n);if(r)return this.logger.trace("BrowserCacheManager.getTemporaryCache: storeAuthStateInCookies set to true, retrieving from cookies"),r}const o=this.temporaryCacheStorage.getItem(n);if(!o){if(this.cacheConfig.cacheLocation===q.LocalStorage){const r=this.browserStorage.getItem(n);if(r)return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item found in local storage"),r}return this.logger.trace("BrowserCacheManager.getTemporaryCache: No cache item found in local storage"),null}return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item returned"),o}setTemporaryCache(e,t,n){const o=n?this.generateCacheKey(e):e;this.temporaryCacheStorage.setItem(o,t),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.setTemporaryCache: storeAuthStateInCookie set to true, setting item cookie"),this.cookieStorage.setItem(o,t,void 0,this.cacheConfig.secureCookies))}removeItem(e){this.browserStorage.removeItem(e)}removeTemporaryItem(e){this.temporaryCacheStorage.removeItem(e),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.removeItem: storeAuthStateInCookie is true, clearing item cookie"),this.cookieStorage.removeItem(e))}getKeys(){return this.browserStorage.getKeys()}async clear(){await this.removeAllAccounts(),this.removeAppMetadata(),this.temporaryCacheStorage.getKeys().forEach(e=>{(e.indexOf(u.CACHE_PREFIX)!==-1||e.indexOf(this.clientId)!==-1)&&this.removeTemporaryItem(e)}),this.browserStorage.getKeys().forEach(e=>{(e.indexOf(u.CACHE_PREFIX)!==-1||e.indexOf(this.clientId)!==-1)&&this.browserStorage.removeItem(e)}),this.internalStorage.clear()}async clearTokensAndKeysWithClaims(e,t){e.addQueueMeasurement(h.ClearTokensAndKeysWithClaims,t);const n=this.getTokenKeys(),o=[];n.accessToken.forEach(r=>{const i=this.getAccessTokenCredential(r);i!=null&&i.requestedClaimsHash&&r.includes(i.requestedClaimsHash.toLowerCase())&&o.push(this.removeAccessToken(r))}),await Promise.all(o),o.length>0&&this.logger.warning(`${o.length} access tokens with claims in the cache keys have been removed from the cache.`)}generateCacheKey(e){return this.validateAndParseJson(e)?JSON.stringify(e):j.startsWith(e,u.CACHE_PREFIX)||j.startsWith(e,H.ADAL_ID_TOKEN)?e:`${u.CACHE_PREFIX}.${this.clientId}.${e}`}generateAuthorityKey(e){const{libraryState:{id:t}}=J.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${k.AUTHORITY}.${t}`)}generateNonceKey(e){const{libraryState:{id:t}}=J.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${k.NONCE_IDTOKEN}.${t}`)}generateStateKey(e){const{libraryState:{id:t}}=J.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${k.REQUEST_STATE}.${t}`)}getCachedAuthority(e){const t=this.generateStateKey(e),n=this.getTemporaryCache(t);if(!n)return null;const o=this.generateAuthorityKey(n);return this.getTemporaryCache(o)}updateCacheEntries(e,t,n,o,r){this.logger.trace("BrowserCacheManager.updateCacheEntries called");const i=this.generateStateKey(e);this.setTemporaryCache(i,e,!1);const s=this.generateNonceKey(e);this.setTemporaryCache(s,t,!1);const c=this.generateAuthorityKey(e);if(this.setTemporaryCache(c,n,!1),r){const l={credential:r.homeAccountId,type:Q.HOME_ACCOUNT_ID};this.setTemporaryCache(k.CCS_CREDENTIAL,JSON.stringify(l),!0)}else if(o){const l={credential:o,type:Q.UPN};this.setTemporaryCache(k.CCS_CREDENTIAL,JSON.stringify(l),!0)}}resetRequestCache(e){this.logger.trace("BrowserCacheManager.resetRequestCache called"),e&&(this.temporaryCacheStorage.getKeys().forEach(t=>{t.indexOf(e)!==-1&&this.removeTemporaryItem(t)}),this.removeTemporaryItem(this.generateStateKey(e)),this.removeTemporaryItem(this.generateNonceKey(e)),this.removeTemporaryItem(this.generateAuthorityKey(e))),this.removeTemporaryItem(this.generateCacheKey(k.REQUEST_PARAMS)),this.removeTemporaryItem(this.generateCacheKey(k.ORIGIN_URI)),this.removeTemporaryItem(this.generateCacheKey(k.URL_HASH)),this.removeTemporaryItem(this.generateCacheKey(k.CORRELATION_ID)),this.removeTemporaryItem(this.generateCacheKey(k.CCS_CREDENTIAL)),this.removeTemporaryItem(this.generateCacheKey(k.NATIVE_REQUEST)),this.setInteractionInProgress(!1)}cleanRequestByState(e){if(this.logger.trace("BrowserCacheManager.cleanRequestByState called"),e){const t=this.generateStateKey(e),n=this.temporaryCacheStorage.getItem(t);this.logger.infoPii(`BrowserCacheManager.cleanRequestByState: Removing temporary cache items for state: ${n}`),this.resetRequestCache(n||u.EMPTY_STRING)}}cleanRequestByInteractionType(e){this.logger.trace("BrowserCacheManager.cleanRequestByInteractionType called"),this.temporaryCacheStorage.getKeys().forEach(t=>{if(t.indexOf(k.REQUEST_STATE)===-1)return;const n=this.temporaryCacheStorage.getItem(t);if(!n)return;const o=ci(this.cryptoImpl,n);o&&o.interactionType===e&&(this.logger.infoPii(`BrowserCacheManager.cleanRequestByInteractionType: Removing temporary cache items for state: ${n}`),this.resetRequestCache(n))}),this.setInteractionInProgress(!1)}cacheCodeRequest(e){this.logger.trace("BrowserCacheManager.cacheCodeRequest called");const t=Pn(JSON.stringify(e));this.setTemporaryCache(k.REQUEST_PARAMS,t,!0)}getCachedRequest(e){this.logger.trace("BrowserCacheManager.getCachedRequest called");const t=this.getTemporaryCache(k.REQUEST_PARAMS,!0);if(!t)throw C(Dr);let n;try{n=JSON.parse(oe(t))}catch(o){throw this.logger.errorPii(`Attempted to parse: ${t}`),this.logger.error(`Parsing cached token request threw with error: ${o}`),C(Kr)}if(this.removeTemporaryItem(this.generateCacheKey(k.REQUEST_PARAMS)),!n.authority){const o=this.generateAuthorityKey(e),r=this.getTemporaryCache(o);if(!r)throw C(bn);n.authority=r}return n}getCachedNativeRequest(){this.logger.trace("BrowserCacheManager.getCachedNativeRequest called");const e=this.getTemporaryCache(k.NATIVE_REQUEST,!0);if(!e)return this.logger.trace("BrowserCacheManager.getCachedNativeRequest: No cached native request found"),null;const t=this.validateAndParseJson(e);return t||(this.logger.error("BrowserCacheManager.getCachedNativeRequest: Unable to parse native request"),null)}isInteractionInProgress(e){const t=this.getInteractionInProgress();return e?t===this.clientId:!!t}getInteractionInProgress(){const e=`${u.CACHE_PREFIX}.${k.INTERACTION_STATUS_KEY}`;return this.getTemporaryCache(e,!1)}setInteractionInProgress(e){const t=`${u.CACHE_PREFIX}.${k.INTERACTION_STATUS_KEY}`;if(e){if(this.getInteractionInProgress())throw C(br);this.setTemporaryCache(t,this.clientId,!1)}else!e&&this.getInteractionInProgress()===this.clientId&&this.removeTemporaryItem(t)}getLegacyLoginHint(){const e=this.getTemporaryCache(H.ADAL_ID_TOKEN);e&&(this.browserStorage.removeItem(H.ADAL_ID_TOKEN),this.logger.verbose("Cached ADAL id token retrieved."));const t=this.getTemporaryCache(H.ID_TOKEN,!0);t&&(this.browserStorage.removeItem(this.generateCacheKey(H.ID_TOKEN)),this.logger.verbose("Cached MSAL.js v1 id token retrieved"));const n=t||e;if(n){const o=Ee(n,oe);if(o.preferred_username)return this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, setting ADAL/MSAL v1 preferred_username as loginHint"),o.preferred_username;if(o.upn)return this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, setting ADAL/MSAL v1 upn as loginHint"),o.upn;this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, however, no account hint claim found. Enable preferred_username or upn id token claim to get SSO.")}return null}updateCredentialCacheKey(e,t){const n=Re(t);if(e!==n){const o=this.getItem(e);if(o)return this.browserStorage.removeItem(e),this.setItem(n,o),this.logger.verbose(`Updated an outdated ${t.credentialType} cache key`),n;this.logger.error(`Attempted to update an outdated ${t.credentialType} cache key but no item matching the outdated key was found in storage`)}return e}async hydrateCache(e,t){var s,c,l;const n=At((s=e.account)==null?void 0:s.homeAccountId,(c=e.account)==null?void 0:c.environment,e.idToken,this.clientId,e.tenantId);let o;t.claims&&(o=await this.cryptoImpl.hashString(t.claims));const r=It((l=e.account)==null?void 0:l.homeAccountId,e.account.environment,e.accessToken,this.clientId,e.tenantId,e.scopes.join(" "),e.expiresOn?e.expiresOn.getTime()/1e3:0,e.extExpiresOn?e.extExpiresOn.getTime()/1e3:0,oe,void 0,e.tokenType,void 0,t.sshKid,t.claims,o),i={idToken:n,accessToken:r};return this.saveCacheRecord(i)}async saveCacheRecord(e,t,n){try{await super.saveCacheRecord(e,t,n)}catch(o){if(o instanceof Ne&&this.performanceClient&&n)try{const r=this.getTokenKeys();this.performanceClient.addFields({cacheRtCount:r.refreshToken.length,cacheIdCount:r.idToken.length,cacheAtCount:r.accessToken.length},n)}catch{}throw o}}}const dc=(a,e)=>{const t={cacheLocation:q.MemoryStorage,temporaryCacheLocation:q.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1};return new Zt(a,t,ht,e)};/*! @azure/msal-browser v3.28.0 2024-12-12 */function uc(a,e,t,n){return a.verbose("getAllAccounts called"),t?e.getAllAccounts(n):[]}function gc(a,e,t){if(e.trace("getAccount called"),Object.keys(a).length===0)return e.warning("getAccount: No accountFilter provided"),null;const n=t.getAccountInfoFilteredBy(a);return n?(e.verbose("getAccount: Account matching provided filter found, returning"),n):(e.verbose("getAccount: No matching account found, returning null"),null)}function mc(a,e,t){if(e.trace("getAccountByUsername called"),!a)return e.warning("getAccountByUsername: No username provided"),null;const n=t.getAccountInfoFilteredBy({username:a});return n?(e.verbose("getAccountByUsername: Account matching username found, returning"),e.verbosePii(`getAccountByUsername: Returning signed-in accounts matching username: ${a}`),n):(e.verbose("getAccountByUsername: No matching account found, returning null"),null)}function pc(a,e,t){if(e.trace("getAccountByHomeId called"),!a)return e.warning("getAccountByHomeId: No homeAccountId provided"),null;const n=t.getAccountInfoFilteredBy({homeAccountId:a});return n?(e.verbose("getAccountByHomeId: Account matching homeAccountId found, returning"),e.verbosePii(`getAccountByHomeId: Returning signed-in accounts matching homeAccountId: ${a}`),n):(e.verbose("getAccountByHomeId: No matching account found, returning null"),null)}function fc(a,e,t){if(e.trace("getAccountByLocalId called"),!a)return e.warning("getAccountByLocalId: No localAccountId provided"),null;const n=t.getAccountInfoFilteredBy({localAccountId:a});return n?(e.verbose("getAccountByLocalId: Account matching localAccountId found, returning"),e.verbosePii(`getAccountByLocalId: Returning signed-in accounts matching localAccountId: ${a}`),n):(e.verbose("getAccountByLocalId: No matching account found, returning null"),null)}function Cc(a,e){e.setActiveAccount(a)}function yc(a){return a.getActiveAccount()}/*! @azure/msal-browser v3.28.0 2024-12-12 */const I={INITIALIZE_START:"msal:initializeStart",INITIALIZE_END:"msal:initializeEnd",ACCOUNT_ADDED:"msal:accountAdded",ACCOUNT_REMOVED:"msal:accountRemoved",ACTIVE_ACCOUNT_CHANGED:"msal:activeAccountChanged",LOGIN_START:"msal:loginStart",LOGIN_SUCCESS:"msal:loginSuccess",LOGIN_FAILURE:"msal:loginFailure",ACQUIRE_TOKEN_START:"msal:acquireTokenStart",ACQUIRE_TOKEN_SUCCESS:"msal:acquireTokenSuccess",ACQUIRE_TOKEN_FAILURE:"msal:acquireTokenFailure",ACQUIRE_TOKEN_NETWORK_START:"msal:acquireTokenFromNetworkStart",SSO_SILENT_START:"msal:ssoSilentStart",SSO_SILENT_SUCCESS:"msal:ssoSilentSuccess",SSO_SILENT_FAILURE:"msal:ssoSilentFailure",ACQUIRE_TOKEN_BY_CODE_START:"msal:acquireTokenByCodeStart",ACQUIRE_TOKEN_BY_CODE_SUCCESS:"msal:acquireTokenByCodeSuccess",ACQUIRE_TOKEN_BY_CODE_FAILURE:"msal:acquireTokenByCodeFailure",HANDLE_REDIRECT_START:"msal:handleRedirectStart",HANDLE_REDIRECT_END:"msal:handleRedirectEnd",POPUP_OPENED:"msal:popupOpened",LOGOUT_START:"msal:logoutStart",LOGOUT_SUCCESS:"msal:logoutSuccess",LOGOUT_FAILURE:"msal:logoutFailure",LOGOUT_END:"msal:logoutEnd",RESTORE_FROM_BFCACHE:"msal:restoreFromBFCache"};/*! @azure/msal-browser v3.28.0 2024-12-12 */class Tc{constructor(e){this.eventCallbacks=new Map,this.logger=e||new pe({})}addEventCallback(e,t,n){if(typeof window<"u"){const o=n||js();return this.eventCallbacks.has(o)?(this.logger.error(`Event callback with id: ${o} is already registered. Please provide a unique id or remove the existing callback and try again.`),null):(this.eventCallbacks.set(o,[e,t||[]]),this.logger.verbose(`Event callback registered with id: ${o}`),o)}return null}removeEventCallback(e){this.eventCallbacks.delete(e),this.logger.verbose(`Event callback ${e} removed.`)}emitEvent(e,t,n,o){if(typeof window<"u"){const r={eventType:e,interactionType:t||null,payload:n||null,error:o||null,timestamp:Date.now()};this.eventCallbacks.forEach(([i,s],c)=>{(s.length===0||s.includes(e))&&(this.logger.verbose(`Emitting event to callback ${c}: ${e}`),i.apply(null,[r]))})}}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class li{constructor(e,t,n,o,r,i,s,c,l){this.config=e,this.browserStorage=t,this.browserCrypto=n,this.networkClient=this.config.system.networkClient,this.eventHandler=r,this.navigationClient=i,this.nativeMessageHandler=c,this.correlationId=l||he(),this.logger=o.clone($.MSAL_SKU,Ot,this.correlationId),this.performanceClient=s}async clearCacheOnLogout(e){if(e){U.accountInfoIsEqual(e,this.browserStorage.getActiveAccount(),!1)&&(this.logger.verbose("Setting active account to null"),this.browserStorage.setActiveAccount(null));try{await this.browserStorage.removeAccount(U.generateAccountCacheKey(e)),this.logger.verbose("Cleared cache items belonging to the account provided in the logout request.")}catch{this.logger.error("Account provided in logout request was not found. Local cache unchanged.")}}else try{this.logger.verbose("No account provided in logout request, clearing all cache items.",this.correlationId),await this.browserStorage.clear(),await this.browserCrypto.clearKeystore()}catch{this.logger.error("Attempted to clear all MSAL cache items and failed. Local cache unchanged.")}}getRedirectUri(e){this.logger.verbose("getRedirectUri called");const t=e||this.config.auth.redirectUri;return w.getAbsoluteUrl(t,ce())}initializeServerTelemetryManager(e,t){this.logger.verbose("initializeServerTelemetryManager called");const n={clientId:this.config.auth.clientId,correlationId:this.correlationId,apiId:e,forceRefresh:t||!1,wrapperSKU:this.browserStorage.getWrapperMetadata()[0],wrapperVer:this.browserStorage.getWrapperMetadata()[1]};return new qe(n,this.browserStorage)}async getDiscoveredAuthority(e){const{account:t}=e,n=e.requestExtraQueryParameters&&e.requestExtraQueryParameters.hasOwnProperty("instance_aware")?e.requestExtraQueryParameters.instance_aware:void 0;this.performanceClient.addQueueMeasurement(h.StandardInteractionClientGetDiscoveredAuthority,this.correlationId);const o={protocolMode:this.config.auth.protocolMode,OIDCOptions:this.config.auth.OIDCOptions,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},r=e.requestAuthority||this.config.auth.authority,i=n!=null&&n.length?n==="true":this.config.auth.instanceAware,s=t&&i?this.config.auth.authority.replace(w.getDomainFromUrl(r),t.environment):r,c=x.generateAuthority(s,e.requestAzureCloudOptions||this.config.auth.azureCloudOptions),l=await p(yr,h.AuthorityFactoryCreateDiscoveredInstance,this.logger,this.performanceClient,this.correlationId)(c,this.config.system.networkClient,this.browserStorage,o,this.logger,this.correlationId,this.performanceClient);if(t&&!l.isAlias(t.environment))throw b(lr);return l}}/*! @azure/msal-browser v3.28.0 2024-12-12 */const Ac=32;async function Ic(a,e,t){a.addQueueMeasurement(h.GeneratePkceCodes,t);const n=ve(Ec,h.GenerateCodeVerifier,e,a,t)(a,e,t),o=await p(vc,h.GenerateCodeChallengeFromVerifier,e,a,t)(n,a,e,t);return{verifier:n,challenge:o}}function Ec(a,e,t){try{const n=new Uint8Array(Ac);return ve(xs,h.GetRandomValues,e,a,t)(n),bt(n)}catch{throw C(kn)}}async function vc(a,e,t,n){e.addQueueMeasurement(h.GenerateCodeChallengeFromVerifier,n);try{const o=await p(oi,h.Sha256Digest,t,e,n)(a,e,n);return bt(new Uint8Array(o))}catch{throw C(kn)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */async function xn(a,e,t,n){t.addQueueMeasurement(h.InitializeBaseRequest,a.correlationId);const o=a.authority||e.auth.authority,r=[...a&&a.scopes||[]],i={...a,correlationId:a.correlationId,authority:o,scopes:r};if(!i.authenticationScheme)i.authenticationScheme=R.BEARER,n.verbose(`Authentication Scheme wasn't explicitly set in request, defaulting to "Bearer" request`);else{if(i.authenticationScheme===R.SSH){if(!a.sshJwk)throw b(Et);if(!a.sshKid)throw b(ar)}n.verbose(`Authentication Scheme set to "${i.authenticationScheme}" as configured in Auth request`)}return e.cache.claimsBasedCachingEnabled&&a.claims&&!j.isEmptyObj(a.claims)&&(i.requestedClaimsHash=await ri(a.claims)),i}async function Sc(a,e,t,n,o){n.addQueueMeasurement(h.InitializeSilentRequest,a.correlationId);const r=await p(xn,h.InitializeBaseRequest,o,n,a.correlationId)(a,t,n,o);return{...a,...r,account:e,forceRefresh:a.forceRefresh||!1}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Ke extends li{async initializeAuthorizationCodeRequest(e){this.performanceClient.addQueueMeasurement(h.StandardInteractionClientInitializeAuthorizationCodeRequest,this.correlationId);const t=await p(Ic,h.GeneratePkceCodes,this.logger,this.performanceClient,this.correlationId)(this.performanceClient,this.logger,this.correlationId),n={...e,redirectUri:e.redirectUri,code:u.EMPTY_STRING,codeVerifier:t.verifier};return e.codeChallenge=t.challenge,e.codeChallengeMethod=u.S256_CODE_CHALLENGE_METHOD,n}initializeLogoutRequest(e){this.logger.verbose("initializeLogoutRequest called",e==null?void 0:e.correlationId);const t={correlationId:this.correlationId||he(),...e};if(e)if(e.logoutHint)this.logger.verbose("logoutHint has already been set in logoutRequest");else if(e.account){const n=this.getLogoutHintFromIdTokenClaims(e.account);n&&(this.logger.verbose("Setting logoutHint to login_hint ID Token Claim value for the account provided"),t.logoutHint=n)}else this.logger.verbose("logoutHint was not set and account was not passed into logout request, logoutHint will not be set");else this.logger.verbose("logoutHint will not be set since no logout request was configured");return!e||e.postLogoutRedirectUri!==null?e&&e.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to uri set on logout request",t.correlationId),t.postLogoutRedirectUri=w.getAbsoluteUrl(e.postLogoutRedirectUri,ce())):this.config.auth.postLogoutRedirectUri===null?this.logger.verbose("postLogoutRedirectUri configured as null and no uri set on request, not passing post logout redirect",t.correlationId):this.config.auth.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to configured uri",t.correlationId),t.postLogoutRedirectUri=w.getAbsoluteUrl(this.config.auth.postLogoutRedirectUri,ce())):(this.logger.verbose("Setting postLogoutRedirectUri to current page",t.correlationId),t.postLogoutRedirectUri=w.getAbsoluteUrl(ce(),ce())):this.logger.verbose("postLogoutRedirectUri passed as null, not setting post logout redirect uri",t.correlationId),t}getLogoutHintFromIdTokenClaims(e){const t=e.idTokenClaims;if(t){if(t.login_hint)return t.login_hint;this.logger.verbose("The ID Token Claims tied to the provided account do not contain a login_hint claim, logoutHint will not be added to logout request")}else this.logger.verbose("The provided account does not contain ID Token Claims, logoutHint will not be added to logout request");return null}async createAuthCodeClient(e){this.performanceClient.addQueueMeasurement(h.StandardInteractionClientCreateAuthCodeClient,this.correlationId);const t=await p(this.getClientConfiguration.bind(this),h.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e);return new Ir(t,this.performanceClient)}async getClientConfiguration(e){const{serverTelemetryManager:t,requestAuthority:n,requestAzureCloudOptions:o,requestExtraQueryParameters:r,account:i}=e;this.performanceClient.addQueueMeasurement(h.StandardInteractionClientGetClientConfiguration,this.correlationId);const s=await p(this.getDiscoveredAuthority.bind(this),h.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,this.correlationId)({requestAuthority:n,requestAzureCloudOptions:o,requestExtraQueryParameters:r,account:i}),c=this.config.system.loggerOptions;return{authOptions:{clientId:this.config.auth.clientId,authority:s,clientCapabilities:this.config.auth.clientCapabilities,redirectUri:this.config.auth.redirectUri},systemOptions:{tokenRenewalOffsetSeconds:this.config.system.tokenRenewalOffsetSeconds,preventCorsPreflight:!0},loggerOptions:{loggerCallback:c.loggerCallback,piiLoggingEnabled:c.piiLoggingEnabled,logLevel:c.logLevel,correlationId:this.correlationId},cacheOptions:{claimsBasedCachingEnabled:this.config.cache.claimsBasedCachingEnabled},cryptoInterface:this.browserCrypto,networkInterface:this.networkClient,storageInterface:this.browserStorage,serverTelemetryManager:t,libraryInfo:{sku:$.MSAL_SKU,version:Ot,cpu:u.EMPTY_STRING,os:u.EMPTY_STRING},telemetry:this.config.telemetry}}async initializeAuthorizationRequest(e,t){this.performanceClient.addQueueMeasurement(h.StandardInteractionClientInitializeAuthorizationRequest,this.correlationId);const n=this.getRedirectUri(e.redirectUri),o={interactionType:t},r=J.setRequestState(this.browserCrypto,e&&e.state||u.EMPTY_STRING,o),s={...await p(xn,h.InitializeBaseRequest,this.logger,this.performanceClient,this.correlationId)({...e,correlationId:this.correlationId},this.config,this.performanceClient,this.logger),redirectUri:n,state:r,nonce:e.nonce||he(),responseMode:this.config.auth.OIDCOptions.serverResponseType};if(e.loginHint||e.sid)return s;const c=e.account||this.browserStorage.getActiveAccount();if(c&&(this.logger.verbose("Setting validated request account",this.correlationId),this.logger.verbosePii(`Setting validated request account: ${c.homeAccountId}`,this.correlationId),s.account=c),!s.loginHint&&!c){const l=this.browserStorage.getLegacyLoginHint();l&&(s.loginHint=l)}return s}}/*! @azure/msal-browser v3.28.0 2024-12-12 */const wc="ContentError",hi="user_switch";/*! @azure/msal-browser v3.28.0 2024-12-12 */const _c="USER_INTERACTION_REQUIRED",kc="USER_CANCEL",Rc="NO_NETWORK",bc="PERSISTENT_ERROR",Oc="DISABLED",Nc="ACCOUNT_UNAVAILABLE";/*! @azure/msal-browser v3.28.0 2024-12-12 */const Pc=-2147186943,Mc={[hi]:"User attempted to switch accounts in the native broker, which is not allowed. All new accounts must sign-in through the standard web flow first, please try again."};class te extends P{constructor(e,t,n){super(e,t),Object.setPrototypeOf(this,te.prototype),this.name="NativeAuthError",this.ext=n}}function ke(a){if(a.ext&&a.ext.status&&(a.ext.status===bc||a.ext.status===Oc)||a.ext&&a.ext.error&&a.ext.error===Pc)return!0;switch(a.errorCode){case wc:return!0;default:return!1}}function en(a,e,t){if(t&&t.status)switch(t.status){case Nc:return Vt(Tr);case _c:return new X(a,e);case kc:return C(Ae);case Rc:return C(ft)}return new te(a,Mc[a]||e,t)}/*! @azure/msal-browser v3.28.0 2024-12-12 */class di extends Ke{async acquireToken(e){this.performanceClient.addQueueMeasurement(h.SilentCacheClientAcquireToken,e.correlationId);const t=this.initializeServerTelemetryManager(O.acquireTokenSilent_silentFlow),n=await p(this.getClientConfiguration.bind(this),h.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:t,requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,account:e.account}),o=new Cs(n,this.performanceClient);this.logger.verbose("Silent auth client created");try{const i=(await p(o.acquireCachedToken.bind(o),h.SilentFlowClientAcquireCachedToken,this.logger,this.performanceClient,e.correlationId)(e))[0];return this.performanceClient.addFields({fromCache:!0},e.correlationId),i}catch(r){throw r instanceof Qe&&r.errorCode===On&&this.logger.verbose("Signing keypair for bound access token not found. Refreshing bound access token and generating a new crypto keypair."),r}}logout(e){this.logger.verbose("logoutRedirect called");const t=this.initializeLogoutRequest(e);return this.clearCacheOnLogout(t==null?void 0:t.account)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Pe extends li{constructor(e,t,n,o,r,i,s,c,l,d,m,f){var v;super(e,t,n,o,r,i,c,l,f),this.apiId=s,this.accountId=d,this.nativeMessageHandler=l,this.nativeStorageManager=m,this.silentCacheClient=new di(e,this.nativeStorageManager,n,o,r,i,c,l,f),this.serverTelemetryManager=this.initializeServerTelemetryManager(this.apiId);const T=this.nativeMessageHandler.getExtensionId()===Oe.PREFERRED_EXTENSION_ID?"chrome":(v=this.nativeMessageHandler.getExtensionId())!=null&&v.length?"unknown":void 0;this.skus=qe.makeExtraSkuString({libraryName:$.MSAL_SKU,libraryVersion:Ot,extensionName:T,extensionVersion:this.nativeMessageHandler.getExtensionVersion()})}addRequestSKUs(e){e.extraParameters={...e.extraParameters,[es]:this.skus}}async acquireToken(e){this.performanceClient.addQueueMeasurement(h.NativeInteractionClientAcquireToken,e.correlationId),this.logger.trace("NativeInteractionClient - acquireToken called.");const t=this.performanceClient.startMeasurement(h.NativeInteractionClientAcquireToken,e.correlationId),n=re();try{const o=await this.initializeNativeRequest(e);try{const l=await this.acquireTokensFromCache(this.accountId,o);return t.end({success:!0,isNativeBroker:!1,fromCache:!0}),l}catch{this.logger.info("MSAL internal Cache does not contain tokens, proceed to make a native call")}const{...r}=o,i={method:Ce.GetToken,request:r},s=await this.nativeMessageHandler.sendMessage(i),c=this.validateNativeResponse(s);return await this.handleNativeResponse(c,o,n).then(l=>(t.end({success:!0,isNativeBroker:!0,requestId:l.requestId}),this.serverTelemetryManager.clearNativeBrokerErrorCode(),l)).catch(l=>{throw t.end({success:!1,errorCode:l.errorCode,subErrorCode:l.subError,isNativeBroker:!0}),l})}catch(o){throw o instanceof te&&this.serverTelemetryManager.setNativeBrokerErrorCode(o.errorCode),o}}createSilentCacheRequest(e,t){return{authority:e.authority,correlationId:this.correlationId,scopes:M.fromString(e.scope).asArray(),account:t,forceRefresh:!1}}async acquireTokensFromCache(e,t){if(!e)throw this.logger.warning("NativeInteractionClient:acquireTokensFromCache - No nativeAccountId provided"),g(xt);const n=this.browserStorage.getBaseAccountInfo({nativeAccountId:e});if(!n)throw g(xt);try{const o=this.createSilentCacheRequest(t,n),r=await this.silentCacheClient.acquireToken(o),i={...n,idTokenClaims:r==null?void 0:r.idTokenClaims,idToken:r==null?void 0:r.idToken};return{...r,account:i}}catch(o){throw o}}async acquireTokenRedirect(e,t){this.logger.trace("NativeInteractionClient - acquireTokenRedirect called.");const{...n}=e;delete n.onRedirectNavigate;const o=await this.initializeNativeRequest(n),r={method:Ce.GetToken,request:o};try{const c=await this.nativeMessageHandler.sendMessage(r);this.validateNativeResponse(c)}catch(c){if(c instanceof te&&(this.serverTelemetryManager.setNativeBrokerErrorCode(c.errorCode),ke(c)))throw c}this.browserStorage.setTemporaryCache(k.NATIVE_REQUEST,JSON.stringify(o),!0);const i={apiId:O.acquireTokenRedirect,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},s=this.config.auth.navigateToLoginRequestUrl?window.location.href:this.getRedirectUri(e.redirectUri);t.end({success:!0}),await this.navigationClient.navigateExternal(s,i)}async handleRedirectPromise(e,t){if(this.logger.trace("NativeInteractionClient - handleRedirectPromise called."),!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const n=this.browserStorage.getCachedNativeRequest();if(!n)return this.logger.verbose("NativeInteractionClient - handleRedirectPromise called but there is no cached request, returning null."),e&&t&&(e==null||e.addFields({errorCode:"no_cached_request"},t)),null;const{prompt:o,...r}=n;o&&this.logger.verbose("NativeInteractionClient - handleRedirectPromise called and prompt was included in the original request, removing prompt from cached request to prevent second interaction with native broker window."),this.browserStorage.removeItem(this.browserStorage.generateCacheKey(k.NATIVE_REQUEST));const i={method:Ce.GetToken,request:r},s=re();try{this.logger.verbose("NativeInteractionClient - handleRedirectPromise sending message to native broker.");const c=await this.nativeMessageHandler.sendMessage(i);this.validateNativeResponse(c);const l=this.handleNativeResponse(c,r,s);this.browserStorage.setInteractionInProgress(!1);const d=await l;return this.serverTelemetryManager.clearNativeBrokerErrorCode(),d}catch(c){throw this.browserStorage.setInteractionInProgress(!1),c}}logout(){return this.logger.trace("NativeInteractionClient - logout called."),Promise.reject("Logout not implemented yet")}async handleNativeResponse(e,t,n){var d;this.logger.trace("NativeInteractionClient - handleNativeResponse called.");const o=Ee(e.id_token,oe),r=this.createHomeAccountIdentifier(e,o),i=(d=this.browserStorage.getAccountInfoFilteredBy({nativeAccountId:t.accountId}))==null?void 0:d.homeAccountId;if(r!==i&&e.account.id!==t.accountId)throw en(hi);const s=await this.getDiscoveredAuthority({requestAuthority:t.authority}),c=Sn(this.browserStorage,s,r,oe,o,e.client_info,void 0,o.tid,void 0,e.account.id,this.logger),l=await this.generateAuthenticationResult(e,t,o,c,s.canonicalAuthority,n);return this.cacheAccount(c),this.cacheNativeTokens(e,t,r,o,e.access_token,l.tenantId,n),l}createHomeAccountIdentifier(e,t){return U.generateHomeAccountId(e.client_info||u.EMPTY_STRING,W.Default,this.logger,this.browserCrypto,t)}generateScopes(e,t){return e.scope?M.fromString(e.scope):M.fromString(t.scope)}async generatePopAccessToken(e,t){if(t.tokenType===R.POP&&t.signPopToken){if(e.shr)return this.logger.trace("handleNativeServerResponse: SHR is enabled in native layer"),e.shr;const n=new Le(this.browserCrypto),o={resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,shrNonce:t.shrNonce};if(!t.keyId)throw g(ln);return n.signPopToken(e.access_token,t.keyId,o)}else return e.access_token}async generateAuthenticationResult(e,t,n,o,r,i){const s=this.addTelemetryFromNativeResponse(e),c=e.scope?M.fromString(e.scope):M.fromString(t.scope),l=e.account.properties||{},d=l.UID||n.oid||n.sub||u.EMPTY_STRING,m=l.TenantId||n.tid||u.EMPTY_STRING,f=yn(o.getAccountInfo(),void 0,n,e.id_token);f.nativeAccountId!==e.account.id&&(f.nativeAccountId=e.account.id);const T=await this.generatePopAccessToken(e,t),v=t.tokenType===R.POP?R.POP:R.BEARER;return{authority:r,uniqueId:d,tenantId:m,scopes:c.asArray(),account:f,idToken:e.id_token,idTokenClaims:n,accessToken:T,fromCache:s?this.isResponseFromCache(s):!1,expiresOn:new Date(Number(i+e.expires_in)*1e3),tokenType:v,correlationId:this.correlationId,state:e.state,fromNativeBroker:!0}}cacheAccount(e){this.browserStorage.setAccount(e),this.browserStorage.removeAccountContext(e).catch(t=>{this.logger.error(`Error occurred while removing account context from browser storage. ${t}`)})}cacheNativeTokens(e,t,n,o,r,i,s){const c=At(n,t.authority,e.id_token||"",t.clientId,o.tid||""),l=t.tokenType===R.POP?u.SHR_NONCE_VALIDITY:(typeof e.expires_in=="string"?parseInt(e.expires_in,10):e.expires_in)||0,d=s+l,m=this.generateScopes(e,t),f=It(n,t.authority,r,t.clientId,o.tid||i,m.printScopes(),d,0,oe,void 0,t.tokenType,void 0,t.keyId),T={idToken:c,accessToken:f};this.nativeStorageManager.saveCacheRecord(T,t.storeInCache)}addTelemetryFromNativeResponse(e){const t=this.getMATSFromResponse(e);return t?(this.performanceClient.addFields({extensionId:this.nativeMessageHandler.getExtensionId(),extensionVersion:this.nativeMessageHandler.getExtensionVersion(),matsBrokerVersion:t.broker_version,matsAccountJoinOnStart:t.account_join_on_start,matsAccountJoinOnEnd:t.account_join_on_end,matsDeviceJoin:t.device_join,matsPromptBehavior:t.prompt_behavior,matsApiErrorCode:t.api_error_code,matsUiVisible:t.ui_visible,matsSilentCode:t.silent_code,matsSilentBiSubCode:t.silent_bi_sub_code,matsSilentMessage:t.silent_message,matsSilentStatus:t.silent_status,matsHttpStatus:t.http_status,matsHttpEventCount:t.http_event_count},this.correlationId),t):null}validateNativeResponse(e){if(e.hasOwnProperty("access_token")&&e.hasOwnProperty("id_token")&&e.hasOwnProperty("client_info")&&e.hasOwnProperty("account")&&e.hasOwnProperty("scope")&&e.hasOwnProperty("expires_in"))return e;throw bo(nn,"Response missing expected properties.")}getMATSFromResponse(e){if(e.properties.MATS)try{return JSON.parse(e.properties.MATS)}catch{this.logger.error("NativeInteractionClient - Error parsing MATS telemetry, returning null instead")}return null}isResponseFromCache(e){return typeof e.is_cached>"u"?(this.logger.verbose("NativeInteractionClient - MATS telemetry does not contain field indicating if response was served from cache. Returning false."),!1):!!e.is_cached}async initializeNativeRequest(e){this.logger.trace("NativeInteractionClient - initializeNativeRequest called");const t=e.authority||this.config.auth.authority;e.account&&await this.getDiscoveredAuthority({requestAuthority:t,requestAzureCloudOptions:e.azureCloudOptions,account:e.account});const n=new w(t);n.validateAsUri();const{scopes:o,...r}=e,i=new M(o||[]);i.appendScopes(De);const s=()=>{switch(this.apiId){case O.ssoSilent:case O.acquireTokenSilent_silentFlow:return this.logger.trace("initializeNativeRequest: silent request sets prompt to none"),D.NONE}if(!e.prompt){this.logger.trace("initializeNativeRequest: prompt was not provided");return}switch(e.prompt){case D.NONE:case D.CONSENT:case D.LOGIN:return this.logger.trace("initializeNativeRequest: prompt is compatible with native flow"),e.prompt;default:throw this.logger.trace(`initializeNativeRequest: prompt = ${e.prompt} is not compatible with native flow`),C(Wr)}},c={...r,accountId:this.accountId,clientId:this.config.auth.clientId,authority:n.urlString,scope:i.printScopes(),redirectUri:this.getRedirectUri(e.redirectUri),prompt:s(),correlationId:this.correlationId,tokenType:e.authenticationScheme,windowTitleSubstring:document.title,extraParameters:{...e.extraQueryParameters,...e.tokenQueryParameters},extendedExpiryToken:!1,keyId:e.popKid};if(c.signPopToken&&e.popKid)throw C(Jr);if(this.handleExtraBrokerParams(c),c.extraParameters=c.extraParameters||{},c.extraParameters.telemetry=Oe.MATS_TELEMETRY,e.authenticationScheme===R.POP){const l={resourceRequestUri:e.resourceRequestUri,resourceRequestMethod:e.resourceRequestMethod,shrClaims:e.shrClaims,shrNonce:e.shrNonce},d=new Le(this.browserCrypto);let m;if(c.keyId)m=this.browserCrypto.base64UrlEncode(JSON.stringify({kid:c.keyId})),c.signPopToken=!1;else{const f=await p(d.generateCnf.bind(d),h.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(l,this.logger);m=f.reqCnfString,c.keyId=f.kid,c.signPopToken=!0}c.reqCnf=m}return this.addRequestSKUs(c),c}handleExtraBrokerParams(e){var r;const t=e.extraParameters&&e.extraParameters.hasOwnProperty(In)&&e.extraParameters.hasOwnProperty(qt)&&e.extraParameters.hasOwnProperty(ye);if(!e.embeddedClientId&&!t)return;let n="";const o=e.redirectUri;e.embeddedClientId?(e.redirectUri=this.config.auth.redirectUri,n=e.embeddedClientId):e.extraParameters&&(e.redirectUri=e.extraParameters[qt],n=e.extraParameters[ye]),e.extraParameters={child_client_id:n,child_redirect_uri:o},(r=this.performanceClient)==null||r.addFields({embeddedClientId:n,embeddedRedirectUri:o},e.correlationId)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class ne{constructor(e,t,n,o){this.logger=e,this.handshakeTimeoutMs=t,this.extensionId=o,this.resolvers=new Map,this.handshakeResolvers=new Map,this.messageChannel=new MessageChannel,this.windowListener=this.onWindowMessage.bind(this),this.performanceClient=n,this.handshakeEvent=n.startMeasurement(h.NativeMessageHandlerHandshake)}async sendMessage(e){this.logger.trace("NativeMessageHandler - sendMessage called.");const t={channel:Oe.CHANNEL_ID,extensionId:this.extensionId,responseId:he(),body:e};return this.logger.trace("NativeMessageHandler - Sending request to browser extension"),this.logger.tracePii(`NativeMessageHandler - Sending request to browser extension: ${JSON.stringify(t)}`),this.messageChannel.port1.postMessage(t),new Promise((n,o)=>{this.resolvers.set(t.responseId,{resolve:n,reject:o})})}static async createProvider(e,t,n){e.trace("NativeMessageHandler - createProvider called.");try{const o=new ne(e,t,n,Oe.PREFERRED_EXTENSION_ID);return await o.sendHandshakeRequest(),o}catch{const r=new ne(e,t,n);return await r.sendHandshakeRequest(),r}}async sendHandshakeRequest(){this.logger.trace("NativeMessageHandler - sendHandshakeRequest called."),window.addEventListener("message",this.windowListener,!1);const e={channel:Oe.CHANNEL_ID,extensionId:this.extensionId,responseId:he(),body:{method:Ce.HandshakeRequest}};return this.handshakeEvent.add({extensionId:this.extensionId,extensionHandshakeTimeoutMs:this.handshakeTimeoutMs}),this.messageChannel.port1.onmessage=t=>{this.onChannelMessage(t)},window.postMessage(e,window.origin,[this.messageChannel.port2]),new Promise((t,n)=>{this.handshakeResolvers.set(e.responseId,{resolve:t,reject:n}),this.timeoutId=window.setTimeout(()=>{window.removeEventListener("message",this.windowListener,!1),this.messageChannel.port1.close(),this.messageChannel.port2.close(),this.handshakeEvent.end({extensionHandshakeTimedOut:!0,success:!1}),n(C(Yr)),this.handshakeResolvers.delete(e.responseId)},this.handshakeTimeoutMs)})}onWindowMessage(e){if(this.logger.trace("NativeMessageHandler - onWindowMessage called"),e.source!==window)return;const t=e.data;if(!(!t.channel||t.channel!==Oe.CHANNEL_ID)&&!(t.extensionId&&t.extensionId!==this.extensionId)&&t.body.method===Ce.HandshakeRequest){const n=this.handshakeResolvers.get(t.responseId);if(!n){this.logger.trace(`NativeMessageHandler.onWindowMessage - resolver can't be found for request ${t.responseId}`);return}this.logger.verbose(t.extensionId?`Extension with id: ${t.extensionId} not installed`:"No extension installed"),clearTimeout(this.timeoutId),this.messageChannel.port1.close(),this.messageChannel.port2.close(),window.removeEventListener("message",this.windowListener,!1),this.handshakeEvent.end({success:!1,extensionInstalled:!1}),n.reject(C($r))}}onChannelMessage(e){this.logger.trace("NativeMessageHandler - onChannelMessage called.");const t=e.data,n=this.resolvers.get(t.responseId),o=this.handshakeResolvers.get(t.responseId);try{const r=t.body.method;if(r===Ce.Response){if(!n)return;const i=t.body.response;if(this.logger.trace("NativeMessageHandler - Received response from browser extension"),this.logger.tracePii(`NativeMessageHandler - Received response from browser extension: ${JSON.stringify(i)}`),i.status!=="Success")n.reject(en(i.code,i.description,i.ext));else if(i.result)i.result.code&&i.result.description?n.reject(en(i.result.code,i.result.description,i.result.ext)):n.resolve(i.result);else throw bo(nn,"Event does not contain result.");this.resolvers.delete(t.responseId)}else if(r===Ce.HandshakeResponse){if(!o){this.logger.trace(`NativeMessageHandler.onChannelMessage - resolver can't be found for request ${t.responseId}`);return}clearTimeout(this.timeoutId),window.removeEventListener("message",this.windowListener,!1),this.extensionId=t.extensionId,this.extensionVersion=t.body.version,this.logger.verbose(`NativeMessageHandler - Received HandshakeResponse from extension: ${this.extensionId}`),this.handshakeEvent.end({extensionInstalled:!0,success:!0}),o.resolve(),this.handshakeResolvers.delete(t.responseId)}}catch(r){this.logger.error("Error parsing response from WAM Extension"),this.logger.errorPii(`Error parsing response from WAM Extension: ${r}`),this.logger.errorPii(`Unable to parse ${e}`),n?n.reject(r):o&&o.reject(r)}}getExtensionId(){return this.extensionId}getExtensionVersion(){return this.extensionVersion}static isNativeAvailable(e,t,n,o){if(t.trace("isNativeAvailable called"),!e.system.allowNativeBroker)return t.trace("isNativeAvailable: allowNativeBroker is not enabled, returning false"),!1;if(!n)return t.trace("isNativeAvailable: WAM extension provider is not initialized, returning false"),!1;if(o)switch(o){case R.BEARER:case R.POP:return t.trace("isNativeAvailable: authenticationScheme is supported, returning true"),!0;default:return t.trace("isNativeAvailable: authenticationScheme is not supported, returning false"),!1}return!0}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Bn{constructor(e,t,n,o,r){this.authModule=e,this.browserStorage=t,this.authCodeRequest=n,this.logger=o,this.performanceClient=r}async handleCodeResponse(e,t){this.performanceClient.addQueueMeasurement(h.HandleCodeResponse,t.correlationId);let n;try{n=this.authModule.handleFragmentResponse(e,t.state)}catch(o){throw o instanceof fe&&o.subError===Ae?C(Ae):o}return p(this.handleCodeResponseFromServer.bind(this),h.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)(n,t)}async handleCodeResponseFromServer(e,t,n=!0){if(this.performanceClient.addQueueMeasurement(h.HandleCodeResponseFromServer,t.correlationId),this.logger.trace("InteractionHandler.handleCodeResponseFromServer called"),this.authCodeRequest.code=e.code,e.cloud_instance_host_name&&await p(this.authModule.updateAuthority.bind(this.authModule),h.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,t.correlationId)(e.cloud_instance_host_name,t.correlationId),n&&(e.nonce=t.nonce||void 0),e.state=t.state,e.client_info)this.authCodeRequest.clientInfo=e.client_info;else{const r=this.createCcsCredentials(t);r&&(this.authCodeRequest.ccsCredential=r)}return await p(this.authModule.acquireToken.bind(this.authModule),h.AuthClientAcquireToken,this.logger,this.performanceClient,t.correlationId)(this.authCodeRequest,e)}createCcsCredentials(e){return e.account?{credential:e.account.homeAccountId,type:Q.HOME_ACCOUNT_ID}:e.loginHint?{credential:e.loginHint,type:Q.UPN}:null}}/*! @azure/msal-browser v3.28.0 2024-12-12 */function ui(a,e,t){const n=gt(a);if(!n)throw dr(a)?(t.error(`A ${e} is present in the iframe but it does not contain known properties. It's likely that the ${e} has been replaced by code running on the redirectUri page.`),t.errorPii(`The ${e} detected is: ${a}`),C(_r)):(t.error(`The request has returned to the redirectUri but a ${e} is not present. It's likely that the ${e} has been removed or the page has been redirected by code running on the redirectUri page.`),C(wr));return n}function Uc(a,e,t){if(!a.state)throw C(Rn);const n=ci(e,a.state);if(!n)throw C(kr);if(n.interactionType!==t)throw C(Rr)}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Lc extends Ke{constructor(e,t,n,o,r,i,s,c,l,d){super(e,t,n,o,r,i,s,l,d),this.unloadWindow=this.unloadWindow.bind(this),this.nativeStorage=c}acquireToken(e){try{const n={popupName:this.generatePopupName(e.scopes||De,e.authority||this.config.auth.authority),popupWindowAttributes:e.popupWindowAttributes||{},popupWindowParent:e.popupWindowParent??window};return this.config.system.asyncPopups?(this.logger.verbose("asyncPopups set to true, acquiring token"),this.acquireTokenPopupAsync(e,n)):(this.logger.verbose("asyncPopup set to false, opening popup before acquiring token"),n.popup=this.openSizedPopup("about:blank",n),this.acquireTokenPopupAsync(e,n))}catch(t){return Promise.reject(t)}}logout(e){try{this.logger.verbose("logoutPopup called");const t=this.initializeLogoutRequest(e),n={popupName:this.generateLogoutPopupName(t),popupWindowAttributes:(e==null?void 0:e.popupWindowAttributes)||{},popupWindowParent:(e==null?void 0:e.popupWindowParent)??window},o=e&&e.authority,r=e&&e.mainWindowRedirectUri;return this.config.system.asyncPopups?(this.logger.verbose("asyncPopups set to true"),this.logoutPopupAsync(t,n,o,r)):(this.logger.verbose("asyncPopup set to false, opening popup"),n.popup=this.openSizedPopup("about:blank",n),this.logoutPopupAsync(t,n,o,r))}catch(t){return Promise.reject(t)}}async acquireTokenPopupAsync(e,t){var r;this.logger.verbose("acquireTokenPopupAsync called");const n=this.initializeServerTelemetryManager(O.acquireTokenPopup),o=await p(this.initializeAuthorizationRequest.bind(this),h.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(e,A.Popup);si(o.authority);try{const i=await p(this.initializeAuthorizationCodeRequest.bind(this),h.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(o),s=await p(this.createAuthCodeClient.bind(this),h.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:o.authority,requestAzureCloudOptions:o.azureCloudOptions,requestExtraQueryParameters:o.extraQueryParameters,account:o.account}),c=ne.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,e.authenticationScheme);let l;c&&(l=this.performanceClient.startMeasurement(h.FetchAccountIdWithNativeBroker,e.correlationId));const d=await s.getAuthCodeUrl({...o,nativeBroker:c}),m=new Bn(s,this.browserStorage,i,this.logger,this.performanceClient),f=this.initiateAuthRequest(d,t);this.eventHandler.emitEvent(I.POPUP_OPENED,A.Popup,{popupWindow:f},null);const T=await this.monitorPopupForHash(f,t.popupWindowParent),v=ve(ui,h.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(T,this.config.auth.OIDCOptions.serverResponseType,this.logger);if(ee.removeThrottle(this.browserStorage,this.config.auth.clientId,i),v.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),l&&l.end({success:!0,isNativeBroker:!0}),!this.nativeMessageHandler)throw C($e);const _=new Pe(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,O.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,v.accountId,this.nativeStorage,o.correlationId),{userRequestState:L}=J.parseRequestState(this.browserCrypto,o.state);return await _.acquireToken({...o,state:L,prompt:void 0})}return await m.handleCodeResponse(v,o)}catch(i){throw(r=t.popup)==null||r.close(),i instanceof P&&(i.setCorrelationId(this.correlationId),n.cacheFailedRequest(i)),i}}async logoutPopupAsync(e,t,n,o){var i,s,c,l;this.logger.verbose("logoutPopupAsync called"),this.eventHandler.emitEvent(I.LOGOUT_START,A.Popup,e);const r=this.initializeServerTelemetryManager(O.logoutPopup);try{await this.clearCacheOnLogout(e.account);const d=await p(this.createAuthCodeClient.bind(this),h.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:r,requestAuthority:n,account:e.account||void 0});try{d.authority.endSessionEndpoint}catch{if((i=e.account)!=null&&i.homeAccountId&&e.postLogoutRedirectUri&&d.authority.protocolMode===le.OIDC){if(this.browserStorage.removeAccount((s=e.account)==null?void 0:s.homeAccountId),this.eventHandler.emitEvent(I.LOGOUT_SUCCESS,A.Popup,e),o){const T={apiId:O.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},v=w.getAbsoluteUrl(o,ce());await this.navigationClient.navigateInternal(v,T)}(c=t.popup)==null||c.close();return}}const m=d.getLogoutUri(e);this.eventHandler.emitEvent(I.LOGOUT_SUCCESS,A.Popup,e);const f=this.openPopup(m,t);if(this.eventHandler.emitEvent(I.POPUP_OPENED,A.Popup,{popupWindow:f},null),await this.monitorPopupForHash(f,t.popupWindowParent).catch(()=>{}),o){const T={apiId:O.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},v=w.getAbsoluteUrl(o,ce());this.logger.verbose("Redirecting main window to url specified in the request"),this.logger.verbosePii(`Redirecting main window to: ${v}`),await this.navigationClient.navigateInternal(v,T)}else this.logger.verbose("No main window navigation requested")}catch(d){throw(l=t.popup)==null||l.close(),d instanceof P&&(d.setCorrelationId(this.correlationId),r.cacheFailedRequest(d)),this.browserStorage.setInteractionInProgress(!1),this.eventHandler.emitEvent(I.LOGOUT_FAILURE,A.Popup,null,d),this.eventHandler.emitEvent(I.LOGOUT_END,A.Popup),d}this.eventHandler.emitEvent(I.LOGOUT_END,A.Popup)}initiateAuthRequest(e,t){if(e)return this.logger.infoPii(`Navigate to: ${e}`),this.openPopup(e,t);throw this.logger.error("Navigate url is empty"),C(_t)}monitorPopupForHash(e,t){return new Promise((n,o)=>{this.logger.verbose("PopupHandler.monitorPopupForHash - polling started");const r=setInterval(()=>{if(e.closed){this.logger.error("PopupHandler.monitorPopupForHash - window closed"),clearInterval(r),o(C(Ae));return}let i="";try{i=e.location.href}catch{}if(!i||i==="about:blank")return;clearInterval(r);let s="";const c=this.config.auth.OIDCOptions.serverResponseType;e&&(c===Ye.QUERY?s=e.location.search:s=e.location.hash),this.logger.verbose("PopupHandler.monitorPopupForHash - popup window is on same origin as caller"),n(s)},this.config.system.pollIntervalMilliseconds)}).finally(()=>{this.cleanPopup(e,t)})}openPopup(e,t){try{let n;if(t.popup?(n=t.popup,this.logger.verbosePii(`Navigating popup window to: ${e}`),n.location.assign(e)):typeof t.popup>"u"&&(this.logger.verbosePii(`Opening popup window to: ${e}`),n=this.openSizedPopup(e,t)),!n)throw C(Nr);return n.focus&&n.focus(),this.currentWindow=n,t.popupWindowParent.addEventListener("beforeunload",this.unloadWindow),n}catch(n){throw this.logger.error("error opening popup "+n.message),this.browserStorage.setInteractionInProgress(!1),C(Or)}}openSizedPopup(e,{popupName:t,popupWindowAttributes:n,popupWindowParent:o}){var T,v,y,_;const r=o.screenLeft?o.screenLeft:o.screenX,i=o.screenTop?o.screenTop:o.screenY,s=o.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,c=o.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;let l=(T=n.popupSize)==null?void 0:T.width,d=(v=n.popupSize)==null?void 0:v.height,m=(y=n.popupPosition)==null?void 0:y.top,f=(_=n.popupPosition)==null?void 0:_.left;return(!l||l<0||l>s)&&(this.logger.verbose("Default popup window width used. Window width not configured or invalid."),l=$.POPUP_WIDTH),(!d||d<0||d>c)&&(this.logger.verbose("Default popup window height used. Window height not configured or invalid."),d=$.POPUP_HEIGHT),(!m||m<0||m>c)&&(this.logger.verbose("Default popup window top position used. Window top not configured or invalid."),m=Math.max(0,c/2-$.POPUP_HEIGHT/2+i)),(!f||f<0||f>s)&&(this.logger.verbose("Default popup window left position used. Window left not configured or invalid."),f=Math.max(0,s/2-$.POPUP_WIDTH/2+r)),o.open(e,t,`width=${l}, height=${d}, top=${m}, left=${f}, scrollbars=yes`)}unloadWindow(e){this.browserStorage.cleanRequestByInteractionType(A.Popup),this.currentWindow&&this.currentWindow.close(),e.preventDefault()}cleanPopup(e,t){e.close(),t.removeEventListener("beforeunload",this.unloadWindow),this.browserStorage.setInteractionInProgress(!1)}generatePopupName(e,t){return`${$.POPUP_NAME_PREFIX}.${this.config.auth.clientId}.${e.join("-")}.${t}.${this.correlationId}`}generateLogoutPopupName(e){const t=e.account&&e.account.homeAccountId;return`${$.POPUP_NAME_PREFIX}.${this.config.auth.clientId}.${t}.${this.correlationId}`}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class ko{constructor(e,t,n,o,r){this.authModule=e,this.browserStorage=t,this.authCodeRequest=n,this.logger=o,this.performanceClient=r}async initiateAuthRequest(e,t){if(this.logger.verbose("RedirectHandler.initiateAuthRequest called"),e){t.redirectStartPage&&(this.logger.verbose("RedirectHandler.initiateAuthRequest: redirectStartPage set, caching start page"),this.browserStorage.setTemporaryCache(k.ORIGIN_URI,t.redirectStartPage,!0)),this.browserStorage.setTemporaryCache(k.CORRELATION_ID,this.authCodeRequest.correlationId,!0),this.browserStorage.cacheCodeRequest(this.authCodeRequest),this.logger.infoPii(`RedirectHandler.initiateAuthRequest: Navigate to: ${e}`);const n={apiId:O.acquireTokenRedirect,timeout:t.redirectTimeout,noHistory:!1};if(typeof t.onRedirectNavigate=="function")if(this.logger.verbose("RedirectHandler.initiateAuthRequest: Invoking onRedirectNavigate callback"),t.onRedirectNavigate(e)!==!1){this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate did not return false, navigating"),await t.navigationClient.navigateExternal(e,n);return}else{this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate returned false, stopping navigation");return}else{this.logger.verbose("RedirectHandler.initiateAuthRequest: Navigating window to navigate url"),await t.navigationClient.navigateExternal(e,n);return}}else throw this.logger.info("RedirectHandler.initiateAuthRequest: Navigate url is empty"),C(_t)}async handleCodeResponse(e,t){this.logger.verbose("RedirectHandler.handleCodeResponse called"),this.browserStorage.setInteractionInProgress(!1);const n=this.browserStorage.generateStateKey(t),o=this.browserStorage.getTemporaryCache(n);if(!o)throw g(lt,"Cached State");let r;try{r=this.authModule.handleFragmentResponse(e,o)}catch(l){throw l instanceof fe&&l.subError===Ae?C(Ae):l}const i=this.browserStorage.generateNonceKey(o),s=this.browserStorage.getTemporaryCache(i);if(this.authCodeRequest.code=r.code,r.cloud_instance_host_name&&await p(this.authModule.updateAuthority.bind(this.authModule),h.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,this.authCodeRequest.correlationId)(r.cloud_instance_host_name,this.authCodeRequest.correlationId),r.nonce=s||void 0,r.state=o,r.client_info)this.authCodeRequest.clientInfo=r.client_info;else{const l=this.checkCcsCredentials();l&&(this.authCodeRequest.ccsCredential=l)}const c=await this.authModule.acquireToken(this.authCodeRequest,r);return this.browserStorage.cleanRequestByState(t),c}checkCcsCredentials(){const e=this.browserStorage.getTemporaryCache(k.CCS_CREDENTIAL,!0);if(e)try{return JSON.parse(e)}catch{this.authModule.logger.error("Cache credential could not be parsed"),this.authModule.logger.errorPii(`Cache credential could not be parsed: ${e}`)}return null}}/*! @azure/msal-browser v3.28.0 2024-12-12 */function Hc(){if(typeof window>"u"||typeof window.performance>"u"||typeof window.performance.getEntriesByType!="function")return;const a=window.performance.getEntriesByType("navigation"),e=a.length?a[0]:void 0;return e==null?void 0:e.type}class Dc extends Ke{constructor(e,t,n,o,r,i,s,c,l,d){super(e,t,n,o,r,i,s,l,d),this.nativeStorage=c}async acquireToken(e){const t=await p(this.initializeAuthorizationRequest.bind(this),h.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(e,A.Redirect);this.browserStorage.updateCacheEntries(t.state,t.nonce,t.authority,t.loginHint||"",t.account||null);const n=this.initializeServerTelemetryManager(O.acquireTokenRedirect),o=r=>{r.persisted&&(this.logger.verbose("Page was restored from back/forward cache. Clearing temporary cache."),this.browserStorage.cleanRequestByState(t.state),this.eventHandler.emitEvent(I.RESTORE_FROM_BFCACHE,A.Redirect))};try{const r=await p(this.initializeAuthorizationCodeRequest.bind(this),h.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(t),i=await p(this.createAuthCodeClient.bind(this),h.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:t.authority,requestAzureCloudOptions:t.azureCloudOptions,requestExtraQueryParameters:t.extraQueryParameters,account:t.account}),s=new ko(i,this.browserStorage,r,this.logger,this.performanceClient),c=await i.getAuthCodeUrl({...t,nativeBroker:ne.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,e.authenticationScheme)}),l=this.getRedirectStartPage(e.redirectStartPage);return this.logger.verbosePii(`Redirect start page: ${l}`),window.addEventListener("pageshow",o),await s.initiateAuthRequest(c,{navigationClient:this.navigationClient,redirectTimeout:this.config.system.redirectNavigationTimeout,redirectStartPage:l,onRedirectNavigate:e.onRedirectNavigate||this.config.auth.onRedirectNavigate})}catch(r){throw r instanceof P&&(r.setCorrelationId(this.correlationId),n.cacheFailedRequest(r)),window.removeEventListener("pageshow",o),this.browserStorage.cleanRequestByState(t.state),r}}async handleRedirectPromise(e="",t){const n=this.initializeServerTelemetryManager(O.handleRedirectPromise);try{if(!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const[o,r]=this.getRedirectResponse(e||"");if(!o)return this.logger.info("handleRedirectPromise did not detect a response as a result of a redirect. Cleaning temporary cache."),this.browserStorage.cleanRequestByInteractionType(A.Redirect),Hc()!=="back_forward"?t.event.errorCode="no_server_response":this.logger.verbose("Back navigation event detected. Muting no_server_response error"),null;const i=this.browserStorage.getTemporaryCache(k.ORIGIN_URI,!0)||u.EMPTY_STRING,s=w.removeHashFromUrl(i),c=w.removeHashFromUrl(window.location.href);if(s===c&&this.config.auth.navigateToLoginRequestUrl)return this.logger.verbose("Current page is loginRequestUrl, handling response"),i.indexOf("#")>-1&&qs(i),await this.handleResponse(o,n);if(this.config.auth.navigateToLoginRequestUrl){if(!Hn()||this.config.system.allowRedirectInIframe){this.browserStorage.setTemporaryCache(k.URL_HASH,r,!0);const l={apiId:O.handleRedirectPromise,timeout:this.config.system.redirectNavigationTimeout,noHistory:!0};let d=!0;if(!i||i==="null"){const m=Ys();this.browserStorage.setTemporaryCache(k.ORIGIN_URI,m,!0),this.logger.warning("Unable to get valid login request url from cache, redirecting to home page"),d=await this.navigationClient.navigateInternal(m,l)}else this.logger.verbose(`Navigating to loginRequestUrl: ${i}`),d=await this.navigationClient.navigateInternal(i,l);if(!d)return await this.handleResponse(o,n)}}else return this.logger.verbose("NavigateToLoginRequestUrl set to false, handling response"),await this.handleResponse(o,n);return null}catch(o){throw o instanceof P&&(o.setCorrelationId(this.correlationId),n.cacheFailedRequest(o)),this.browserStorage.cleanRequestByInteractionType(A.Redirect),o}}getRedirectResponse(e){this.logger.verbose("getRedirectResponseHash called");let t=e;t||(this.config.auth.OIDCOptions.serverResponseType===Ye.QUERY?t=window.location.search:t=window.location.hash);let n=gt(t);if(n){try{Uc(n,this.browserCrypto,A.Redirect)}catch(r){return r instanceof P&&this.logger.error(`Interaction type validation failed due to ${r.errorCode}: ${r.errorMessage}`),[null,""]}return zs(window),this.logger.verbose("Hash contains known properties, returning response hash"),[n,t]}const o=this.browserStorage.getTemporaryCache(k.URL_HASH,!0);return this.browserStorage.removeItem(this.browserStorage.generateCacheKey(k.URL_HASH)),o&&(n=gt(o),n)?(this.logger.verbose("Hash does not contain known properties, returning cached hash"),[n,o]):[null,""]}async handleResponse(e,t){const n=e.state;if(!n)throw C(Rn);const o=this.browserStorage.getCachedRequest(n);if(this.logger.verbose("handleResponse called, retrieved cached request"),e.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw C($e);const c=new Pe(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,O.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,e.accountId,this.nativeStorage,o.correlationId),{userRequestState:l}=J.parseRequestState(this.browserCrypto,n);return c.acquireToken({...o,state:l,prompt:void 0}).finally(()=>{this.browserStorage.cleanRequestByState(n)})}const r=this.browserStorage.getCachedAuthority(n);if(!r)throw C(bn);const i=await p(this.createAuthCodeClient.bind(this),h.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:t,requestAuthority:r});return ee.removeThrottle(this.browserStorage,this.config.auth.clientId,o),new ko(i,this.browserStorage,o,this.logger,this.performanceClient).handleCodeResponse(e,n)}async logout(e){var o,r;this.logger.verbose("logoutRedirect called");const t=this.initializeLogoutRequest(e),n=this.initializeServerTelemetryManager(O.logout);try{this.eventHandler.emitEvent(I.LOGOUT_START,A.Redirect,e),await this.clearCacheOnLogout(t.account);const i={apiId:O.logout,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},s=await p(this.createAuthCodeClient.bind(this),h.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:e&&e.authority,requestExtraQueryParameters:e==null?void 0:e.extraQueryParameters,account:e&&e.account||void 0});if(s.authority.protocolMode===le.OIDC)try{s.authority.endSessionEndpoint}catch{if((o=t.account)!=null&&o.homeAccountId){this.browserStorage.removeAccount((r=t.account)==null?void 0:r.homeAccountId),this.eventHandler.emitEvent(I.LOGOUT_SUCCESS,A.Redirect,t);return}}const c=s.getLogoutUri(t);if(this.eventHandler.emitEvent(I.LOGOUT_SUCCESS,A.Redirect,t),e&&typeof e.onRedirectNavigate=="function")if(e.onRedirectNavigate(c)!==!1){this.logger.verbose("Logout onRedirectNavigate did not return false, navigating"),this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),await this.navigationClient.navigateExternal(c,i);return}else this.browserStorage.setInteractionInProgress(!1),this.logger.verbose("Logout onRedirectNavigate returned false, stopping navigation");else{this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),await this.navigationClient.navigateExternal(c,i);return}}catch(i){throw i instanceof P&&(i.setCorrelationId(this.correlationId),n.cacheFailedRequest(i)),this.eventHandler.emitEvent(I.LOGOUT_FAILURE,A.Redirect,null,i),this.eventHandler.emitEvent(I.LOGOUT_END,A.Redirect),i}this.eventHandler.emitEvent(I.LOGOUT_END,A.Redirect)}getRedirectStartPage(e){const t=e||window.location.href;return w.getAbsoluteUrl(t,ce())}}/*! @azure/msal-browser v3.28.0 2024-12-12 */async function Kc(a,e,t,n,o){if(e.addQueueMeasurement(h.SilentHandlerInitiateAuthRequest,n),!a)throw t.info("Navigate url is empty"),C(_t);return o?p(Bc,h.SilentHandlerLoadFrame,t,e,n)(a,o,e,n):ve(Fc,h.SilentHandlerLoadFrameSync,t,e,n)(a)}async function xc(a,e,t,n,o,r,i){return n.addQueueMeasurement(h.SilentHandlerMonitorIframeForHash,r),new Promise((s,c)=>{e<Jt&&o.warning(`system.loadFrameTimeout or system.iframeHashTimeout set to lower (${e}ms) than the default (${Jt}ms). This may result in timeouts.`);const l=window.setTimeout(()=>{window.clearInterval(d),c(C(Pr))},e),d=window.setInterval(()=>{let m="";const f=a.contentWindow;try{m=f?f.location.href:""}catch{}if(!m||m==="about:blank")return;let T="";f&&(i===Ye.QUERY?T=f.location.search:T=f.location.hash),window.clearTimeout(l),window.clearInterval(d),s(T)},t)}).finally(()=>{ve(Gc,h.RemoveHiddenIframe,o,n,r)(a)})}function Bc(a,e,t,n){return t.addQueueMeasurement(h.SilentHandlerLoadFrame,n),new Promise((o,r)=>{const i=gi();window.setTimeout(()=>{if(!i){r("Unable to load iframe");return}i.src=a,o(i)},e)})}function Fc(a){const e=gi();return e.src=a,e}function gi(){const a=document.createElement("iframe");return a.className="msalSilentIframe",a.style.visibility="hidden",a.style.position="absolute",a.style.width=a.style.height="0",a.style.border="0",a.setAttribute("sandbox","allow-scripts allow-same-origin allow-forms"),document.body.appendChild(a),a}function Gc(a){document.body===a.parentNode&&document.body.removeChild(a)}/*! @azure/msal-browser v3.28.0 2024-12-12 */class zc extends Ke{constructor(e,t,n,o,r,i,s,c,l,d,m){super(e,t,n,o,r,i,c,d,m),this.apiId=s,this.nativeStorage=l}async acquireToken(e){this.performanceClient.addQueueMeasurement(h.SilentIframeClientAcquireToken,e.correlationId),!e.loginHint&&!e.sid&&(!e.account||!e.account.username)&&this.logger.warning("No user hint provided. The authorization server may need more information to complete this request.");const t={...e};t.prompt?t.prompt!==D.NONE&&t.prompt!==D.NO_SESSION&&(this.logger.warning(`SilentIframeClient. Replacing invalid prompt ${t.prompt} with ${D.NONE}`),t.prompt=D.NONE):t.prompt=D.NONE;const n=await p(this.initializeAuthorizationRequest.bind(this),h.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,e.correlationId)(t,A.Silent);si(n.authority);const o=this.initializeServerTelemetryManager(this.apiId);let r;try{return r=await p(this.createAuthCodeClient.bind(this),h.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,e.correlationId)({serverTelemetryManager:o,requestAuthority:n.authority,requestAzureCloudOptions:n.azureCloudOptions,requestExtraQueryParameters:n.extraQueryParameters,account:n.account}),await p(this.silentTokenHelper.bind(this),h.SilentIframeClientTokenHelper,this.logger,this.performanceClient,e.correlationId)(r,n)}catch(i){if(i instanceof P&&(i.setCorrelationId(this.correlationId),o.cacheFailedRequest(i)),!r||!(i instanceof P)||i.errorCode!==$.INVALID_GRANT_ERROR)throw i;this.performanceClient.addFields({retryError:i.errorCode},this.correlationId);const s=await p(this.initializeAuthorizationRequest.bind(this),h.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,e.correlationId)(t,A.Silent);return await p(this.silentTokenHelper.bind(this),h.SilentIframeClientTokenHelper,this.logger,this.performanceClient,this.correlationId)(r,s)}}logout(){return Promise.reject(C(kt))}async silentTokenHelper(e,t){const n=t.correlationId;this.performanceClient.addQueueMeasurement(h.SilentIframeClientTokenHelper,n);const o=await p(this.initializeAuthorizationCodeRequest.bind(this),h.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,n)(t),r=await p(e.getAuthCodeUrl.bind(e),h.GetAuthCodeUrl,this.logger,this.performanceClient,n)({...t,nativeBroker:ne.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),i=new Bn(e,this.browserStorage,o,this.logger,this.performanceClient),s=await p(Kc,h.SilentHandlerInitiateAuthRequest,this.logger,this.performanceClient,n)(r,this.performanceClient,this.logger,n,this.config.system.navigateFrameWait),c=this.config.auth.OIDCOptions.serverResponseType,l=await p(xc,h.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,n)(s,this.config.system.iframeHashTimeout,this.config.system.pollIntervalMilliseconds,this.performanceClient,this.logger,n,c),d=ve(ui,h.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(l,c,this.logger);if(d.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw C($e);const m=new Pe(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.apiId,this.performanceClient,this.nativeMessageHandler,d.accountId,this.browserStorage,n),{userRequestState:f}=J.parseRequestState(this.browserCrypto,t.state);return p(m.acquireToken.bind(m),h.NativeInteractionClientAcquireToken,this.logger,this.performanceClient,n)({...t,state:f,prompt:t.prompt||D.NONE})}return p(i.handleCodeResponse.bind(i),h.HandleCodeResponse,this.logger,this.performanceClient,n)(d,t)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class qc extends Ke{async acquireToken(e){this.performanceClient.addQueueMeasurement(h.SilentRefreshClientAcquireToken,e.correlationId);const t=await p(xn,h.InitializeBaseRequest,this.logger,this.performanceClient,e.correlationId)(e,this.config,this.performanceClient,this.logger),n={...e,...t};e.redirectUri&&(n.redirectUri=this.getRedirectUri(e.redirectUri));const o=this.initializeServerTelemetryManager(O.acquireTokenSilent_silentFlow),r=await this.createRefreshTokenClient({serverTelemetryManager:o,authorityUrl:n.authority,azureCloudOptions:n.azureCloudOptions,account:n.account});return p(r.acquireTokenByRefreshToken.bind(r),h.RefreshTokenClientAcquireTokenByRefreshToken,this.logger,this.performanceClient,e.correlationId)(n).catch(i=>{throw i.setCorrelationId(this.correlationId),o.cacheFailedRequest(i),i})}logout(){return Promise.reject(C(kt))}async createRefreshTokenClient(e){const t=await p(this.getClientConfiguration.bind(this),h.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:e.serverTelemetryManager,requestAuthority:e.authorityUrl,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account});return new Yt(t,this.performanceClient)}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Vc{constructor(e,t,n,o){this.isBrowserEnvironment=typeof window<"u",this.config=e,this.storage=t,this.logger=n,this.cryptoObj=o}loadExternalTokens(e,t,n){if(!this.isBrowserEnvironment)throw C(Rt);const o=t.id_token?Ee(t.id_token,oe):void 0,r={protocolMode:this.config.auth.protocolMode,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},i=e.authority?new x(x.generateAuthority(e.authority,e.azureCloudOptions),this.config.system.networkClient,this.storage,r,this.logger,e.correlationId||he()):void 0,s=this.loadAccount(e,n.clientInfo||t.client_info||"",o,i),c=this.loadIdToken(t,s.homeAccountId,s.environment,s.realm),l=this.loadAccessToken(e,t,s.homeAccountId,s.environment,s.realm,n),d=this.loadRefreshToken(t,s.homeAccountId,s.environment);return this.generateAuthenticationResult(e,{account:s,idToken:c,accessToken:l,refreshToken:d},o,i)}loadAccount(e,t,n,o){if(this.logger.verbose("TokenCache - loading account"),e.account){const c=U.createFromAccountInfo(e.account);return this.storage.setAccount(c),c}else if(!o||!t&&!n)throw this.logger.error("TokenCache - if an account is not provided on the request, authority and either clientInfo or idToken must be provided instead."),C(Fr);const r=U.generateHomeAccountId(t,o.authorityType,this.logger,this.cryptoObj,n),i=n==null?void 0:n.tid,s=Sn(this.storage,o,r,oe,n,t,o.hostnameAndPort,i,void 0,void 0,this.logger);return this.storage.setAccount(s),s}loadIdToken(e,t,n,o){if(!e.id_token)return this.logger.verbose("TokenCache - no id token found in response"),null;this.logger.verbose("TokenCache - loading id token");const r=At(t,n,e.id_token,this.config.auth.clientId,o);return this.storage.setIdTokenCredential(r),r}loadAccessToken(e,t,n,o,r,i){if(t.access_token)if(t.expires_in){if(!t.scope&&(!e.scopes||!e.scopes.length))return this.logger.error("TokenCache - scopes not specified in the request or response. Cannot add token to the cache."),null}else return this.logger.error("TokenCache - no expiration set on the access token. Cannot add it to the cache."),null;else return this.logger.verbose("TokenCache - no access token found in response"),null;this.logger.verbose("TokenCache - loading access token");const s=t.scope?M.fromString(t.scope):new M(e.scopes),c=i.expiresOn||t.expires_in+new Date().getTime()/1e3,l=i.extendedExpiresOn||(t.ext_expires_in||t.expires_in)+new Date().getTime()/1e3,d=It(n,o,t.access_token,this.config.auth.clientId,r,s.printScopes(),c,l,oe);return this.storage.setAccessTokenCredential(d),d}loadRefreshToken(e,t,n){if(!e.refresh_token)return this.logger.verbose("TokenCache - no refresh token found in response"),null;this.logger.verbose("TokenCache - loading refresh token");const o=Wo(t,n,e.refresh_token,this.config.auth.clientId,e.foci,void 0,e.refresh_token_expires_in);return this.storage.setRefreshTokenCredential(o),o}generateAuthenticationResult(e,t,n,o){var d,m,f;let r="",i=[],s=null,c;t!=null&&t.accessToken&&(r=t.accessToken.secret,i=M.fromString(t.accessToken.target).asArray(),s=new Date(Number(t.accessToken.expiresOn)*1e3),c=new Date(Number(t.accessToken.extendedExpiresOn)*1e3));const l=t.account;return{authority:o?o.canonicalAuthority:"",uniqueId:t.account.localAccountId,tenantId:t.account.realm,scopes:i,account:l.getAccountInfo(),idToken:((d=t.idToken)==null?void 0:d.secret)||"",idTokenClaims:n||{},accessToken:r,fromCache:!0,expiresOn:s,correlationId:e.correlationId||"",requestId:"",extExpiresOn:c,familyId:((m=t.refreshToken)==null?void 0:m.familyId)||"",tokenType:((f=t==null?void 0:t.accessToken)==null?void 0:f.tokenType)||"",state:e.state||"",cloudGraphHostName:l.cloudGraphHostName||"",msGraphHost:l.msGraphHost||"",fromNativeBroker:!1}}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Yc extends Ir{constructor(e){super(e),this.includeRedirectUri=!1}}/*! @azure/msal-browser v3.28.0 2024-12-12 */class $c extends Ke{constructor(e,t,n,o,r,i,s,c,l,d){super(e,t,n,o,r,i,c,l,d),this.apiId=s}async acquireToken(e){if(!e.code)throw C(Gr);const t=await p(this.initializeAuthorizationRequest.bind(this),h.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,e.correlationId)(e,A.Silent),n=this.initializeServerTelemetryManager(this.apiId);try{const o={...t,code:e.code},r=await p(this.getClientConfiguration.bind(this),h.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,e.correlationId)({serverTelemetryManager:n,requestAuthority:t.authority,requestAzureCloudOptions:t.azureCloudOptions,requestExtraQueryParameters:t.extraQueryParameters,account:t.account}),i=new Yc(r);this.logger.verbose("Auth code client created");const s=new Bn(i,this.browserStorage,o,this.logger,this.performanceClient);return await p(s.handleCodeResponseFromServer.bind(s),h.HandleCodeResponseFromServer,this.logger,this.performanceClient,e.correlationId)({code:e.code,msgraph_host:e.msGraphHost,cloud_graph_host_name:e.cloudGraphHostName,cloud_instance_host_name:e.cloudInstanceHostName},t,!1)}catch(o){throw o instanceof P&&(o.setCorrelationId(this.correlationId),n.cacheFailedRequest(o)),o}}logout(){return Promise.reject(C(kt))}}/*! @azure/msal-browser v3.28.0 2024-12-12 */function Z(a){const e=a==null?void 0:a.idTokenClaims;if(e!=null&&e.tfp||e!=null&&e.acr)return"B2C";if(e!=null&&e.tid){if((e==null?void 0:e.tid)==="9188040d-6c67-4c5b-b112-36a304b66dad")return"MSA"}else return;return"AAD"}function at(a,e){try{Dn(a)}catch(t){throw e.end({success:!1},t),t}}class Nt{constructor(e){this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.initialized=!1,this.logger=this.operatingContext.getLogger(),this.networkClient=this.config.system.networkClient,this.navigationClient=this.config.system.navigationClient,this.redirectResponse=new Map,this.hybridAuthCodeResponses=new Map,this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new He(this.logger,this.performanceClient):ht,this.eventHandler=new Tc(this.logger),this.browserStorage=this.isBrowserEnvironment?new Zt(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,ss(this.config.auth),this.performanceClient):dc(this.config.auth.clientId,this.logger);const t={cacheLocation:q.MemoryStorage,temporaryCacheLocation:q.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1};this.nativeInternalStorage=new Zt(this.config.auth.clientId,t,this.browserCrypto,this.logger,void 0,this.performanceClient),this.tokenCache=new Vc(this.config,this.browserStorage,this.logger,this.browserCrypto),this.activeSilentTokenRequests=new Map,this.trackPageVisibility=this.trackPageVisibility.bind(this),this.trackPageVisibilityWithMeasurement=this.trackPageVisibilityWithMeasurement.bind(this),this.listeningToStorageEvents=!1,this.handleAccountCacheChange=this.handleAccountCacheChange.bind(this)}static async createController(e,t){const n=new Nt(e);return await n.initialize(t),n}trackPageVisibility(e){e&&(this.logger.info("Perf: Visibility change detected"),this.performanceClient.incrementFields({visibilityChangeCount:1},e))}async initialize(e){if(this.logger.trace("initialize called"),this.initialized){this.logger.info("initialize has already been called, exiting early.");return}if(!this.isBrowserEnvironment){this.logger.info("in non-browser environment, exiting early."),this.initialized=!0,this.eventHandler.emitEvent(I.INITIALIZE_END);return}const t=(e==null?void 0:e.correlationId)||this.getRequestCorrelationId(),n=this.config.system.allowNativeBroker,o=this.performanceClient.startMeasurement(h.InitializeClientApplication,t);if(this.eventHandler.emitEvent(I.INITIALIZE_START),n)try{this.nativeExtensionProvider=await ne.createProvider(this.logger,this.config.system.nativeBrokerHandshakeTimeout,this.performanceClient)}catch(r){this.logger.verbose(r)}this.config.cache.claimsBasedCachingEnabled||(this.logger.verbose("Claims-based caching is disabled. Clearing the previous cache with claims"),await p(this.browserStorage.clearTokensAndKeysWithClaims.bind(this.browserStorage),h.ClearTokensAndKeysWithClaims,this.logger,this.performanceClient,t)(this.performanceClient,t)),this.initialized=!0,this.eventHandler.emitEvent(I.INITIALIZE_END),o.end({allowNativeBroker:n,success:!0})}async handleRedirectPromise(e){if(this.logger.verbose("handleRedirectPromise called"),ai(this.initialized),this.isBrowserEnvironment){const t=e||"";let n=this.redirectResponse.get(t);return typeof n>"u"?(n=this.handleRedirectPromiseInternal(e),this.redirectResponse.set(t,n),this.logger.verbose("handleRedirectPromise has been called for the first time, storing the promise")):this.logger.verbose("handleRedirectPromise has been called previously, returning the result from the first call"),n}return this.logger.verbose("handleRedirectPromise returns null, not browser environment"),null}async handleRedirectPromiseInternal(e){const t=this.getAllAccounts(),n=this.browserStorage.getCachedNativeRequest(),o=n&&ne.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider)&&this.nativeExtensionProvider&&!e,r=o?n==null?void 0:n.correlationId:this.browserStorage.getTemporaryCache(k.CORRELATION_ID,!0)||"",i=this.performanceClient.startMeasurement(h.AcquireTokenRedirect,r);this.eventHandler.emitEvent(I.HANDLE_REDIRECT_START,A.Redirect);let s;if(o&&this.nativeExtensionProvider){this.logger.trace("handleRedirectPromise - acquiring token from native platform");const c=new Pe(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,O.handleRedirectPromise,this.performanceClient,this.nativeExtensionProvider,n.accountId,this.nativeInternalStorage,n.correlationId);s=p(c.handleRedirectPromise.bind(c),h.HandleNativeRedirectPromiseMeasurement,this.logger,this.performanceClient,i.event.correlationId)(this.performanceClient,i.event.correlationId)}else{this.logger.trace("handleRedirectPromise - acquiring token from web flow");const c=this.createRedirectClient(r);s=p(c.handleRedirectPromise.bind(c),h.HandleRedirectPromiseMeasurement,this.logger,this.performanceClient,i.event.correlationId)(e,i)}return s.then(c=>(c?(t.length<this.getAllAccounts().length?(this.eventHandler.emitEvent(I.LOGIN_SUCCESS,A.Redirect,c),this.logger.verbose("handleRedirectResponse returned result, login success")):(this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_SUCCESS,A.Redirect,c),this.logger.verbose("handleRedirectResponse returned result, acquire token success")),i.end({success:!0,accountType:Z(c.account)})):i.event.errorCode?i.end({success:!1}):i.discard(),this.eventHandler.emitEvent(I.HANDLE_REDIRECT_END,A.Redirect),c)).catch(c=>{const l=c;throw t.length>0?this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_FAILURE,A.Redirect,null,l):this.eventHandler.emitEvent(I.LOGIN_FAILURE,A.Redirect,null,l),this.eventHandler.emitEvent(I.HANDLE_REDIRECT_END,A.Redirect),i.end({success:!1},l),c})}async acquireTokenRedirect(e){const t=this.getRequestCorrelationId(e);this.logger.verbose("acquireTokenRedirect called",t);const n=this.performanceClient.startMeasurement(h.AcquireTokenPreRedirect,t);n.add({accountType:Z(e.account),scenarioId:e.scenarioId});const o=e.onRedirectNavigate;if(o)e.onRedirectNavigate=i=>{const s=typeof o=="function"?o(i):void 0;return s!==!1?n.end({success:!0}):n.discard(),s};else{const i=this.config.auth.onRedirectNavigate;this.config.auth.onRedirectNavigate=s=>{const c=typeof i=="function"?i(s):void 0;return c!==!1?n.end({success:!0}):n.discard(),c}}const r=this.getAllAccounts().length>0;try{vo(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0),r?this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_START,A.Redirect,e):this.eventHandler.emitEvent(I.LOGIN_START,A.Redirect,e);let i;return this.nativeExtensionProvider&&this.canUseNative(e)?i=new Pe(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,O.acquireTokenRedirect,this.performanceClient,this.nativeExtensionProvider,this.getNativeAccountId(e),this.nativeInternalStorage,t).acquireTokenRedirect(e,n).catch(c=>{if(c instanceof te&&ke(c))return this.nativeExtensionProvider=void 0,this.createRedirectClient(t).acquireToken(e);if(c instanceof X)return this.logger.verbose("acquireTokenRedirect - Resolving interaction required error thrown by native broker by falling back to web flow"),this.createRedirectClient(t).acquireToken(e);throw this.browserStorage.setInteractionInProgress(!1),c}):i=this.createRedirectClient(t).acquireToken(e),await i}catch(i){throw n.end({success:!1},i),r?this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_FAILURE,A.Redirect,null,i):this.eventHandler.emitEvent(I.LOGIN_FAILURE,A.Redirect,null,i),i}}acquireTokenPopup(e){const t=this.getRequestCorrelationId(e),n=this.performanceClient.startMeasurement(h.AcquireTokenPopup,t);n.add({scenarioId:e.scenarioId,accountType:Z(e.account)});try{this.logger.verbose("acquireTokenPopup called",t),at(this.initialized,n),this.browserStorage.setInteractionInProgress(!0)}catch(i){return Promise.reject(i)}const o=this.getAllAccounts();o.length>0?this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_START,A.Popup,e):this.eventHandler.emitEvent(I.LOGIN_START,A.Popup,e);let r;return this.canUseNative(e)?r=this.acquireTokenNative({...e,correlationId:t},O.acquireTokenPopup).then(i=>(this.browserStorage.setInteractionInProgress(!1),n.end({success:!0,isNativeBroker:!0,accountType:Z(i.account)}),i)).catch(i=>{if(i instanceof te&&ke(i))return this.nativeExtensionProvider=void 0,this.createPopupClient(t).acquireToken(e);if(i instanceof X)return this.logger.verbose("acquireTokenPopup - Resolving interaction required error thrown by native broker by falling back to web flow"),this.createPopupClient(t).acquireToken(e);throw this.browserStorage.setInteractionInProgress(!1),i}):r=this.createPopupClient(t).acquireToken(e),r.then(i=>(o.length<this.getAllAccounts().length?this.eventHandler.emitEvent(I.LOGIN_SUCCESS,A.Popup,i):this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_SUCCESS,A.Popup,i),n.end({success:!0,accessTokenSize:i.accessToken.length,idTokenSize:i.idToken.length,accountType:Z(i.account)}),i)).catch(i=>(o.length>0?this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_FAILURE,A.Popup,null,i):this.eventHandler.emitEvent(I.LOGIN_FAILURE,A.Popup,null,i),n.end({success:!1},i),Promise.reject(i)))}trackPageVisibilityWithMeasurement(){const e=this.ssoSilentMeasurement||this.acquireTokenByCodeAsyncMeasurement;e&&(this.logger.info("Perf: Visibility change detected in ",e.event.name),e.increment({visibilityChangeCount:1}))}async ssoSilent(e){var r,i;const t=this.getRequestCorrelationId(e),n={...e,prompt:e.prompt,correlationId:t};this.ssoSilentMeasurement=this.performanceClient.startMeasurement(h.SsoSilent,t),(r=this.ssoSilentMeasurement)==null||r.add({scenarioId:e.scenarioId,accountType:Z(e.account)}),at(this.initialized,this.ssoSilentMeasurement),(i=this.ssoSilentMeasurement)==null||i.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement),this.logger.verbose("ssoSilent called",t),this.eventHandler.emitEvent(I.SSO_SILENT_START,A.Silent,n);let o;return this.canUseNative(n)?o=this.acquireTokenNative(n,O.ssoSilent).catch(s=>{if(s instanceof te&&ke(s))return this.nativeExtensionProvider=void 0,this.createSilentIframeClient(n.correlationId).acquireToken(n);throw s}):o=this.createSilentIframeClient(n.correlationId).acquireToken(n),o.then(s=>{var c;return this.eventHandler.emitEvent(I.SSO_SILENT_SUCCESS,A.Silent,s),(c=this.ssoSilentMeasurement)==null||c.end({success:!0,isNativeBroker:s.fromNativeBroker,accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length,accountType:Z(s.account)}),s}).catch(s=>{var c;throw this.eventHandler.emitEvent(I.SSO_SILENT_FAILURE,A.Silent,null,s),(c=this.ssoSilentMeasurement)==null||c.end({success:!1},s),s}).finally(()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)})}async acquireTokenByCode(e){const t=this.getRequestCorrelationId(e);this.logger.trace("acquireTokenByCode called",t);const n=this.performanceClient.startMeasurement(h.AcquireTokenByCode,t);at(this.initialized,n),this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_BY_CODE_START,A.Silent,e),n.add({scenarioId:e.scenarioId});try{if(e.code&&e.nativeAccountId)throw C(qr);if(e.code){const o=e.code;let r=this.hybridAuthCodeResponses.get(o);return r?(this.logger.verbose("Existing acquireTokenByCode request found",t),n.discard()):(this.logger.verbose("Initiating new acquireTokenByCode request",t),r=this.acquireTokenByCodeAsync({...e,correlationId:t}).then(i=>(this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_BY_CODE_SUCCESS,A.Silent,i),this.hybridAuthCodeResponses.delete(o),n.end({success:!0,isNativeBroker:i.fromNativeBroker,accessTokenSize:i.accessToken.length,idTokenSize:i.idToken.length,accountType:Z(i.account)}),i)).catch(i=>{throw this.hybridAuthCodeResponses.delete(o),this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_BY_CODE_FAILURE,A.Silent,null,i),n.end({success:!1},i),i}),this.hybridAuthCodeResponses.set(o,r)),await r}else if(e.nativeAccountId)if(this.canUseNative(e,e.nativeAccountId)){const o=await this.acquireTokenNative({...e,correlationId:t},O.acquireTokenByCode,e.nativeAccountId).catch(r=>{throw r instanceof te&&ke(r)&&(this.nativeExtensionProvider=void 0),r});return n.end({accountType:Z(o.account),success:!0}),o}else throw C(Vr);else throw C(zr)}catch(o){throw this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_BY_CODE_FAILURE,A.Silent,null,o),n.end({success:!1},o),o}}async acquireTokenByCodeAsync(e){var o;return this.logger.trace("acquireTokenByCodeAsync called",e.correlationId),this.acquireTokenByCodeAsyncMeasurement=this.performanceClient.startMeasurement(h.AcquireTokenByCodeAsync,e.correlationId),(o=this.acquireTokenByCodeAsyncMeasurement)==null||o.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement),await this.createSilentAuthCodeClient(e.correlationId).acquireToken(e).then(r=>{var i;return(i=this.acquireTokenByCodeAsyncMeasurement)==null||i.end({success:!0,fromCache:r.fromCache,isNativeBroker:r.fromNativeBroker}),r}).catch(r=>{var i;throw(i=this.acquireTokenByCodeAsyncMeasurement)==null||i.end({success:!1},r),r}).finally(()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)})}async acquireTokenFromCache(e,t){switch(this.performanceClient.addQueueMeasurement(h.AcquireTokenFromCache,e.correlationId),t){case Y.Default:case Y.AccessToken:case Y.AccessTokenAndRefreshToken:const n=this.createSilentCacheClient(e.correlationId);return p(n.acquireToken.bind(n),h.SilentCacheClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw g(se)}}async acquireTokenByRefreshToken(e,t){switch(this.performanceClient.addQueueMeasurement(h.AcquireTokenByRefreshToken,e.correlationId),t){case Y.Default:case Y.AccessTokenAndRefreshToken:case Y.RefreshToken:case Y.RefreshTokenAndNetwork:const n=this.createSilentRefreshClient(e.correlationId);return p(n.acquireToken.bind(n),h.SilentRefreshClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw g(se)}}async acquireTokenBySilentIframe(e){this.performanceClient.addQueueMeasurement(h.AcquireTokenBySilentIframe,e.correlationId);const t=this.createSilentIframeClient(e.correlationId);return p(t.acquireToken.bind(t),h.SilentIframeClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e)}async logout(e){const t=this.getRequestCorrelationId(e);return this.logger.warning("logout API is deprecated and will be removed in msal-browser v3.0.0. Use logoutRedirect instead.",t),this.logoutRedirect({correlationId:t,...e})}async logoutRedirect(e){const t=this.getRequestCorrelationId(e);return vo(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0),this.createRedirectClient(t).logout(e)}logoutPopup(e){try{const t=this.getRequestCorrelationId(e);return Dn(this.initialized),this.browserStorage.setInteractionInProgress(!0),this.createPopupClient(t).logout(e)}catch(t){return Promise.reject(t)}}async clearCache(e){if(!this.isBrowserEnvironment){this.logger.info("in non-browser environment, returning early.");return}const t=this.getRequestCorrelationId(e);return this.createSilentCacheClient(t).logout(e)}getAllAccounts(e){return uc(this.logger,this.browserStorage,this.isBrowserEnvironment,e)}getAccount(e){return gc(e,this.logger,this.browserStorage)}getAccountByUsername(e){return mc(e,this.logger,this.browserStorage)}getAccountByHomeId(e){return pc(e,this.logger,this.browserStorage)}getAccountByLocalId(e){return fc(e,this.logger,this.browserStorage)}setActiveAccount(e){Cc(e,this.browserStorage)}getActiveAccount(){return yc(this.browserStorage)}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const n=U.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return this.browserStorage.setAccount(n),e.fromNativeBroker?(this.logger.verbose("Response was from native broker, storing in-memory"),this.nativeInternalStorage.hydrateCache(e,t)):this.browserStorage.hydrateCache(e,t)}async acquireTokenNative(e,t,n){if(this.logger.trace("acquireTokenNative called"),!this.nativeExtensionProvider)throw C($e);return new Pe(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,t,this.performanceClient,this.nativeExtensionProvider,n||this.getNativeAccountId(e),this.nativeInternalStorage,e.correlationId).acquireToken(e)}canUseNative(e,t){if(this.logger.trace("canUseNative called"),!ne.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider,e.authenticationScheme))return this.logger.trace("canUseNative: isNativeAvailable returned false, returning false"),!1;if(e.prompt)switch(e.prompt){case D.NONE:case D.CONSENT:case D.LOGIN:this.logger.trace("canUseNative: prompt is compatible with native flow");break;default:return this.logger.trace(`canUseNative: prompt = ${e.prompt} is not compatible with native flow, returning false`),!1}return!t&&!this.getNativeAccountId(e)?(this.logger.trace("canUseNative: nativeAccountId is not available, returning false"),!1):!0}getNativeAccountId(e){const t=e.account||this.getAccount({loginHint:e.loginHint,sid:e.sid})||this.getActiveAccount();return t&&t.nativeAccountId||""}createPopupClient(e){return new Lc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createRedirectClient(e){return new Dc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentIframeClient(e){return new zc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,O.ssoSilent,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentCacheClient(e){return new di(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentRefreshClient(e){return new qc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentAuthCodeClient(e){return new $c(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,O.acquireTokenByCode,this.performanceClient,this.nativeExtensionProvider,e)}addEventCallback(e,t){return this.eventHandler.addEventCallback(e,t)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){return ii(),this.performanceClient.addPerformanceCallback(e)}removePerformanceCallback(e){return this.performanceClient.removePerformanceCallback(e)}enableAccountStorageEvents(){typeof window>"u"||(this.listeningToStorageEvents?this.logger.verbose("Account storage listener already registered."):(this.logger.verbose("Adding account storage listener."),this.listeningToStorageEvents=!0,window.addEventListener("storage",this.handleAccountCacheChange)))}disableAccountStorageEvents(){typeof window>"u"||(this.listeningToStorageEvents?(this.logger.verbose("Removing account storage listener."),window.removeEventListener("storage",this.handleAccountCacheChange),this.listeningToStorageEvents=!1):this.logger.verbose("No account storage listener registered."))}handleAccountCacheChange(e){var t;try{(t=e.key)!=null&&t.includes(H.ACTIVE_ACCOUNT_FILTERS)&&this.eventHandler.emitEvent(I.ACTIVE_ACCOUNT_CHANGED);const n=e.newValue||e.oldValue;if(!n)return;const o=JSON.parse(n);if(typeof o!="object"||!U.isAccountEntity(o))return;const i=Ue.toObject(new U,o).getAccountInfo();!e.oldValue&&e.newValue?(this.logger.info("Account was added to cache in a different window"),this.eventHandler.emitEvent(I.ACCOUNT_ADDED,void 0,i)):!e.newValue&&e.oldValue&&(this.logger.info("Account was removed from cache in a different window"),this.eventHandler.emitEvent(I.ACCOUNT_REMOVED,void 0,i))}catch{return}}getTokenCache(){return this.tokenCache}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){this.navigationClient=e}getConfiguration(){return this.config}getPerformanceClient(){return this.performanceClient}isBrowserEnv(){return this.isBrowserEnvironment}getRequestCorrelationId(e){return e!=null&&e.correlationId?e.correlationId:this.isBrowserEnvironment?he():u.EMPTY_STRING}async loginRedirect(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginRedirect called",t),this.acquireTokenRedirect({correlationId:t,...e||Ao})}loginPopup(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginPopup called",t),this.acquireTokenPopup({correlationId:t,...e||Ao})}async acquireTokenSilent(e){const t=this.getRequestCorrelationId(e),n=this.performanceClient.startMeasurement(h.AcquireTokenSilent,t);n.add({cacheLookupPolicy:e.cacheLookupPolicy,scenarioId:e.scenarioId}),at(this.initialized,n),this.logger.verbose("acquireTokenSilent called",t);const o=e.account||this.getActiveAccount();if(!o)throw C(Hr);n.add({accountType:Z(o)});const r={clientId:this.config.auth.clientId,authority:e.authority||u.EMPTY_STRING,scopes:e.scopes,homeAccountIdentifier:o.homeAccountId,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid,shrOptions:e.shrOptions},i=JSON.stringify(r),s=this.activeSilentTokenRequests.get(i);if(typeof s>"u"){this.logger.verbose("acquireTokenSilent called for the first time, storing active request",t);const c=p(this.acquireTokenSilentAsync.bind(this),h.AcquireTokenSilentAsync,this.logger,this.performanceClient,t)({...e,correlationId:t},o).then(l=>(this.activeSilentTokenRequests.delete(i),n.end({success:!0,fromCache:l.fromCache,isNativeBroker:l.fromNativeBroker,cacheLookupPolicy:e.cacheLookupPolicy,accessTokenSize:l.accessToken.length,idTokenSize:l.idToken.length}),l)).catch(l=>{throw this.activeSilentTokenRequests.delete(i),n.end({success:!1},l),l});return this.activeSilentTokenRequests.set(i,c),{...await c,state:e.state}}else return this.logger.verbose("acquireTokenSilent has been called previously, returning the result from the first call",t),n.discard(),{...await s,state:e.state}}async acquireTokenSilentAsync(e,t){const n=()=>this.trackPageVisibility(e.correlationId);this.performanceClient.addQueueMeasurement(h.AcquireTokenSilentAsync,e.correlationId),this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_START,A.Silent,e),e.correlationId&&this.performanceClient.incrementFields({visibilityChangeCount:0},e.correlationId),document.addEventListener("visibilitychange",n);const o=await p(Sc,h.InitializeSilentRequest,this.logger,this.performanceClient,e.correlationId)(e,t,this.config,this.performanceClient,this.logger),r=e.cacheLookupPolicy||Y.Default;return this.acquireTokenSilentNoIframe(o,r).catch(async s=>{if(Qc(s,r))if(this.activeIframeRequest)if(r!==Y.Skip){const[l,d]=this.activeIframeRequest;this.logger.verbose(`Iframe request is already in progress, awaiting resolution for request with correlationId: ${d}`,o.correlationId);const m=this.performanceClient.startMeasurement(h.AwaitConcurrentIframe,o.correlationId);m.add({awaitIframeCorrelationId:d});const f=await l;if(m.end({success:f}),f)return this.logger.verbose(`Parallel iframe request with correlationId: ${d} succeeded. Retrying cache and/or RT redemption`,o.correlationId),this.acquireTokenSilentNoIframe(o,r);throw this.logger.info(`Iframe request with correlationId: ${d} failed. Interaction is required.`),s}else return this.logger.warning("Another iframe request is currently in progress and CacheLookupPolicy is set to Skip. This may result in degraded performance and/or reliability for both calls. Please consider changing the CacheLookupPolicy to take advantage of request queuing and token cache.",o.correlationId),p(this.acquireTokenBySilentIframe.bind(this),h.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o);else{let l;return this.activeIframeRequest=[new Promise(d=>{l=d}),o.correlationId],this.logger.verbose("Refresh token expired/invalid or CacheLookupPolicy is set to Skip, attempting acquire token by iframe.",o.correlationId),p(this.acquireTokenBySilentIframe.bind(this),h.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o).then(d=>(l(!0),d)).catch(d=>{throw l(!1),d}).finally(()=>{this.activeIframeRequest=void 0})}else throw s}).then(s=>(this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_SUCCESS,A.Silent,s),e.correlationId&&this.performanceClient.addFields({fromCache:s.fromCache,isNativeBroker:s.fromNativeBroker},e.correlationId),s)).catch(s=>{throw this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_FAILURE,A.Silent,null,s),s}).finally(()=>{document.removeEventListener("visibilitychange",n)})}async acquireTokenSilentNoIframe(e,t){return ne.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider,e.authenticationScheme)&&e.account.nativeAccountId?(this.logger.verbose("acquireTokenSilent - attempting to acquire token from native platform"),this.acquireTokenNative(e,O.acquireTokenSilent_silentFlow).catch(async n=>{throw n instanceof te&&ke(n)?(this.logger.verbose("acquireTokenSilent - native platform unavailable, falling back to web flow"),this.nativeExtensionProvider=void 0,g(se)):n})):(this.logger.verbose("acquireTokenSilent - attempting to acquire token from web flow"),p(this.acquireTokenFromCache.bind(this),h.AcquireTokenFromCache,this.logger,this.performanceClient,e.correlationId)(e,t).catch(n=>{if(t===Y.AccessToken)throw n;return this.eventHandler.emitEvent(I.ACQUIRE_TOKEN_NETWORK_START,A.Silent,e),p(this.acquireTokenByRefreshToken.bind(this),h.AcquireTokenByRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,t)}))}}function Qc(a,e){const t=!(a instanceof X&&a.subError!==wt),n=a.errorCode===$.INVALID_GRANT_ERROR||a.errorCode===se,o=t&&n||a.errorCode===pt||a.errorCode===vn,r=Ns.includes(e);return o&&r}/*! @azure/msal-browser v3.28.0 2024-12-12 */async function Wc(a,e){const t=new Ie(a);return await t.initialize(),Nt.createController(t,e)}/*! @azure/msal-browser v3.28.0 2024-12-12 */class Fn{static async createPublicClientApplication(e){const t=await Wc(e);return new Fn(e,t)}constructor(e,t){this.controller=t||new Nt(new Ie(e))}async initialize(e){return this.controller.initialize(e)}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e,t){return this.controller.addEventCallback(e,t)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}const jc={class:"container mt-5"},Jc={class:"bg-light p-5 rounded mt-3"},Xc={class:"text-center"},Zc={class:"text-center mt-4"},el=["disabled"],tl={key:0,class:"fa fa-fw fa-sign-in-alt"},nl={key:1,class:"spinner-border spinner-border-sm","aria-hidden":"true"},ol={key:0,class:"container mt-5"},rl={class:"col-sm-6 offset-sm-3"},il={class:"mb-3"},al=["readonly"],sl=["disabled"],hl={__name:"LoginView",props:{query:{type:Object,default:()=>({})}},setup(a){const t=a.query,n=Ei(),o=fi(),r=new Fn(o.msalConfig),i={scopes:["user.read"]},s=Vn({banner_id:null,environment:"DEV"}),c=Vn(!1),l=async v=>{var y;try{c.value=!0,await r.initialize();const _=await r.loginPopup(i);$n.EMAILS_FABRICA.includes(_.account.username)&&(_.account.username=$n.DEFAULT_EMAIL),o.setUser(_.account),o.setAccessToken(_.accessToken),await T();const L=await o.clientCredentials();o.setToken(L),await o.login(v.banner_id);const z=await o.auth((y=o==null?void 0:o.user)==null?void 0:y.banner_id);t.formId?await d(t.formId):z?await f():await m()}catch(_){_i(_),localStorage.clear()}finally{c.value=!1}},d=async v=>{await n.push({name:vi.name,params:{id:v}})},m=async()=>{await n.push({name:Si.name})},f=async()=>{await n.push({name:wi.name})},T=async()=>{try{await o.photo()}catch{o.setUserPhoto(ki)}};return(v,y)=>(Xe(),Je(Ii,null,[F("div",jc,[F("div",Jc,[F("h1",Xc,Ci(Yn(Qn).NAME),1),F("form",Zc,[F("button",{type:"button",class:"btn btn-danger",disabled:c.value,onClick:y[0]||(y[0]=_=>l(s.value))},[c.value?Pt("",!0):(Xe(),Je("i",tl)),c.value?(Xe(),Je("span",nl)):Pt("",!0),y[4]||(y[4]=xe(" Ingresar "))],8,el)])])]),s.value.environment===Yn(Qn).DEV?(Xe(),Je("div",ol,[F("div",rl,[y[6]||(y[6]=F("ul",{class:"text-muted"},[F("li",null,[xe("Usuario (Ej: banner_id: "),F("b",null,"00105941"),xe(")")]),F("li",null,[xe("Administrador (Ej: banner_id: "),F("b",null,"00211508"),xe(")")])],-1)),F("div",il,[y[5]||(y[5]=F("label",{for:"banner",class:"form-label"}," Código Banner ",-1)),yi(F("input",{id:"banner","onUpdate:modelValue":y[1]||(y[1]=_=>s.value.banner_id=_),class:"form-control",type:"text",readonly:c.value,onKeyup:y[2]||(y[2]=Ai(_=>l(s.value),["enter"]))},null,40,al),[[Ti,s.value.banner_id]])]),F("button",{type:"button",class:"btn btn-primary",disabled:c.value,onClick:y[3]||(y[3]=_=>l(s.value))}," Ingresar ",8,sl)])])):Pt("",!0)],64))}};export{hl as default};
